/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DWF_DF_16_Resolver
extends AbstractCapellaMarkerResolution {
    private final String PROCESS_ICON = "icons/full/obj16/capella_process.gif";
    private String overridenLabel;

    public DWF_DF_16_Resolver(String label) {
        this.overridenLabel = label;
        super.setContributorId("org.polarsys.capella.core.ui.resources");
        super.setImgKey("icons/full/obj16/capella_process.gif");
    }

    public void run(IMarker marker) {
        List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty() && modelElements.get(0) instanceof SequenceLink) {
            this.openEditWizard((SequenceLink)modelElements.get(0), marker);
        }
    }

    private void openEditWizard(SequenceLink semanticElement, IMarker marker) {
        boolean ok = CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)semanticElement);
        if (ok && this.hasCondition(semanticElement)) {
            this.deleteMarker(marker);
        }
    }

    protected void deleteMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, PluginActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
        }
    }

    private boolean hasCondition(SequenceLink seqLink) {
        boolean hasCondition = false;
        if (seqLink.getCondition() != null) {
            String constraint = CapellaServices.getService().getConstraintLabel(seqLink.getCondition());
            hasCondition = !constraint.isEmpty();
        }
        return hasCondition;
    }

    public String getLabel() {
        return this.overridenLabel;
    }
}

