/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.ui.quickfix.FaQuickFixActivator;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public abstract class GenerateInterfacesResolver
extends AbstractCapellaMarkerResolution {
    private static final String[] unqualifiedRuleID = new String[]{"DWF_I_23"};

    protected boolean quickFixAllSimilarEnabled(Collection<IMarker> markers) {
        return false;
    }

    protected String[] getResolvableRuleIds() {
        return unqualifiedRuleID;
    }

    protected boolean canResolve(IMarker marker) {
        ConstraintStatusDiagnostic d = (ConstraintStatusDiagnostic)marker.getAdapter(Diagnostic.class);
        IConstraintStatus status = d.getConstraintStatus();
        return status.getConstraint().getDescriptor().getId().equals("org.polarsys.capella.core.projection.interfaces.DWF_I_23");
    }

    public final void run(IMarker marker) {
        ConstraintStatusDiagnostic d = (ConstraintStatusDiagnostic)marker.getAdapter(Diagnostic.class);
        IConstraintStatus status = d.getConstraintStatus();
        ExchangeItem exchangeItem = null;
        Interface iface = null;
        ArrayList<EObject> exchanges = new ArrayList<EObject>();
        for (EObject e : status.getResultLocus()) {
            if (e instanceof FunctionalExchange) {
                exchanges.add((EObject)((FunctionalExchange)e));
                continue;
            }
            if (e instanceof ComponentExchange) {
                exchanges.add((EObject)((ComponentExchange)e));
                continue;
            }
            if (e instanceof ExchangeItem) {
                exchangeItem = (ExchangeItem)e;
                continue;
            }
            if (!(e instanceof Interface)) continue;
            iface = (Interface)e;
        }
        if (this.run(exchangeItem, iface, exchanges, status.getCode(), marker)) {
            try {
                marker.delete();
            }
            catch (CoreException e1) {
                FaQuickFixActivator.getDefault().getLog().log((IStatus)new Status(4, FaQuickFixActivator.getDefault().getBundle().getSymbolicName(), e1.getStatus().getMessage(), e1.getStatus().getException()));
            }
        }
    }

    protected abstract boolean run(ExchangeItem var1, Interface var2, List<EObject> var3, int var4, IMarker var5);
}

