/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.mdsofa.common.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.IUserEnforcedHelper;
import org.polarsys.capella.common.mdsofa.common.helper.ProjectHelper;

public class FileHelper {
    private static final Logger logger = Logger.getLogger((String)FileHelper.class.getPackage().getName());

    private FileHelper() {
    }

    public static URL getFileFullUrl(String fileRelativePath) {
        URI fileFullUri = FileHelper.getFileFullUri(fileRelativePath);
        if (fileFullUri != null) {
            return FileHelper.getFileFullUrl(fileFullUri);
        }
        return null;
    }

    public static URL getFileFullUrl(URI fileFullUri) {
        URL result = null;
        try {
            result = FileLocator.resolve((URL)new URL(fileFullUri.toString()));
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.getFileFullPath(..) _ ");
            loggerMessage.append("Unable to resolve the url for ").append(fileFullUri.toString());
            logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return result;
    }

    public static URI getFileFullUri(String fileRelativePath) {
        URI fileUri = null;
        if (fileRelativePath == null) {
            return fileUri;
        }
        Path path = new Path(fileRelativePath);
        IProject project = ProjectHelper.getProject(path.segment(0));
        fileUri = project != null && project.exists() ? URI.createPlatformResourceURI((String)fileRelativePath, (boolean)true) : URI.createPlatformPluginURI((String)fileRelativePath, (boolean)true);
        return fileUri;
    }

    public static String convertPackageNameToFolderPath(String packageName) {
        String result = null;
        if (packageName != null) {
            result = packageName.replace('.', '/');
        }
        return result;
    }

    public static byte[] readFile(InputStream inputStream) {
        byte[] buffer;
        block12: {
            buffer = null;
            try {
                try {
                    int readBytes;
                    int sizeToRead = inputStream.available();
                    buffer = new byte[sizeToRead];
                    int totalReadBytes = readBytes = inputStream.read(buffer);
                    while (readBytes != -1 && totalReadBytes < sizeToRead) {
                        readBytes = inputStream.read(buffer, totalReadBytes, sizeToRead - totalReadBytes);
                        if (readBytes == -1) continue;
                        totalReadBytes += readBytes;
                    }
                }
                catch (Exception exception) {
                    StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                    loggerMessage.append("Failed to read the input stream ! ");
                    logger.warn((Object)loggerMessage.toString());
                    try {
                        inputStream.close();
                    }
                    catch (IOException exception2) {
                        StringBuilder loggerMessage2 = new StringBuilder("FileHelper.readFile(..) _ ");
                        loggerMessage2.append("Failed to close input stream ! ");
                        logger.warn((Object)loggerMessage2.toString(), (Throwable)exception2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                    loggerMessage.append("Failed to close input stream ! ");
                    logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException exception) {
                StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                loggerMessage.append("Failed to close input stream ! ");
                logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            }
        }
        return buffer == null ? new byte[]{} : buffer;
    }

    public static String readFile(String filePath) throws UnsupportedEncodingException {
        byte[] rawContent = FileHelper.readRawFile(filePath);
        String result = rawContent.length == 0 ? "" : new String(rawContent, "UTF-8");
        return result;
    }

    public static InputStream getFileAsStream(String filePath) {
        InputStream result = null;
        URL fileURL = FileHelper.getFileFullUrl(filePath);
        try {
            if (fileURL != null) {
                result = fileURL.openStream();
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.getFileAsStream(..) _ ");
            loggerMessage.append("Failed to load ").append(filePath);
            logger.warn((Object)loggerMessage.toString());
        }
        return result;
    }

    public static byte[] readRawFile(String filePath) {
        byte[] result = null;
        InputStream inputStream = FileHelper.getFileAsStream(filePath);
        if (inputStream != null) {
            result = FileHelper.readFile(inputStream);
        }
        return result == null ? new byte[]{} : result;
    }

    public static void copyFile(String sourceFileRelativePath, String targetFileRelativePath) {
        byte[] content = FileHelper.readRawFile(sourceFileRelativePath);
        FileHelper.writeFile(targetFileRelativePath, true, content);
    }

    public static boolean writeFile(String filePath, boolean ensureFolders, String contents) {
        return FileHelper.writeFile(filePath, ensureFolders, contents.getBytes(Charset.forName("UTF-8")));
    }

    public static boolean writeFile(String filePath, boolean ensureFolders, byte[] contents) {
        boolean result;
        block24: {
            URL fileFullUrl;
            result = false;
            AbstractInterruptibleChannel channel = null;
            URI fileFullUri = FileHelper.getFileFullUri(filePath);
            if (fileFullUri != null && (fileFullUrl = FileHelper.getFileFullUrl(fileFullUri)) != null) {
                String fileFullPath = fileFullUrl.getFile();
                try {
                    try {
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (FileOutputStream fileOutputStream = new FileOutputStream(fileFullPath);){
                            boolean fileWritable;
                            if (ensureFolders) {
                                FileHelper.ensurePathAvailability(fileFullPath);
                            }
                            if (fileWritable = FileHelper.makeFileWritable(filePath)) {
                                channel = fileOutputStream.getChannel();
                                ((FileChannel)channel).write(ByteBuffer.wrap(contents));
                                result = true;
                                channel.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        result = false;
                        StringBuilder loggerMessage = new StringBuilder("FileHelper.writeFile(..) _ ");
                        loggerMessage.append("Failed to open channel in write mode for ");
                        loggerMessage.append(filePath).append(" !");
                        logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                        if (channel == null || !channel.isOpen()) break block24;
                        try {
                            channel.close();
                        }
                        catch (IOException exception2) {
                            result = false;
                            StringBuilder loggerMessage2 = new StringBuilder("FileHelper.writeFile(..) _ ");
                            loggerMessage2.append("Failed to close opened channel in write mode ! ");
                            loggerMessage2.append(filePath).append(" may no longer be usable.");
                            logger.warn((Object)loggerMessage2.toString(), (Throwable)exception2);
                        }
                    }
                }
                finally {
                    if (channel != null && channel.isOpen()) {
                        try {
                            channel.close();
                        }
                        catch (IOException exception) {
                            result = false;
                            StringBuilder loggerMessage = new StringBuilder("FileHelper.writeFile(..) _ ");
                            loggerMessage.append("Failed to close opened channel in write mode ! ");
                            loggerMessage.append(filePath).append(" may no longer be usable.");
                            logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static boolean renameFile(String sourceFileRelativePath, String destinationFileRelativePath) {
        if (sourceFileRelativePath == null || destinationFileRelativePath == null) {
            return false;
        }
        IFile sourceFile = FileHelper.getPlatformFile(sourceFileRelativePath);
        IPath destinationPath = FileHelper.getPlatformFile(destinationFileRelativePath).getFullPath();
        return FileHelper.moveResource((IResource)sourceFile, destinationPath);
    }

    public static boolean renameFolder(String sourceFolderRelativePath, String destinationFolderRelativePath) {
        if (sourceFolderRelativePath == null || destinationFolderRelativePath == null) {
            return false;
        }
        IFolder sourceFolder = FileHelper.getPlatformFolder(sourceFolderRelativePath);
        IPath destinationPath = FileHelper.getPlatformFolder(destinationFolderRelativePath).getFullPath();
        return FileHelper.moveResource((IResource)sourceFolder, destinationPath);
    }

    public static boolean moveResource(IResource resource, IPath destinationPath) {
        boolean result = false;
        try {
            resource.move(destinationPath, true, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        catch (Exception ex) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.moveResource(..) _ ");
            loggerMessage.append("Could not move ").append(resource.getFullPath());
            loggerMessage.append(" to ").append(destinationPath);
            logger.warn((Object)loggerMessage.toString(), (Throwable)ex);
        }
        return result;
    }

    public static boolean exists(String fileRelativePath) {
        IFile file = FileHelper.getPlatformFile(fileRelativePath);
        return file != null ? file.exists() : Boolean.FALSE.booleanValue();
    }

    public static void ensurePathAvailability(String fileFullPath) {
        IPath parentFolderPath = new Path(fileFullPath).removeFileExtension().removeLastSegments(1);
        if (!parentFolderPath.isEmpty()) {
            File parentFolder = parentFolderPath.toFile();
            parentFolder.mkdirs();
        }
    }

    public static boolean deleteFile(String workspaceRelativeFile) {
        boolean result = false;
        IFile fileToDelete = FileHelper.getPlatformFile(workspaceRelativeFile);
        if (fileToDelete != null && fileToDelete.exists()) {
            try {
                fileToDelete.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = true;
            }
            catch (CoreException exception) {
                StringBuilder loggerMessage = new StringBuilder("FileHelper.deleteFile(..) _ ");
                loggerMessage.append("Failed to delete file:").append(workspaceRelativeFile);
                logger.warn((Object)loggerMessage.toString());
            }
        }
        return result;
    }

    public static boolean deleteFolder(String workspaceRelativePath) {
        boolean result = false;
        IFolder folderToDelete = FileHelper.getPlatformFolder(workspaceRelativePath);
        if (folderToDelete != null && folderToDelete.exists()) {
            try {
                folderToDelete.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = true;
            }
            catch (CoreException exception) {
                StringBuilder loggerMessage = new StringBuilder("FileHelper.deleteFolder(..) _ ");
                loggerMessage.append("Failed to delete folder:").append(workspaceRelativePath);
                logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            }
        }
        return result;
    }

    public static IFile getPlatformFile(String fileRelativePath) {
        IFile result = null;
        if (fileRelativePath == null) {
            return result;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        result = root.getFile((IPath)new Path(fileRelativePath));
        return result;
    }

    public static IFolder getPlatformFolder(String folderRelativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFolder((IPath)new Path(folderRelativePath));
    }

    public static String getFileExtension(String filePath) {
        return new Path(filePath).getFileExtension();
    }

    public static boolean makeFileWritable(String filePath) {
        IUserEnforcedHelper helper = SolFaCommonActivator.getDefault().getUserEnforcedHelper();
        IStatus status = helper.makeFileWritable(FileHelper.getPlatformFile(filePath));
        return status.isOK();
    }
}

