/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;

public class NotificationAnalysis {
    public static <S extends EObject, T extends EObject> Multimap<S, T> getAddedElements(Collection<Notification> notifications, NotificationFilter filter) {
        HashMultimap added = HashMultimap.create();
        block4: for (Notification notif : notifications) {
            EObject ce;
            if (!filter.matches(notif) || !(ce = (EObject)notif.getNotifier()).eIsSet((EStructuralFeature)notif.getFeature())) continue;
            switch (notif.getEventType()) {
                case 3: {
                    if (!((Collection)ce.eGet((EStructuralFeature)notif.getFeature())).contains(notif.getNewValue())) break;
                    added.put((Object)ce, (Object)((EObject)notif.getNewValue()));
                    break;
                }
                case 5: {
                    for (Object o : (Collection)notif.getNewValue()) {
                        if (!((Collection)ce.eGet((EStructuralFeature)notif.getFeature())).contains(o)) continue;
                        added.put((Object)ce, (Object)((EObject)o));
                    }
                    continue block4;
                }
            }
        }
        return added;
    }

    public static <S extends EObject, T> Multimap<S, T> getRemovedElements(Collection<Notification> notification, NotificationFilter filter) {
        HashMultimap removed = HashMultimap.create();
        block4: for (Notification notif : notification) {
            if (!filter.matches(notif)) continue;
            EObject ce = (EObject)notif.getNotifier();
            Collection actual = (Collection)ce.eGet((EStructuralFeature)notif.getFeature());
            switch (notif.getEventType()) {
                case 4: {
                    if (actual != null && actual.contains(notif.getOldValue())) continue block4;
                    removed.put((Object)ce, notif.getOldValue());
                    break;
                }
                case 6: {
                    if (actual == null) {
                        removed.putAll((Object)ce, (Iterable)((Collection)notif.getOldValue()));
                        break;
                    }
                    for (Object o : (Collection)notif.getOldValue()) {
                        if (!actual.contains(o)) continue;
                        removed.put((Object)ce, o);
                    }
                    continue block4;
                }
            }
        }
        return removed;
    }

    public static Collection<EObject> getDeletedElements(Collection<Notification> notifications) {
        LinkedHashSet<EObject> deleted = new LinkedHashSet<EObject>();
        for (Notification n : notifications) {
            EObject oldValue;
            if (!(n.getFeature() instanceof EReference) || !((EReference)n.getFeature()).isContainment()) continue;
            if ((n.getEventType() == 1 || n.getEventType() == 4) && (oldValue = (EObject)n.getOldValue()).eContainer() == null && oldValue.eResource() != null) {
                deleted.add(oldValue);
            }
            if (n.getEventType() != 6) continue;
            Collection oldValues = (Collection)n.getOldValue();
            for (EObject oldValue2 : oldValues) {
                if (oldValue2.eContainer() != null || oldValue2.eResource() == null) continue;
                deleted.addAll(oldValues);
            }
        }
        return deleted;
    }

    public static <T> T getOriginalSingleValue(EObject e, EStructuralFeature feature, List<Notification> notifications) {
        for (Notification n : notifications) {
            if (n.getFeature() != feature || n.getNotifier() != e) continue;
            return (T)n.getOldValue();
        }
        return (T)e.eGet(feature);
    }
}

