/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.argumentparser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.argumentparser.ArgumentAnalyzerException;
import org.polarsys.capella.common.helpers.argumentparser.Flag;
import org.polarsys.capella.common.helpers.argumentparser.Messages;

public class ArgumentAnalyzer {
    protected Map<String, Flag> _flags;
    protected Map<String, List<String>> _values;
    protected static final boolean _UNKNOWN_FLAG_AS_ERROR_DEFAULT = false;
    protected final boolean _unknownFlagAsError;
    protected final boolean _strictMode;

    public ArgumentAnalyzer(int numberOfArgument) {
        this.init();
        this._strictMode = true;
        this._unknownFlagAsError = true;
    }

    public ArgumentAnalyzer(boolean strictMode) {
        this.init();
        this._strictMode = strictMode;
        this._unknownFlagAsError = this._strictMode;
    }

    public ArgumentAnalyzer(boolean strictMode, boolean unknowFlagAsError) throws ArgumentAnalyzerException {
        this.init();
        this._strictMode = strictMode;
        if (this._strictMode && !unknowFlagAsError) {
            throw new ArgumentAnalyzerException(Messages.inconsistentOptions);
        }
        this._unknownFlagAsError = unknowFlagAsError;
    }

    public void addFlag(String id, String flagName, boolean isMandatory, int nbData) throws ArgumentAnalyzerException {
        if (this._flags.keySet().contains(id)) {
            throw new ArgumentAnalyzerException(NLS.bind((String)Messages.duplicatedId, (Object)id));
        }
        if (this.getNumberOfFlagDefinedWithName(flagName) != 0 && !this._strictMode) {
            throw new ArgumentAnalyzerException(NLS.bind((String)Messages.duplicatedNameOnlyAllowedWithStrictMode, (Object)flagName));
        }
        this._flags.put(id, new Flag(flagName, isMandatory, nbData));
    }

    public void addFlag(String id, Flag flag) throws ArgumentAnalyzerException {
        this.addFlag(id, flag.getName(), flag.isMandatory(), flag.getNumberOfData());
    }

    public void parse(String[] arguments) throws ArgumentAnalyzerException {
        this._values.clear();
        if (this._strictMode) {
            this.strictModeParsing(arguments);
        } else {
            this.defaultModeParsing(arguments);
        }
    }

    public boolean isArgHasBeenFound(String flagId) throws ArgumentAnalyzerException {
        if (!this._flags.containsKey(flagId)) {
            throw new ArgumentAnalyzerException(NLS.bind((String)Messages.unexpectedFlag, (Object)flagId));
        }
        return this._values.containsKey(flagId);
    }

    public List<String> getFlagArgs(String flagId) throws ArgumentAnalyzerException {
        List<String> results = null;
        if (this.isArgHasBeenFound(flagId)) {
            results = this._values.get(flagId);
        } else if (this.getFlag(flagId).isMandatory()) {
            throw new ArgumentAnalyzerException(NLS.bind((String)Messages.flagNotFound, (Object)flagId));
        }
        return results;
    }

    protected boolean isFlagDefined(String id) {
        return this._flags.containsKey(id);
    }

    protected Flag getFlag(String id) {
        return this._flags.get(id);
    }

    protected int getNumberOfFlagDefinedWithName(String flagName) {
        int result = 0;
        for (Flag flag : this._flags.values()) {
            if (!flag.getName().equals(flagName)) continue;
            ++result;
        }
        return result;
    }

    protected boolean isFlagWithNameDefined(String flagName) {
        boolean b = false;
        for (Flag flag : this._flags.values()) {
            if (!flag.getName().equals(flagName)) continue;
            b = true;
            break;
        }
        return b;
    }

    protected List<String> getFlagIdPerName(String flagName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Flag> entry : this._flags.entrySet()) {
            if (!entry.getValue().getName().equals(flagName)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected void clearResult() {
        this._values.clear();
    }

    protected void init() {
        this._flags = new LinkedHashMap<String, Flag>();
        this._values = new LinkedHashMap<String, List<String>>();
    }

    protected void defaultModeParsing(String[] arguments) throws ArgumentAnalyzerException {
        String currentArg = null;
        String currentId = null;
        Flag flag = null;
        ArrayList<String> args = null;
        int i = 0;
        while (i < arguments.length) {
            currentArg = arguments[i];
            if (this.isFlagWithNameDefined(currentArg)) {
                List<String> list = this.getFlagIdPerName(currentArg);
                if (list.size() != 1) {
                    throw new ArgumentAnalyzerException(Messages.genericError);
                }
                currentId = list.get(0);
                flag = this.getFlag(currentId);
                args = this.getArgumentData(currentId, arguments, i);
                this._values.put(currentId, args);
                i += args.size();
            } else if (this._unknownFlagAsError) {
                throw new ArgumentAnalyzerException(NLS.bind((String)Messages.unknownFlagFoundButNotAllowed, (Object)currentArg));
            }
            ++i;
        }
        Iterator<Map.Entry<String, Flag>> it = this._flags.entrySet().iterator();
        String currentFlagId = null;
        ArrayList<String> missingFlags = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, Flag> entry = it.next();
            currentFlagId = entry.getKey();
            flag = entry.getValue();
            if (!flag.isMandatory() || this._values.containsKey(currentFlagId)) continue;
            missingFlags.add(currentFlagId);
        }
        if (!missingFlags.isEmpty()) {
            throw new ArgumentAnalyzerException(NLS.bind((String)Messages.mandatoryFlagNotFound, (Object[])new Object[]{flag != null ? flag.getName() : "", currentFlagId}));
        }
    }

    protected void strictModeParsing(String[] arguments) throws ArgumentAnalyzerException {
        int idx = 0;
        int foundArg = 0;
        for (Map.Entry<String, Flag> entry : this._flags.entrySet()) {
            if (idx >= arguments.length) {
                throw new ArgumentAnalyzerException(Messages.strictModeParseFailed);
            }
            String currentFlagFromCmdLine = arguments[idx];
            String currentFlagId = entry.getKey();
            Flag currentFlag = entry.getValue();
            boolean currentMatch = true;
            if (!currentFlag.isMandatory() && currentFlag.getName().equals(currentFlagFromCmdLine)) {
                currentMatch = false;
            } else if (currentFlag.isMandatory() && !currentFlag.getName().equals(currentFlagFromCmdLine)) {
                throw new ArgumentAnalyzerException(Messages.strictModeParseFailed);
            }
            if (!currentMatch) continue;
            ++foundArg;
            ArrayList<String> args = this.getArgumentData(currentFlagId, arguments, idx);
            idx += args.size() + 1;
            this._values.put(currentFlagId, args);
        }
        if (foundArg != this._flags.size()) {
            throw new ArgumentAnalyzerException(Messages.strictModeParseFailed);
        }
    }

    protected ArrayList<String> getArgumentData(String currentFlagId, String[] arguments, int currentIndex) throws ArgumentAnalyzerException {
        ArrayList<String> args = new ArrayList<String>();
        int i = currentIndex + 1;
        Flag flag = this.getFlag(currentFlagId);
        if (flag.getNumberOfData() == -1) {
            int j = i;
            while (j < arguments.length - 1) {
                if (this.isFlagDefined(arguments[++i])) {
                    --i;
                    break;
                }
                args.add(arguments[i]);
                ++j;
            }
        } else {
            int j = 0;
            while (j < flag.getNumberOfData()) {
                if (i >= arguments.length || this.isFlagWithNameDefined(arguments[i])) {
                    throw new ArgumentAnalyzerException(NLS.bind((String)Messages.expectedDataDoesNotMatch, (Object[])new Object[]{flag.getName(), currentFlagId, String.valueOf(flag.getNumberOfData())}));
                }
                args.add(arguments[i]);
                ++i;
                ++j;
            }
        }
        return args;
    }
}

