/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sequencediag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentRealization;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class InteractionAspectService {
    public List<Component> getAllActors(EObject any) {
        return ScenarioExt.getAllActors((EObject)any);
    }

    public Collection<Part> getAllComponents(EObject any, Collection<Part> filter) {
        return ScenarioExt.getAllComponents((EObject)any, filter);
    }

    public Collection<Part> getChildren(Part part, Collection<Part> filter) {
        if (CsPackage.eINSTANCE.getComponent().isInstance((Object)part.getAbstractType())) {
            Component component = (Component)part.getAbstractType();
            Collection<Part> allChildren = InteractionAspectService.filter(component.getOwnedFeatures(), Part.class);
            LinkedList<Part> result = new LinkedList<Part>(allChildren);
            LinkedList<Part> filteredChildren = new LinkedList<Part>(filter);
            filteredChildren.retainAll(result);
            result.removeAll(filter);
            for (Part filteredChild : filteredChildren) {
                result.addAll(this.getChildren(filteredChild, filter));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public ModellingArchitecture findArchitecture(EObject ownedElement) {
        ModellingArchitecture result = null;
        EObject current = ownedElement;
        while (result == null && current != null) {
            if (CapellacorePackage.eINSTANCE.getModellingArchitecture().isInstance((Object)current)) {
                result = (ModellingArchitecture)current;
            }
            current = current.eContainer();
        }
        return result;
    }

    private static <T> Collection<T> filter(Collection<?> collection, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (Object o : collection) {
            if (!type.isInstance(o)) continue;
            result.add(type.cast(o));
        }
        result.trimToSize();
        return result;
    }

    public TraceableElement getRefinedCapabilityRealization(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            TraceableElement targetElement;
            if (!(abstractTrace instanceof RefinementLink) || !((targetElement = abstractTrace.getTargetElement()) instanceof CapabilityRealization)) continue;
            return targetElement;
        }
        return null;
    }

    public TraceableElement getRefinedCapabality(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                return targetElement;
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            return this.getRefinedCapabality((CapabilityRealization)targetElement);
        }
        return null;
    }

    public List<CapabilityRealization> getRefinedCapabilityRealizations(CapabilityRealization context) {
        ArrayList<CapabilityRealization> result = new ArrayList<CapabilityRealization>(4);
        result.add(context);
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                return result;
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            result.addAll(this.getRefinedCapabilityRealizations((CapabilityRealization)targetElement));
            return result;
        }
        return null;
    }

    public List<Component> getAllRefinedActors(CapabilityRealization context) {
        Capability capa;
        ArrayList<Component> result = new ArrayList<Component>();
        List<CapabilityRealization> capabilities = this.getRefinedCapabilityRealizations(context);
        if (capabilities != null) {
            for (CapabilityRealization capabilityRealization : capabilities) {
                result.addAll(capabilityRealization.getInvolvedComponents().stream().filter(e -> ComponentExt.isActor((EObject)e)).map(Component.class::cast).collect(Collectors.toList()));
            }
        }
        if ((capa = (Capability)this.getRefinedCapabality(context)) != null) {
            result.addAll(capa.getInvolvedSystemComponents().stream().filter(e -> ComponentExt.isActor((Component)e)).collect(Collectors.toList()));
        }
        return result;
    }

    public List<CapabilityInvolvement> getRefinedInvolvedActors(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                Capability cap = (Capability)targetElement;
                return cap.getOwnedCapabilityInvolvements().stream().filter(inv -> ComponentExt.isActor((EObject)inv.getInvolved())).collect(Collectors.toList());
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            return this.getRefinedInvolvedActors((CapabilityRealization)targetElement);
        }
        return null;
    }

    public List<Component> getOwnedComponents(Component context) {
        ArrayList<Component> list = new ArrayList<Component>();
        ModellingArchitecture architecture = SystemEngineeringExt.findArchitecture((EObject)context);
        if (architecture != null && (architecture instanceof LogicalArchitecture && context instanceof LogicalComponent || architecture instanceof PhysicalArchitecture && context instanceof PhysicalComponent)) {
            for (Component component : ComponentExt.getSubDefinedComponents((Component)context)) {
                if (!(component instanceof Component)) continue;
                list.add(component);
            }
        }
        return list;
    }

    public List<CapabilityRealizationInvolvement> getInvolvedActorsForCapabilityRealizations(CapabilityRealization context) {
        ArrayList<CapabilityRealizationInvolvement> result = new ArrayList<CapabilityRealizationInvolvement>();
        List<CapabilityRealization> capabilities = this.getRefinedCapabilityRealizations(context);
        if (capabilities != null) {
            for (CapabilityRealization capabilityRealization : capabilities) {
                result.addAll((Collection<CapabilityRealizationInvolvement>)capabilityRealization.getOwnedCapabilityRealizationInvolvements());
            }
        }
        return result;
    }

    public List<RefinementLink> getRefinementLinksChain(CapabilityRealization context) {
        ArrayList<RefinementLink> result = new ArrayList<RefinementLink>(4);
        CapabilityRealization current = context;
        while (current instanceof CapabilityRealization) {
            EList outgoingTraces = current.getOutgoingTraces();
            if (outgoingTraces.isEmpty()) {
                return result;
            }
            for (AbstractTrace trace : outgoingTraces) {
                if (!(trace instanceof RefinementLink)) continue;
                RefinementLink refinementLink = (RefinementLink)trace;
                result.add(refinementLink);
                TraceableElement targetElement = refinementLink.getTargetElement();
                if (targetElement == null || !(targetElement instanceof AbstractCapability)) continue;
                current = (AbstractCapability)targetElement;
            }
            if (!current.equals(context)) continue;
            return result;
        }
        return result;
    }

    public List<ComponentRealization> getActorsAllocationLinks(CapabilityRealization context) {
        ArrayList<ComponentRealization> result = new ArrayList<ComponentRealization>();
        List<Component> actors = this.getAllRefinedActors(context);
        for (Component actor : actors) {
            for (ComponentRealization lar : actor.getOwnedComponentRealizations()) {
                if (!actors.contains(lar.getRealizedComponent())) continue;
                result.add(lar);
            }
        }
        return result;
    }
}

