/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;

public class DFServices {
    private static DFServices service = null;

    public static DFServices getService() {
        if (service == null) {
            service = new DFServices();
        }
        return service;
    }

    public boolean isValidCreationDFFunction(DSemanticDecorator containerView) {
        if (containerView == null) {
            return false;
        }
        EObject target = containerView.getTarget();
        if (target == null || target.eIsProxy()) {
            return false;
        }
        if (target instanceof AbstractCapability) {
            return true;
        }
        if (!(target instanceof AbstractFunction)) {
            return false;
        }
        return !FaServices.getFaServices().isControlNode(target);
    }

    public boolean isValidCreationDFControlNode(DSemanticDecorator containerView) {
        return this.isValidCreationDFFunction(containerView);
    }

    public EObject dndDFBAbstractFunction(AbstractFunction node, NamedElement oldContainer, NamedElement newContainer) {
        return this.dndDFAbstractFunction(node, oldContainer, newContainer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EObject dndDFAbstractFunction(AbstractFunction function, NamedElement oldContainer, NamedElement newContainer) {
        if (newContainer instanceof AbstractFunction) {
            AbstractFunction newFunction = (AbstractFunction)newContainer;
            if (newContainer == function) {
                if (newFunction.eContainer() == null || newFunction.eContainer() == null || newFunction.eContainer().eContainer() == null || !(newFunction.eContainer().eContainer() instanceof AbstractFunction)) return function;
                ((AbstractFunction)newFunction.eContainer().eContainer()).getOwnedFunctions().add((Object)function);
            } else {
                newFunction.getOwnedFunctions().add((Object)function);
            }
        }
        for (FunctionalExchange exchange : FunctionExt.getIncomingExchange((AbstractFunction)function)) {
            FunctionalExchangeExt.attachToDefaultContainer((FunctionalExchange)exchange);
        }
        for (FunctionalExchange exchange : FunctionExt.getOutGoingExchange((AbstractFunction)function)) {
            FunctionalExchangeExt.attachToDefaultContainer((FunctionalExchange)exchange);
        }
        return function;
    }

    public boolean isValidDFFunctionalExchangeEdge(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (context instanceof FunctionalExchange) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
            if (CapellaServices.getService().areInternalEdgePorts(sourceView, targetView)) {
                return false;
            }
            return !diagram.isSynchronized() || !FaServices.getFaServices().isACategoryDisplayed(context, sourceView, targetView);
        }
        return false;
    }

    public boolean isValidDFFunctionalExchangeEdgeFromInternalTool(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (context instanceof FunctionalExchange) {
            return !FaServices.getFaServices().isACategoryDisplayed(context, sourceView, targetView);
        }
        return false;
    }

    public boolean isValidDndDFBAbstractFunction(AbstractFunction semanticObjectToDrop, EObject targetContainerView) {
        EObject target = ((DSemanticDecorator)targetContainerView).getTarget();
        if (target instanceof AbstractFunction && !FunctionExt.isActorFunction((AbstractFunction)((AbstractFunction)target))) {
            if (EcoreUtil2.isContainedBy((EObject)target, (EObject)semanticObjectToDrop)) {
                return false;
            }
            if (target.equals(semanticObjectToDrop)) {
                return false;
            }
            return !FaServices.getFaServices().isControlNode(target);
        }
        return false;
    }

    public boolean isValidDFFunctionalChainInternalLinkEdge(FunctionalChain chain, DSemanticDecorator source, DSemanticDecorator target) {
        return FunctionalChainServices.getFunctionalChainServices().isValidInternalLinkEdge(chain, (EdgeTarget)source, (EdgeTarget)target);
    }

    public EObject createDFFunctionalExchange(EObject context, AbstractDNode sourceView, AbstractDNode targetView) {
        return ABServices.getService().createABFunctionalExchange(context, sourceView, targetView);
    }

    public Collection<EObject> getDFInsertStateModesScope(DSemanticDecorator containerView) {
        HashSet availableStates = new HashSet();
        HashSet<EObject> result = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (AbstractFunction function : FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)architecture))) {
                availableStates.addAll(function.getAvailableInStates());
            }
            for (State state : availableStates) {
                boolean addElement = false;
                for (EObject function : this.getDFInsertStateModesRelatedElements(state, architecture)) {
                    if (!(function instanceof AbstractFunction) || content.containsView(function, (DiagramElementMapping)FaServices.getFaServices().getMappingDFFunction((AbstractFunction)function, diagram))) continue;
                    addElement = true;
                    break;
                }
                if (!addElement) continue;
                result.add((EObject)state);
            }
        }
        return result;
    }

    public void showDFStateModes(DSemanticDecorator containerView, Collection<EObject> elements) {
        HashSet<EObject> functionsToShow = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (EObject object : elements) {
                if (!(object instanceof State)) continue;
                State mode = (State)object;
                functionsToShow.addAll(this.getDFInsertStateModesRelatedElements(mode, sourceArchitecture));
            }
            for (EObject toShow : functionsToShow) {
                if (!(toShow instanceof AbstractFunction)) continue;
                FaServices.getFaServices().showDFAbstractFunction((AbstractFunction)toShow, content.getBestContainer(toShow), content);
            }
        }
    }

    public Collection<EObject> getDFInsertStateModesRelatedElements(State mode, BlockArchitecture sourceArchitecture) {
        return ABServices.getService().getABInsertStateModesRelatedElements(mode, sourceArchitecture);
    }

    public boolean isValidDndDFFunctionPort(EObject element, DSemanticDecorator newContainer) {
        if (newContainer == null || newContainer.getTarget() == null || newContainer.getTarget().eIsProxy()) {
            return false;
        }
        EObject targetContainer = newContainer.getTarget();
        if (targetContainer.equals(element.eContainer())) {
            return false;
        }
        if (!(targetContainer instanceof ActivityNode)) {
            return false;
        }
        AbstractFunction targetFunction = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)targetContainer));
        if (FunctionExt.isControlNodeOneOutput((AbstractFunction)targetFunction) && element instanceof FunctionOutputPort) {
            if (!targetFunction.getOutputs().isEmpty()) {
                return false;
            }
            return ((FunctionOutputPort)element).getOutgoingFunctionalExchanges().size() <= 1;
        }
        if (FunctionExt.isControlNodeOneInput((AbstractFunction)targetFunction) && element instanceof FunctionInputPort) {
            if (!targetFunction.getInputs().isEmpty()) {
                return false;
            }
            return ((FunctionInputPort)element).getIncomingFunctionalExchanges().size() <= 1;
        }
        if (element instanceof FunctionPort && FunctionExt.isFlowPortInAnyFunctionalExchange((FunctionPort)((FunctionPort)element), (AbstractFunction)targetFunction)) {
            return false;
        }
        return newContainer != null;
    }

    public boolean isValidDFInsertStateModes(DSemanticDecorator containerView) {
        return containerView instanceof DDiagram;
    }

    public Collection<EObject> getDFInsertScenariosScope(DSemanticDecorator containerView) {
        HashSet<EObject> result = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            AbstractCapabilityPkg pkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)sourceArchitecture);
            for (Scenario scenario : AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)pkg)) {
                boolean addElement = false;
                for (EObject element : ContextualDiagramHelper.getService().getInsertScenariosRelatedElements(scenario, sourceArchitecture)) {
                    if (element instanceof AbstractFunction) {
                        if (content.containsView(element, (DiagramElementMapping)FaServices.getFaServices().getMappingDFFunction((AbstractFunction)element, diagram))) continue;
                        addElement = true;
                        break;
                    }
                    if (!(element instanceof FunctionalExchange) || content.containsView(element, (DiagramElementMapping)FaServices.getFaServices().getMappingDFFunctionalExchange(diagram))) continue;
                    addElement = true;
                    break;
                }
                if (!addElement) continue;
                if (ScenarioExt.isFunctionalScenario((Scenario)scenario)) {
                    result.add((EObject)scenario);
                    continue;
                }
                if (!ScenarioExt.isDataFlowFunctionalScenario((Scenario)scenario)) continue;
                result.add((EObject)scenario);
            }
        }
        return result;
    }

    public void showDFScenarios(DSemanticDecorator containerView, Collection<EObject> elements) {
        HashSet<AbstractFunction> functionsToShow = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> exchangesToShow = new HashSet<FunctionalExchange>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (EObject object : elements) {
                if (!(object instanceof Scenario)) continue;
                Scenario scenario = (Scenario)object;
                for (EObject related : ContextualDiagramHelper.getService().getInsertScenariosRelatedElements(scenario, sourceArchitecture)) {
                    if (related instanceof AbstractFunction) {
                        functionsToShow.add((AbstractFunction)related);
                        continue;
                    }
                    if (!(related instanceof FunctionalExchange)) continue;
                    exchangesToShow.add((FunctionalExchange)related);
                }
            }
            for (AbstractFunction toShow : functionsToShow) {
                FaServices.getFaServices().showDFAbstractFunction(toShow, content.getBestContainer((EObject)toShow), content);
            }
            for (FunctionalExchange functionalExchange : exchangesToShow) {
                FaServices.getFaServices().showDFFunctionalExchange(null, functionalExchange, content, true);
            }
        }
    }

    public boolean isValidDFInsertScenarios(DSemanticDecorator containerView) {
        return containerView instanceof DDiagram;
    }

    public EObject getDFTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            EObject diagramTarget = decorator.getTarget();
            ContainerMapping aMapping = FaServices.getFaServices().getMappingDFFunction(null, (DDiagram)decorator);
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (!DiagramServices.getDiagramServices().isMapping(element, (DiagramElementMapping)aMapping) || element.getTarget() != diagramTarget) continue;
                return FaServices.getFaServices().getParentFunctionContainer(decorator.getTarget());
            }
            if (diagramTarget instanceof AbstractCapability) {
                return FaServices.getFaServices().getParentFunctionContainer(decorator.getTarget());
            }
            return decorator.getTarget();
        }
        return decorator.getTarget();
    }

    public Object getDFFunctionalExchangeSemanticCandidates(DDiagram diagram) {
        LinkedList<AbstractFunction> toVisit = new LinkedList<AbstractFunction>();
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            toVisit.add((AbstractFunction)target);
        }
        ArrayList<AbstractFunction> visited = new ArrayList<AbstractFunction>();
        while (!toVisit.isEmpty()) {
            AbstractFunction function = (AbstractFunction)toVisit.removeFirst();
            if (visited.contains(function)) continue;
            toVisit.addAll((Collection<AbstractFunction>)function.getOwnedFunctions());
            result.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
            visited.add(function);
        }
        return result;
    }
}

