/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.AbstractNodeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.query.AbstractNodeMappingApplicabilityTester;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentHelper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.model.business.internal.operations.DDiagramSpecOperations;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.naming.DiagramNamingConstants;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;

public class DiagramServices {
    private static DiagramServices singleton = null;
    public static final int OVERLLAPING_LABEL_MAX_LENGTH = 30;

    public static DiagramServices getDiagramServices() {
        if (singleton == null) {
            singleton = new DiagramServices();
        }
        return singleton;
    }

    public EList<DDiagramElement> getOwnedDiagramElements(DragAndDropTarget container) {
        if (container instanceof DDiagram) {
            return ((DDiagram)container).getOwnedDiagramElements();
        }
        if (container instanceof DNodeContainer) {
            return ((DNodeContainer)container).getOwnedDiagramElements();
        }
        return null;
    }

    public EList<DDiagramElement> getOwnedDiagramElements(EObject container) {
        if (container instanceof DDiagram) {
            return ((DDiagram)container).getOwnedDiagramElements();
        }
        if (container instanceof DNodeContainer) {
            return ((DNodeContainer)container).getOwnedDiagramElements();
        }
        return null;
    }

    public List<DDiagramElement> getFlatOwnedDiagramElements(EObject container) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        this.getFlatOwnedDiagramElements(container, result);
        return result;
    }

    private void getFlatOwnedDiagramElements(EObject container, List<DDiagramElement> acumulator) {
        EList<DDiagramElement> ownedDiagramElements = this.getOwnedDiagramElements(container);
        acumulator.addAll((Collection<DDiagramElement>)ownedDiagramElements);
        for (DDiagramElement dDiagramElement : ownedDiagramElements) {
            if (!(dDiagramElement instanceof DNodeContainer)) continue;
            this.getFlatOwnedDiagramElements((EObject)dDiagramElement, acumulator);
        }
    }

    public Collection<DDiagramElement> getOwnedNodes(DSemanticDecorator element) {
        ArrayList<DDiagramElement> views = new ArrayList<DDiagramElement>();
        if (element instanceof DDiagram) {
            for (DDiagramElement view : ((DDiagram)element).getOwnedDiagramElements()) {
                if (!(view instanceof DNode)) continue;
                views.add(view);
            }
        } else if (element instanceof DNodeContainer) {
            for (DDiagramElement view : ((DNodeContainer)element).getOwnedDiagramElements()) {
                if (!(view instanceof DNode)) continue;
                views.add(view);
            }
        } else if (element instanceof AbstractDNode) {
            views.addAll((Collection<DDiagramElement>)((AbstractDNode)element).getOwnedBorderedNodes());
        }
        return views;
    }

    public Collection<DDiagramElement> getOwnedNodeListElements(DSemanticDecorator element) {
        ArrayList<DDiagramElement> views = new ArrayList<DDiagramElement>();
        if (element instanceof DDiagram) {
            for (DDiagramElement view : ((DDiagram)element).getOwnedDiagramElements()) {
                if (!(view instanceof DNodeListElement)) continue;
                views.add(view);
            }
        } else if (element instanceof DNodeList) {
            views.addAll((Collection<DDiagramElement>)((DNodeList)element).getOwnedElements());
        }
        return views;
    }

    public Collection<DDiagramElement> getOwnedContainers(DSemanticDecorator element) {
        ArrayList<DDiagramElement> views;
        block3: {
            block2: {
                views = new ArrayList<DDiagramElement>();
                if (!(element instanceof DDiagram)) break block2;
                for (DDiagramElement view : ((DDiagram)element).getOwnedDiagramElements()) {
                    if (!(view instanceof DDiagramElementContainer)) continue;
                    views.add(view);
                }
                break block3;
            }
            if (!(element instanceof DNodeContainer)) break block3;
            for (DDiagramElement view : ((DNodeContainer)element).getOwnedDiagramElements()) {
                if (!(view instanceof DDiagramElementContainer)) continue;
                views.add(view);
            }
        }
        return views;
    }

    public Collection<DDiagramElement> getAllAbstractNodes(EObject element) {
        return Lists.newArrayList(this.getAllAbstractNodes(element, true));
    }

    public Iterable<DDiagramElement> getAllAbstractNodes(EObject element, boolean borderedNode) {
        return this.getDiagramElements(element, false, true, true, borderedNode);
    }

    public Iterable<AbstractDNode> getAllNodeContainers(EObject element) {
        return this.getDiagramElements(element, false, false, true, false);
    }

    public Iterable<DDiagramElement> getAllBorderedNodes(DSemanticDecorator element) {
        return this.getDiagramElements((EObject)element, false, false, false, true);
    }

    public Collection<DDiagramElement> getOwnedAbstractNodes(DSemanticDecorator element) {
        ArrayList<DDiagramElement> views = new ArrayList<DDiagramElement>();
        if (element instanceof DDiagram) {
            for (DDiagramElement view : ((DDiagram)element).getOwnedDiagramElements()) {
                if (!(view instanceof AbstractDNode)) continue;
                views.add(view);
            }
        } else if (element instanceof DNodeContainer) {
            for (DDiagramElement view : ((DNodeContainer)element).getOwnedDiagramElements()) {
                if (!(view instanceof AbstractDNode)) continue;
                views.add(view);
            }
        }
        if (element instanceof AbstractDNode) {
            views.addAll((Collection<DDiagramElement>)((AbstractDNode)element).getOwnedBorderedNodes());
        }
        return views;
    }

    @Deprecated
    public DiagramElementMapping getMapping(String eClass, DDiagram diagram) {
        return this.getMappingByName((RepresentationDescription)diagram.getDescription(), eClass);
    }

    public List<NodeMapping> getAllBorderedNodeMapping(AbstractNodeMapping mapping) {
        ArrayList<NodeMapping> returnedList = new ArrayList<NodeMapping>();
        returnedList.addAll((Collection<NodeMapping>)mapping.getBorderedNodeMappings());
        if (mapping instanceof ContainerMapping) {
            ContainerMapping currentContainerMapping = (ContainerMapping)mapping;
            for (ContainerMapping aMapping : currentContainerMapping.getSubContainerMappings()) {
                returnedList.addAll(this.getAllBorderedNodeMapping((AbstractNodeMapping)aMapping));
            }
            for (ContainerMapping aMapping : currentContainerMapping.getSubNodeMappings()) {
                returnedList.addAll(this.getAllBorderedNodeMapping((AbstractNodeMapping)aMapping));
            }
        }
        return returnedList;
    }

    public List<NodeMapping> getAllNodeMappings(ContainerMapping mapping) {
        ArrayList<NodeMapping> returnedList = new ArrayList<NodeMapping>();
        returnedList.addAll((Collection<NodeMapping>)mapping.getSubNodeMappings());
        for (ContainerMapping aMapping : mapping.getSubContainerMappings()) {
            returnedList.addAll(this.getAllNodeMappings(aMapping));
        }
        return returnedList;
    }

    public List<ContainerMapping> getAllContainerMappings(ContainerMapping mapping) {
        ArrayList<ContainerMapping> returnedList = new ArrayList<ContainerMapping>();
        returnedList.add(mapping);
        for (ContainerMapping aMapping : mapping.getSubContainerMappings()) {
            returnedList.addAll(this.getAllContainerMappings(aMapping));
        }
        return returnedList;
    }

    public AbstractNodeMapping getAbstractNodeMapping(DiagramDescription description, String mappingName) {
        for (NodeMapping nodeMapping : ContentHelper.getAllNodeMappings((DiagramDescription)description, (boolean)false)) {
            if (nodeMapping.getName().equals(mappingName)) {
                return nodeMapping;
            }
            for (NodeMapping borderedMapping : MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)nodeMapping)) {
                if (!borderedMapping.getName().equals(mappingName)) continue;
                return borderedMapping;
            }
        }
        for (NodeMapping nodeMapping : ContentHelper.getAllContainerMappings((DiagramDescription)description, (boolean)false)) {
            if (nodeMapping.getName().equals(mappingName)) {
                return nodeMapping;
            }
            for (DiagramElementMapping mapping : MappingHelper.getAllMappings((DiagramElementMapping)nodeMapping)) {
                if (!(mapping instanceof AbstractNodeMapping)) continue;
                if (mapping.getName().equals(mappingName)) {
                    return (AbstractNodeMapping)mapping;
                }
                for (NodeMapping borderedMapping : MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)((AbstractNodeMapping)mapping))) {
                    if (!borderedMapping.getName().equals(mappingName)) continue;
                    return borderedMapping;
                }
            }
        }
        return null;
    }

    public AbstractNodeMapping getAbstractNodeMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        return this.getAbstractNodeMapping(description, mappingName);
    }

    public NodeMapping getNodeMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        for (NodeMapping nodeMapping : ContentHelper.getAllNodeMappings((DiagramDescription)description, (boolean)false)) {
            if (!nodeMapping.getName().equals(mappingName)) continue;
            return nodeMapping;
        }
        for (ContainerMapping aMapping : ContentHelper.getAllContainerMappings((DiagramDescription)description, (boolean)false)) {
            for (NodeMapping aNodeMapping : this.getAllNodeMappings(aMapping)) {
                if (!aNodeMapping.getName().equals(mappingName)) continue;
                return aNodeMapping;
            }
        }
        return null;
    }

    public List<NodeMapping> getBorderedNodeMapping(DDiagram diagram, List<String> mappingNames) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        for (String name : mappingNames) {
            result.add(this.getBorderedNodeMapping(diagram, name));
        }
        return result;
    }

    public NodeMapping getBorderedNodeMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        for (NodeMapping nodeMapping : ContentHelper.getAllNodeMappings((DiagramDescription)description, (boolean)false)) {
            for (NodeMapping aBorderedNodeMapping : this.getAllBorderedNodeMapping((AbstractNodeMapping)nodeMapping)) {
                if (!aBorderedNodeMapping.getName().equals(mappingName)) continue;
                return aBorderedNodeMapping;
            }
        }
        for (ContainerMapping aMapping : ContentHelper.getAllContainerMappings((DiagramDescription)description, (boolean)false)) {
            for (NodeMapping aBorderedNodeMapping : this.getAllBorderedNodeMapping((AbstractNodeMapping)aMapping)) {
                if (!aBorderedNodeMapping.getName().equals(mappingName)) continue;
                return aBorderedNodeMapping;
            }
        }
        return null;
    }

    public ContainerMapping getContainerMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        for (ContainerMapping aContainerMapping : ContentHelper.getAllContainerMappings((DiagramDescription)description, (boolean)false)) {
            for (ContainerMapping aSubContainerMapping : this.getAllContainerMappings(aContainerMapping)) {
                if (!aSubContainerMapping.getName().equals(mappingName)) continue;
                return aSubContainerMapping;
            }
        }
        return null;
    }

    public EdgeMapping getEdgeMapping(DiagramDescription description, String mappingName) {
        for (EdgeMapping edgeMapping : ContentHelper.getAllEdgeMappings((DiagramDescription)description, (boolean)false)) {
            if (!edgeMapping.getName().equals(mappingName)) continue;
            return edgeMapping;
        }
        return null;
    }

    public EdgeMapping getEdgeMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        return this.getEdgeMapping(description, mappingName);
    }

    public DNode createNode(NodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        return (DNode)this.createAbstractDNode((AbstractNodeMapping)mapping, modelElement, container, diagram);
    }

    public DNode createBorderedNode(NodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        DDiagram diag = diagram;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(modelElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diag.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DNodeCandidate nodeCandidate = new DNodeCandidate((AbstractNodeMapping)mapping, modelElement, container, rId);
        return (DNode)elementSync.createNewNode(this.getMappingManager((DSemanticDiagram)diag), nodeCandidate, true);
    }

    public AbstractDNode createDNodeListElement(AbstractNodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        return this.createDNodeListElement(mapping, modelElement, container, diagram, -1);
    }

    public AbstractDNode createDNodeListElement(AbstractNodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram, int index) {
        DDiagram diag = diagram;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(modelElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diag.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DNodeCandidate nodeCandidate = new DNodeCandidate(mapping, modelElement, container, rId);
        return elementSync.createNewNode(this.getMappingManager((DSemanticDiagram)diag), nodeCandidate, false, index);
    }

    public DNodeContainer createContainer(ContainerMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram, int index) {
        DDiagram diag = diagram;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(modelElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diag.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DNodeCandidate nodeCandidate = new DNodeCandidate((AbstractNodeMapping)mapping, modelElement, container, rId);
        return (DNodeContainer)elementSync.createNewNode(this.getMappingManager((DSemanticDiagram)diag), nodeCandidate, false, index);
    }

    public DNodeContainer createContainer(ContainerMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        return this.createContainer(mapping, modelElement, container, diagram, -1);
    }

    @Deprecated
    public AbstractDNode createAbstractDNodeContainer(AbstractNodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        return this.createAbstractDNode(mapping, modelElement, container, diagram);
    }

    public boolean isBorderedNodeMapping(DiagramElementMapping mapping) {
        return mapping != null && DescriptionPackage.Literals.ABSTRACT_NODE_MAPPING__BORDERED_NODE_MAPPINGS.equals(mapping.eContainingFeature());
    }

    public boolean evaluateEdgePrecondition(EdgeMapping edgeMapping, DDiagram diagram, EObject semantic, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        return new EdgeMappingQuery(edgeMapping).evaluatePrecondition((DSemanticDiagram)diagram, (DragAndDropTarget)diagram, interpreter, semantic, sourceView, targetView);
    }

    public boolean evaluateNodePrecondition(AbstractNodeMapping nodeMapping, DDiagram diagram, DSemanticDecorator containerView, EObject semantic) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        return new AbstractNodeMappingQuery(nodeMapping).evaluatePrecondition((DSemanticDiagram)diagram, (DragAndDropTarget)containerView, interpreter, semantic);
    }

    public Collection<EObject> evaluateCandidateExpression(AbstractNodeMapping nodeMapping, DDiagram diagram, DSemanticDecorator containerView, EObject semantic) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        return new AbstractNodeMappingQuery(nodeMapping).evaluateCandidateExpression((DSemanticDiagram)diagram, interpreter, (DragAndDropTarget)containerView);
    }

    public AbstractDNode createAbstractDNode(AbstractNodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        DDiagram diag = diagram;
        if (mapping == null) {
            return null;
        }
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(modelElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diag.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DNodeCandidate nodeCandidate = new DNodeCandidate(mapping, modelElement, container, rId);
        return elementSync.createNewNode(this.getMappingManager((DSemanticDiagram)diag), nodeCandidate, this.isBorderedNodeMapping((DiagramElementMapping)mapping));
    }

    public DEdge createEdge(EdgeMapping mapping, EdgeTarget sourceView, EdgeTarget targetView, EObject semanticObject) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticObject);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticObject);
        if (mapping == null) {
            return null;
        }
        if (sourceView == null || targetView == null) {
            return null;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DEdgeCandidate edgeCandidate = new DEdgeCandidate(mapping, semanticObject, sourceView, targetView, rId);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diagram.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        HashMap edgeToMappingBasedDecoration = new HashMap();
        HashMap edgeToSemanticBasedDecoration = new HashMap();
        HashMap mappingsToEdgeTargets = new HashMap();
        DDiagramElement sourceElement = null;
        DDiagramElement targetElement = null;
        DiagramElementMapping sourceMapping = null;
        DiagramElementMapping targetMapping = null;
        if (sourceView instanceof DDiagramElement) {
            sourceElement = (DDiagramElement)sourceView;
            sourceMapping = sourceElement.getDiagramElementMapping();
        }
        if (targetView instanceof DDiagramElement) {
            targetElement = (DDiagramElement)targetView;
            targetMapping = targetElement.getDiagramElementMapping();
        }
        if (sourceMapping != null) {
            mappingsToEdgeTargets.put(sourceMapping, new ArrayList());
        }
        if (targetMapping != null && !targetMapping.equals(sourceMapping)) {
            mappingsToEdgeTargets.put(targetMapping, new ArrayList());
        }
        if (sourceMapping != null) {
            ((Collection)mappingsToEdgeTargets.get(sourceMapping)).add(sourceView);
        }
        if (targetMapping != null && !sourceView.equals(targetView)) {
            ((Collection)mappingsToEdgeTargets.get(targetMapping)).add(targetView);
        }
        new DecorationHelperInternal(diagram, interpreter, accessor).computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
        return elementSync.createNewEdge(this.getMappingManager((DSemanticDiagram)diagram), edgeCandidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
    }

    public boolean isHiddenLabel(DDiagramElement context) {
        return new DDiagramElementQuery(context).isLabelHidden();
    }

    public EObject hideLabel(DDiagramElement context) {
        HideFilterHelper.INSTANCE.hideLabel(context);
        return context;
    }

    public boolean isHidden(DDiagramElement context) {
        DDiagramElementQuery query = new DDiagramElementQuery(context);
        return query.isHidden();
    }

    public boolean isFiltered(DDiagramElement context) {
        DDiagramElementQuery query = new DDiagramElementQuery(context);
        return query.isFiltered() || query.isIndirectlyFiltered();
    }

    public EObject hide(DDiagramElement context) {
        HideFilterHelper.INSTANCE.hide(context);
        return context;
    }

    public boolean isVisible(DDiagramElement edge) {
        return !this.isHidden(edge);
    }

    public boolean isOnDiagram(DNodeContainer diagramElement, EObject semanticTarget) {
        for (DDiagramElement element : diagramElement.getContainers()) {
            if (element.getTarget() != semanticTarget) continue;
            return true;
        }
        return false;
    }

    public boolean isIndirectlyOnDiagram(DNodeContainer diagramElement, EObject semanticTarget) {
        for (DDiagramElement element : diagramElement.getContainers()) {
            AbstractType partType;
            EObject elementTarget = element.getTarget();
            if (elementTarget != null && elementTarget.equals(semanticTarget)) {
                return true;
            }
            if (!(elementTarget instanceof Part) || (partType = ((Part)elementTarget).getAbstractType()) == null || !partType.equals(semanticTarget)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnDiagram(DDiagram diagramTarget, EObject semanticTarget) {
        return this.getDiagramElement(diagramTarget, semanticTarget) != null;
    }

    protected Predicate<EStructuralFeature.Setting> isValidTargetFeature() {
        return setting -> ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET.equals(setting.getEStructuralFeature()) || ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS.equals(setting.getEStructuralFeature());
    }

    public boolean isValidMapping(AbstractNodeMapping mapping_p, DSemanticDecorator container) {
        AbstractNodeMappingApplicabilityTester tester = new AbstractNodeMappingApplicabilityTester(Arrays.asList(mapping_p));
        if (container instanceof DDiagram) {
            return tester.canCreateIn((DDiagram)container);
        }
        if (container instanceof DDiagramElementContainer) {
            return tester.canCreateIn((DDiagramElementContainer)container);
        }
        if (container instanceof DNode) {
            return tester.canCreateIn((DNode)container);
        }
        return true;
    }

    protected Stream<DDiagramElement> getDiagramElementsStream(DRepresentation diagramTarget, EObject semanticTarget) {
        Session session = SessionManager.INSTANCE.getSession(semanticTarget);
        return session.getSemanticCrossReferencer().getInverseReferences(semanticTarget).stream().filter(this.isValidTargetFeature()).filter(setting -> setting.getEObject() instanceof DDiagramElement).map(setting -> (DDiagramElement)setting.getEObject()).filter(decorator -> diagramTarget.equals(DiagramHelper.getService().getRepresentation((DSemanticDecorator)decorator)));
    }

    public DDiagramElement getDiagramElement(DDiagram diagramTarget, EObject semanticTarget) {
        return this.getDiagramElementsStream((DRepresentation)diagramTarget, semanticTarget).findFirst().orElse(null);
    }

    public Collection<DSemanticDecorator> getDiagramElements(DRepresentation diagramTarget, EObject semanticTarget) {
        return this.getDiagramElementsStream(diagramTarget, semanticTarget).collect(Collectors.toSet());
    }

    public Iterable<DDiagramElement> getDiagramElements(DDiagram diagram, DiagramElementMapping mapping) {
        boolean isEdgeMapping = mapping instanceof EdgeMapping || mapping instanceof EdgeMappingImport;
        final DiagramIterator iterator = new DiagramIterator((EObject)diagram, mapping, isEdgeMapping, !isEdgeMapping, !isEdgeMapping, !isEdgeMapping);
        return new Iterable<DDiagramElement>(){

            @Override
            public Iterator<DDiagramElement> iterator() {
                return iterator;
            }
        };
    }

    public Iterable<DDiagramElement> getDiagramElements(DDiagramElement container, DiagramElementMapping mapping) {
        boolean isEdgeMapping = mapping instanceof EdgeMapping || mapping instanceof EdgeMappingImport;
        final DiagramIterator iterator = new DiagramIterator((EObject)container, mapping, isEdgeMapping, !isEdgeMapping, !isEdgeMapping, !isEdgeMapping);
        return new Iterable<DDiagramElement>(){

            @Override
            public Iterator<DDiagramElement> iterator() {
                return iterator;
            }
        };
    }

    public DDiagramElement getDiagramElement(DDiagram diagramTarget, DiagramElementMapping mappingTarget, EObject semanticTarget) {
        return this.getDiagramElementsStream((DRepresentation)diagramTarget, semanticTarget).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).filter(element -> element.getMapping().equals(mappingTarget)).findFirst().orElse(null);
    }

    public Collection<DDiagramElement> getDiagramElements(DDiagram diagramTarget, DiagramElementMapping mappingTarget, EObject semanticTarget) {
        return this.getDiagramElementsStream((DRepresentation)diagramTarget, semanticTarget).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).filter(element -> element.getMapping().equals(mappingTarget)).collect(Collectors.toSet());
    }

    @Deprecated
    public Iterable<DDiagramElement> getDiagramElements(EObject context) {
        final DiagramIterator iterator = new DiagramIterator(context);
        return new Iterable<DDiagramElement>(){

            @Override
            public Iterator<DDiagramElement> iterator() {
                return iterator;
            }
        };
    }

    @Deprecated
    public Iterable<DDiagramElement> getDiagramElements(EObject context, boolean edges, boolean nodes, boolean containers, boolean borderedNodes) {
        final DiagramIterator iterator = new DiagramIterator(context, edges, nodes, containers, borderedNodes);
        return new Iterable<DDiagramElement>(){

            @Override
            public Iterator<DDiagramElement> iterator() {
                return iterator;
            }
        };
    }

    public boolean isEdgeOnDiagram(EdgeTarget sourceView, EdgeTarget targetView, EObject semantic) {
        return this.getEdgeOnDiagram(sourceView, targetView, semantic) != null;
    }

    public DEdge getEdgeOnDiagram(EdgeTarget sourceView, EdgeTarget targetView, EObject semantic) {
        if (sourceView != null && targetView != null) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
            for (DEdge edge : sourceView.getOutgoingEdges()) {
                if (diagram == null || !diagram.getEdges().contains((Object)edge) || edge.getTarget() == null || !targetView.equals(edge.getTargetNode()) || !edge.getTarget().equals(semantic)) continue;
                return edge;
            }
        }
        return null;
    }

    public void removeNodeView(DNode node) {
        EObject container = node.eContainer();
        if (container != null) {
            if (container instanceof DDiagram) {
                ((DDiagram)container).getOwnedDiagramElements().remove((Object)node);
            }
            if (container instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)container;
                if (nodeContainer.getOwnedDiagramElements().contains((Object)node)) {
                    nodeContainer.getOwnedDiagramElements().remove((Object)node);
                }
                if (nodeContainer.getOwnedBorderedNodes().contains((Object)node)) {
                    nodeContainer.getOwnedBorderedNodes().remove((Object)node);
                }
            }
            if (container instanceof DNode) {
                ((DNode)container).getOwnedBorderedNodes().remove((Object)node);
            }
        }
    }

    public void removeNodeListElementView(AbstractDNode node) {
        EObject container = node.eContainer();
        if (container != null && container instanceof DNodeList) {
            ((DNodeList)container).getOwnedElements().remove((Object)node);
        }
    }

    public void removeAbstractDNodeView(AbstractDNode node) {
        EObject container = node.eContainer();
        if (container != null) {
            if (container instanceof DDiagram) {
                ((DDiagram)container).getOwnedDiagramElements().remove((Object)node);
            } else if (container instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)container;
                if (nodeContainer.getOwnedDiagramElements().contains((Object)node)) {
                    nodeContainer.getOwnedDiagramElements().remove((Object)node);
                }
                if (nodeContainer.getOwnedBorderedNodes().contains((Object)node)) {
                    nodeContainer.getOwnedBorderedNodes().remove((Object)node);
                }
            } else if (container instanceof DNode) {
                ((DNode)container).getOwnedBorderedNodes().remove((Object)node);
            } else if (container instanceof DNodeList) {
                ((DNodeList)container).getOwnedElements().remove((Object)node);
            }
        }
    }

    public void removeContainerView(EObject container) {
        EObject owner = container.eContainer();
        if (owner != null) {
            DNodeContainer nodeContainer;
            if (owner instanceof DDiagram) {
                ((DDiagram)owner).getOwnedDiagramElements().remove((Object)container);
            }
            if (owner instanceof DNodeContainer && (nodeContainer = (DNodeContainer)owner).getOwnedDiagramElements().contains((Object)container)) {
                nodeContainer.getOwnedDiagramElements().remove((Object)container);
            }
        }
    }

    public void removeEdgeView(DEdge anEdge) {
        EObject container = anEdge.eContainer();
        if (container != null && container instanceof DDiagram) {
            if (anEdge.getSourceNode() != null) {
                anEdge.getSourceNode().getIncomingEdges().remove((Object)anEdge);
                anEdge.getSourceNode().getOutgoingEdges().remove((Object)anEdge);
            }
            if (anEdge.getTargetNode() != null) {
                anEdge.getTargetNode().getOutgoingEdges().remove((Object)anEdge);
                anEdge.getTargetNode().getIncomingEdges().remove((Object)anEdge);
            }
            ((DDiagram)container).getOwnedDiagramElements().remove((Object)anEdge);
        }
    }

    public boolean isMapping(DDiagramElement element, DiagramElementMapping mapping) {
        return mapping != null && new DiagramElementMappingQuery(mapping).isInstanceOf((DMappingBased)element);
    }

    public boolean isABorderedNode(AbstractDNode node) {
        if (node == null) {
            return false;
        }
        EObject container = node.eContainer();
        if (container == null) {
            return false;
        }
        if (container instanceof DDiagram) {
            return false;
        }
        if (container instanceof AbstractDNode) {
            AbstractDNode nodeContainer = (AbstractDNode)container;
            return nodeContainer.getOwnedBorderedNodes().contains((Object)node);
        }
        return false;
    }

    public Set<DEdge> getIncomingEdges(EdgeTarget node, DDiagram diagram) {
        HashSet<DEdge> returnedSet = new HashSet<DEdge>();
        returnedSet.addAll((Collection<DEdge>)node.getIncomingEdges());
        returnedSet.retainAll((Collection<?>)diagram.getEdges());
        return returnedSet;
    }

    public Set<DEdge> getIncomingEdges(EdgeTarget node) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        return this.getIncomingEdges(node, diagram);
    }

    public Set<DEdge> getOutgoingEdges(EdgeTarget node, DDiagram diagram) {
        HashSet<DEdge> returnedSet = new HashSet<DEdge>();
        returnedSet.addAll((Collection<DEdge>)node.getOutgoingEdges());
        returnedSet.retainAll((Collection<?>)diagram.getEdges());
        return returnedSet;
    }

    public Set<DEdge> getOutgoingEdges(EdgeTarget node) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        return this.getOutgoingEdges(node, diagram);
    }

    public Set<DEdge> getAllEdges(EdgeTarget node, DDiagram diagram) {
        HashSet<DEdge> returnedSet = new HashSet<DEdge>();
        returnedSet.addAll((Collection<DEdge>)node.getOutgoingEdges());
        returnedSet.addAll((Collection<DEdge>)node.getIncomingEdges());
        returnedSet.retainAll((Collection<?>)diagram.getEdges());
        return returnedSet;
    }

    public Set<DEdge> getAllEdges(EdgeTarget node) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        return this.getAllEdges(node, diagram);
    }

    public EList<EObject> getEdgeSourceCandidates(EdgeMapping edgeMapping, EObject context, DDiagram diagram) {
        return this.getEdgeMappingHelper(context).getEdgeSourceCandidates(edgeMapping, context, diagram);
    }

    public EList<EObject> getEdgeTargetCandidates(EdgeMapping edgeMapping, EObject context, DDiagram diagram) {
        return this.getEdgeMappingHelper(context).getEdgeTargetCandidates(edgeMapping, context, diagram);
    }

    public Set<DDiagramElement> getSetOfDiagramElements(DDiagram diagram) {
        HashSet<DDiagramElement> set = new HashSet<DDiagramElement>();
        for (DDiagramElement element : this.getDiagramElements((EObject)diagram)) {
            set.add(element);
        }
        return set;
    }

    public Collection<EObject> getOwnedDiagramElementsTarget(DSemanticDecorator element) {
        HashSet<EObject> set = new HashSet<EObject>();
        EList ownedElements = null;
        if (element instanceof DDiagram) {
            ownedElements = ((DDiagram)element).getOwnedDiagramElements();
        } else if (element instanceof DDiagramElement) {
            ownedElements = ((DNodeContainer)element).getOwnedDiagramElements();
        }
        if (ownedElements != null) {
            for (DDiagramElement owned : ownedElements) {
                set.add(owned.getTarget());
            }
        }
        return set;
    }

    public Set<EObject> getSetOfDiagramElementsTarget(DDiagram diagram) {
        HashSet<EObject> set = new HashSet<EObject>();
        for (DDiagramElement element : this.getDiagramElements((EObject)diagram)) {
            set.add(element.getTarget());
        }
        set.remove(null);
        return set;
    }

    public Map<EObject, DSemanticDecorator> getMapOfDiagramElements(DDiagram diagram) {
        HashMap<EObject, DSemanticDecorator> map = new HashMap<EObject, DSemanticDecorator>();
        for (DDiagramElement element : this.getDiagramElements((EObject)diagram)) {
            map.put(element.getTarget(), (DSemanticDecorator)element);
        }
        map.remove(null);
        return map;
    }

    public Map<EObject, DragAndDropTarget> getMapOfDiagramNodes(DDiagram diagram) {
        HashMap<EObject, DragAndDropTarget> map = new HashMap<EObject, DragAndDropTarget>();
        for (DDiagramElement element : this.getDiagramElements((EObject)diagram)) {
            if (!(element instanceof DragAndDropTarget)) continue;
            map.put(element.getTarget(), (DragAndDropTarget)element);
        }
        map.remove(null);
        return map;
    }

    @Deprecated
    public List<DNodeContainer> getAllContainers(EObject view) {
        ArrayList<DNodeContainer> returnedList = new ArrayList<DNodeContainer>();
        if (view instanceof DDiagram) {
            for (AbstractDNode aContainer : ((DDiagram)view).getContainers()) {
                if (!(aContainer instanceof DNodeContainer)) continue;
                returnedList.add((DNodeContainer)aContainer);
            }
        }
        if (view instanceof DNodeContainer) {
            for (AbstractDNode aContainer : ((DNodeContainer)view).getContainers()) {
                if (!(aContainer instanceof DNodeContainer)) continue;
                returnedList.add((DNodeContainer)aContainer);
            }
            return returnedList;
        }
        return returnedList;
    }

    public List<EObject> getAllContainersAndNodeLists(EObject view) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        if (view instanceof DDiagram) {
            returnedList.addAll((Collection<EObject>)((DDiagram)view).getContainers());
        }
        if (view instanceof DNodeContainer) {
            returnedList.addAll((Collection<EObject>)((DNodeContainer)view).getContainers());
        }
        return returnedList;
    }

    public List<DNode> getAllNodes(EObject view) {
        ArrayList<DNode> returnedList = new ArrayList<DNode>();
        if (view instanceof DDiagram) {
            returnedList.addAll((Collection<DNode>)((DDiagram)view).getNodes());
        } else if (view instanceof DNodeContainer) {
            returnedList.addAll((Collection<DNode>)((DNodeContainer)view).getNodes());
            EList elements = ((DNodeContainer)view).getElements();
            for (DDiagramElement dDiagramElement : elements) {
                if (!(dDiagramElement instanceof DNode)) continue;
                returnedList.add((DNode)dDiagramElement);
            }
        } else if (view instanceof DNodeList) {
            returnedList.addAll((Collection<DNode>)((DNodeList)view).getNodes());
        } else if (view instanceof DNode) {
            returnedList.addAll((Collection<DNode>)((DNode)view).getOwnedBorderedNodes());
        }
        return returnedList;
    }

    public void selectElementInDiagram(DSemanticDecorator newTarget) {
        EObject selectedElement = newTarget.getTarget();
        if (selectedElement != null && newTarget instanceof DDiagramElement) {
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IGraphicalEditPart graphicalEditPart = null;
            if (activeEditor != null && activeEditor instanceof DiagramEditor) {
                DiagramEditor diagramEditor = (DiagramEditor)activeEditor;
                IDiagramGraphicalViewer diagramGraphicalViewer = diagramEditor.getDiagramGraphicalViewer();
                if (diagramGraphicalViewer instanceof IDiagramDialectGraphicalViewer) {
                    IDiagramDialectGraphicalViewer dialectViewer = (IDiagramDialectGraphicalViewer)diagramGraphicalViewer;
                    List allEditParts = dialectViewer.findEditPartsForElement(selectedElement, IGraphicalEditPart.class);
                    Iterator iterator = allEditParts.iterator();
                    while (iterator.hasNext()) {
                        View view;
                        EObject element;
                        Object model;
                        IGraphicalEditPart editPart = (IGraphicalEditPart)iterator.next();
                        if (editPart instanceof IDiagramNameEditPart) {
                            iterator.remove();
                        }
                        if (!((model = editPart.getModel()) instanceof View) || !newTarget.equals(element = (view = (View)model).getElement())) continue;
                        graphicalEditPart = editPart;
                        break;
                    }
                }
                if (graphicalEditPart != null) {
                    diagramGraphicalViewer.select(graphicalEditPart);
                    diagramGraphicalViewer.reveal(graphicalEditPart);
                }
            }
        }
    }

    public Collection<DNodeContainer> filterNodeContainers(Collection<DDiagramElement> elements) {
        ArrayList<DNodeContainer> edges = new ArrayList<DNodeContainer>();
        if (elements == null) {
            return edges;
        }
        for (DDiagramElement element : elements) {
            if (!(element instanceof DNodeContainer)) continue;
            edges.add((DNodeContainer)element);
        }
        return edges;
    }

    public List<AbstractDNode> filterNodes(Collection<DDiagramElement> elements) {
        ArrayList<AbstractDNode> edges = new ArrayList<AbstractDNode>();
        if (elements == null) {
            return edges;
        }
        for (DDiagramElement element : elements) {
            if (!(element instanceof AbstractDNode)) continue;
            edges.add((AbstractDNode)element);
        }
        return edges;
    }

    public List<DEdge> filterEdges(Collection<DDiagramElement> elements) {
        ArrayList<DEdge> edges = new ArrayList<DEdge>();
        if (elements == null) {
            return edges;
        }
        for (DDiagramElement element : elements) {
            if (!(element instanceof DEdge)) continue;
            edges.add((DEdge)element);
        }
        return edges;
    }

    public DEdge findInternalLinkEdge(DDiagram pDiagram, EdgeTarget firstPort, EdgeTarget secondPort, EdgeMapping mapping) {
        if (firstPort.getUid().compareTo(secondPort.getUid()) < 0) {
            EdgeTarget tmp = secondPort;
            secondPort = firstPort;
            firstPort = tmp;
        }
        for (DEdge anEdge : firstPort.getOutgoingEdges()) {
            if (anEdge.getTarget() == null || !anEdge.getTargetNode().equals(secondPort) || !mapping.equals(anEdge.getActualMapping())) continue;
            return anEdge;
        }
        for (DEdge anEdge : firstPort.getIncomingEdges()) {
            if (anEdge.getTarget() == null || !anEdge.getSourceNode().equals(secondPort) || !mapping.equals(anEdge.getActualMapping())) continue;
            return anEdge;
        }
        return null;
    }

    @Deprecated
    public DEdge findDEdgeElement(DDiagram pDiagram, EdgeTarget sourceNode, EdgeTarget targetNode, EObject semanticObject, EdgeMapping mapping) {
        for (DEdge anEdge : DDiagramSpecOperations.getEdgesFromMapping((DDiagram)pDiagram, (EdgeMapping)mapping)) {
            if (anEdge.getTarget() == null || !anEdge.getTarget().equals(semanticObject) || !anEdge.getSourceNode().equals(sourceNode) || !anEdge.getTargetNode().equals(targetNode)) continue;
            return anEdge;
        }
        return null;
    }

    @Deprecated
    public List<AbstractDNode> getNodesAndNodeListElements(EObject eObjecct) {
        return this.getAllNodesAndNodeListElements(eObjecct);
    }

    public List<AbstractDNode> getAllNodesAndNodeListElements(EObject view) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            returnedList.addAll((Collection<AbstractDNode>)((DDiagram)view).getNodes());
            returnedList.addAll((Collection<AbstractDNode>)((DDiagram)view).getNodeListElements());
        } else if (view instanceof DNodeContainer) {
            returnedList.addAll((Collection<AbstractDNode>)((DNodeContainer)view).getNodes());
            EList elements = ((DNodeContainer)view).getElements();
            for (DDiagramElement dDiagramElement : elements) {
                if (!(dDiagramElement instanceof DNode) && !(dDiagramElement instanceof DNodeListElement)) continue;
                returnedList.add((AbstractDNode)dDiagramElement);
            }
        } else if (view instanceof DNodeList) {
            returnedList.addAll((Collection<AbstractDNode>)((DNodeList)view).getNodes());
            returnedList.addAll((Collection<AbstractDNode>)((DNodeList)view).getOwnedElements());
        } else if (view instanceof DNode) {
            returnedList.addAll((Collection<AbstractDNode>)((DNode)view).getOwnedBorderedNodes());
        }
        return returnedList;
    }

    public String getFunctionalChainDiagramPrefix(EObject eObject) {
        if (eObject instanceof CapellaElement) {
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_SYSTEM_PREFIX;
            }
            if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_LOGICAL_PREFIX;
            }
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_PHYSICAL_PREFIX;
            }
        }
        return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_PREFIX;
    }

    public String getFunctionalChainDiagramSuffix(EObject eObject) {
        if (eObject instanceof CapellaElement) {
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_SYSTEM_NAME;
            }
            if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_LOGICAL_NAME;
            }
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)eObject))) {
                return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_PHYSICAL_NAME;
            }
        }
        return DiagramNamingConstants.FUNCTIONAL_CHAIN_DIAGRAM_NAME;
    }

    public EdgeMappingHelper getEdgeMappingHelper(EObject eObject) {
        return new EdgeMappingHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(eObject));
    }

    public DiagramElementMapping getEdgeMapping(DEdge aEdge) {
        if (aEdge != null && aEdge.getActualMapping() != null) {
            IEdgeMapping mapping = aEdge.getActualMapping();
            if (mapping != null && mapping instanceof EdgeMappingImport) {
                mapping = MappingHelper.getEdgeMapping((EdgeMappingImport)((EdgeMappingImport)mapping));
            }
            if (mapping != null && mapping instanceof DiagramElementMapping) {
                return (DiagramElementMapping)mapping;
            }
        }
        return null;
    }

    public DiagramElementMapping getMappingByName(RepresentationDescription targetDescription, String targetMappingName) {
        AbstractNodeMapping mapping = null;
        if (targetMappingName != null && targetDescription != null && targetDescription instanceof DiagramDescription && (mapping = DiagramServices.getDiagramServices().getAbstractNodeMapping((DiagramDescription)targetDescription, targetMappingName)) == null) {
            mapping = DiagramServices.getDiagramServices().getEdgeMapping((DiagramDescription)targetDescription, targetMappingName);
        }
        return mapping;
    }

    public HashMap<String, DiagramElementMapping> getAllMappingsByName(DiagramDescription description) {
        HashMap<String, DiagramElementMapping> result = new HashMap<String, DiagramElementMapping>();
        for (NodeMapping nodeMapping : ContentHelper.getAllNodeMappings((DiagramDescription)description, (boolean)false)) {
            result.put(nodeMapping.getName(), (DiagramElementMapping)nodeMapping);
            for (DiagramElementMapping mapping : MappingHelper.getAllMappings((DiagramElementMapping)nodeMapping)) {
                result.put(mapping.getName(), mapping);
            }
        }
        for (NodeMapping nodeMapping : ContentHelper.getAllContainerMappings((DiagramDescription)description, (boolean)false)) {
            result.put(nodeMapping.getName(), (DiagramElementMapping)nodeMapping);
            for (DiagramElementMapping mapping : MappingHelper.getAllMappings((DiagramElementMapping)nodeMapping)) {
                result.put(mapping.getName(), mapping);
                for (DiagramElementMapping borderedMapping : MappingHelper.getAllMappings((DiagramElementMapping)mapping)) {
                    result.put(borderedMapping.getName(), borderedMapping);
                }
            }
        }
        for (EdgeMapping edgeMapping : ContentHelper.getAllEdgeMappings((DiagramDescription)description, (boolean)false)) {
            result.put(edgeMapping.getName(), (DiagramElementMapping)edgeMapping);
        }
        return result;
    }

    private DiagramMappingsManager getMappingManager(DSemanticDiagram diagram) {
        Session session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        return DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, (DDiagram)diagram);
    }

    public Collection<DDiagramElement> getViewsRepresentingSameEType(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        Set eclassesToSelect = selectedViews.stream().filter(view -> view instanceof DDiagramElement).map(view -> ((DDiagramElement)view).getTarget().eClass()).collect(Collectors.toSet());
        Collection diagramElements = new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements();
        return diagramElements.stream().filter(element -> eclassesToSelect.contains(element.getTarget().eClass())).collect(Collectors.toList());
    }

    public Collection<DDiagramElement> getRelatedFunctionalChainElements(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        Collection diagramElements = new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements();
        HashSet<DDiagramElement> diagramElementsToBeSelected = new HashSet<DDiagramElement>();
        HashSet<Object> toBeSelected = new HashSet<Object>();
        HashSet exchangeCategories = new HashSet();
        for (DSemanticDecorator selectedView : selectedViews) {
            FunctionalChain selectedFC = (FunctionalChain)selectedView.getTarget();
            toBeSelected.add(selectedFC);
            Set involvedFEs = FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)selectedFC);
            toBeSelected.addAll(involvedFEs);
            for (FunctionalExchange involvedFE : involvedFEs) {
                toBeSelected.add(involvedFE.getSource());
                toBeSelected.add(involvedFE.getTarget());
                exchangeCategories.addAll(involvedFE.getCategories());
            }
        }
        diagramElementsToBeSelected.addAll(diagramElements.stream().filter(element -> toBeSelected.contains(element.getTarget())).collect(Collectors.toList()));
        for (DDiagramElement diagramElement : diagramElements) {
            DEdge edge;
            EObject edgeTarget;
            if (!(diagramElement instanceof DEdge) || !exchangeCategories.contains(edgeTarget = (edge = (DEdge)diagramElement).getTarget())) continue;
            boolean shallBeSelected = false;
            for (EObject semanticElement : edge.getSemanticElements()) {
                if (!toBeSelected.contains(semanticElement)) continue;
                shallBeSelected = true;
                break;
            }
            if (!shallBeSelected) continue;
            EdgeTarget target = edge.getTargetNode();
            EdgeTarget source = edge.getSourceNode();
            if (source instanceof DDiagramElement) {
                diagramElementsToBeSelected.add((DDiagramElement)source);
            }
            if (target instanceof DDiagramElement) {
                diagramElementsToBeSelected.add((DDiagramElement)target);
            }
            diagramElementsToBeSelected.add((DDiagramElement)edge);
        }
        return diagramElementsToBeSelected;
    }

    public Collection<DDiagramElement> getRelatedPhysicalPathElements(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        Collection diagramElements = new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements();
        HashSet<DDiagramElement> diagramElementsToBeSelected = new HashSet<DDiagramElement>();
        HashSet<Object> toBeSelected = new HashSet<Object>();
        HashSet exchangeCategories = new HashSet();
        for (DSemanticDecorator selectedView : selectedViews) {
            PhysicalPath selectedPP = (PhysicalPath)selectedView.getTarget();
            Collection involvedPLs = PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)selectedPP);
            toBeSelected.add(selectedPP);
            toBeSelected.addAll(involvedPLs);
            for (PhysicalLink involvedPL : involvedPLs) {
                toBeSelected.add(involvedPL.getSourcePhysicalPort());
                toBeSelected.add(involvedPL.getTargetPhysicalPort());
                exchangeCategories.addAll(involvedPL.getCategories());
            }
        }
        diagramElementsToBeSelected.addAll(diagramElements.stream().filter(element -> toBeSelected.contains(element.getTarget())).collect(Collectors.toList()));
        for (DDiagramElement diagramElement : diagramElements) {
            DEdge edge;
            EObject edgeTarget;
            if (!(diagramElement instanceof DEdge) || !exchangeCategories.contains(edgeTarget = (edge = (DEdge)diagramElement).getTarget())) continue;
            boolean shallBeSelected = false;
            for (EObject semanticElement : edge.getSemanticElements()) {
                if (!toBeSelected.contains(semanticElement)) continue;
                shallBeSelected = true;
                break;
            }
            if (!shallBeSelected) continue;
            EdgeTarget target = edge.getTargetNode();
            EdgeTarget source = edge.getSourceNode();
            if (source instanceof DDiagramElement) {
                diagramElementsToBeSelected.add((DDiagramElement)source);
            }
            if (target instanceof DDiagramElement) {
                diagramElementsToBeSelected.add((DDiagramElement)target);
            }
            diagramElementsToBeSelected.add((DDiagramElement)edge);
        }
        return diagramElementsToBeSelected;
    }

    public Collection<DDiagramElement> getViewsWithSameMapping(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        Set mappingsToSelect = selectedViews.stream().filter(view -> view instanceof DDiagramElement).map(view -> ((DDiagramElement)view).getDiagramElementMapping()).collect(Collectors.toSet());
        Collection diagramElements = new DDiagramQuery((DDiagram)currentDiagram).getAllDiagramElements();
        return diagramElements.stream().filter(element -> mappingsToSelect.contains(element.getDiagramElementMapping())).collect(Collectors.toList());
    }

    public Collection<DNode> getAllOwnedPorts(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        return selectedViews.stream().filter(view -> view instanceof AbstractDNode).flatMap(view -> ((AbstractDNode)view).getOwnedBorderedNodes().stream()).collect(Collectors.toList());
    }

    public Collection<DDiagramElement> getAllOwnedElements(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        return selectedViews.stream().flatMap(view -> this.getOwnedDiagramElements((EObject)view).stream()).collect(Collectors.toList());
    }

    public Collection<DEdge> getAllEdges(DSemanticDiagram currentDiagram, List<DSemanticDecorator> selectedViews) {
        HashSet<DEdge> edgesToSelect = new HashSet<DEdge>();
        for (DSemanticDecorator view : selectedViews) {
            if (view instanceof EdgeTarget) {
                EdgeTarget viewEdgeTarget = (EdgeTarget)view;
                Collection<DEdge> directEdges = this.getEdges(viewEdgeTarget);
                edgesToSelect.addAll(directEdges);
            }
            if (!(view instanceof AbstractDNode)) continue;
            AbstractDNode viewNode = (AbstractDNode)view;
            Collection portEdges = viewNode.getOwnedBorderedNodes().stream().flatMap(port -> this.getEdges((EdgeTarget)port).stream()).collect(Collectors.toSet());
            edgesToSelect.addAll(portEdges);
        }
        return edgesToSelect;
    }

    private Collection<DEdge> getEdges(EdgeTarget edgeTarget) {
        HashSet<DEdge> allEdges = new HashSet<DEdge>();
        allEdges.addAll((Collection<DEdge>)edgeTarget.getIncomingEdges());
        allEdges.addAll((Collection<DEdge>)edgeTarget.getOutgoingEdges());
        return allEdges;
    }

    public EObject getDiagramElementDiagramIfNull(DDiagram diagram, EObject semanticElement) {
        DDiagramElement viewElement = this.getDiagramElement(diagram, semanticElement);
        return viewElement == null ? diagram : viewElement;
    }

    public EObject setRelativePositionToNode(AbstractDNode newView, AbstractDNode node, int deltaX, int deltaY) {
        Point location = DiagramHelper.getRelativePositionToNode((AbstractDNode)node, (EObject)node.eContainer(), (int)deltaX, (int)deltaY);
        DiagramHelper.setPosition((AbstractDNode)newView, (Point)location);
        return newView;
    }

    public EObject setPositionAtMiddleOfEdge(AbstractDNode newView, DEdge edge, int deltaX, int deltaY) {
        Point location = DiagramHelper.getPositionAtMiddleOfEdge((DEdge)edge, (EObject)edge.eContainer(), (int)deltaX, (int)deltaY);
        DiagramHelper.setPosition((AbstractDNode)newView, (Point)location);
        return newView;
    }

    public EObject setPositionAtMiddleOfEdge(AbstractDNode newView, DEdge edge) {
        return this.setPositionAtMiddleOfEdge(newView, edge, 0, 0);
    }

    public void removeNodeWithoutEdges(DDiagramContents context, AbstractNodeMapping nodeMapping) {
        HashSet<DNode> toRemoveNodes = new HashSet<DNode>();
        for (DDiagramElement element : (Iterable)ModelCache.getCache(context::getDiagramElements, (Object)nodeMapping)) {
            if (!(element instanceof DNode) || this.isNodeEdged((EdgeTarget)((DNode)element))) continue;
            toRemoveNodes.add((DNode)element);
        }
        for (DNode dNode : toRemoveNodes) {
            this.removeAbstractDNodeView((AbstractDNode)dNode);
        }
    }

    public boolean isNodeEdged(EdgeTarget node) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        HashSet incomingEdges = new HashSet(node.getIncomingEdges());
        HashSet diagramEdges = new HashSet(diagram.getEdges());
        incomingEdges.retainAll(diagramEdges);
        if (!incomingEdges.isEmpty()) {
            return true;
        }
        HashSet outgoingEdges = new HashSet(node.getOutgoingEdges());
        outgoingEdges.retainAll(diagramEdges);
        return !outgoingEdges.isEmpty();
    }

    public void refreshRepresentationOfEditor(IEditorPart editor) {
        if (editor instanceof DialectEditor) {
            DialectEditor siriusEditor = (DialectEditor)editor;
            DRepresentation representation = siriusEditor.getRepresentation();
            CapellaServices.getService().forceRefresh((DDiagram)representation);
        }
    }

    public EditPart getEditPart(DDiagramElement diagramElement) {
        Map editPartRegistry;
        Object editPart;
        Session session;
        View gmfView;
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (editor instanceof DiagramEditor && (gmfView = SiriusGMFHelper.getGmfView((DDiagramElement)diagramElement, (Session)(session = new EObjectQuery((EObject)diagramElement).getSession()))) != null && editor instanceof DiagramEditor && (editPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(gmfView)) instanceof EditPart) {
            return (EditPart)editPart;
        }
        return null;
    }

    public void refreshBeginEndLabels(DEdge edge) {
        EditPart edgeEditPart = this.getEditPart((DDiagramElement)edge);
        if (edgeEditPart != null) {
            edgeEditPart.getChildren().stream().filter(child -> child instanceof DEdgeBeginNameEditPart || child instanceof DEdgeEndNameEditPart).forEach(editPart -> editPart.refresh());
        }
    }

    public DDiagram getOpeningDiagram() {
        DDiagramEditor ddiagramEditor;
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (activePage = window.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof DDiagramEditor && (ddiagramEditor = (DDiagramEditor)activeEditor).getRepresentation() instanceof DDiagram) {
            return (DDiagram)ddiagramEditor.getRepresentation();
        }
        return null;
    }

    public String getOverlappedLabels(List<String> names) {
        return names.stream().sorted().map(name -> StringUtils.abbreviate((String)name, (int)30)).map(name -> StringUtils.rightPad((String)name, (int)30)).collect(Collectors.joining("\n"));
    }

    class DiagramIterator
    implements Iterator<DDiagramElement> {
        LinkedList<DDiagramElement> elements = new LinkedList();
        DiagramElementMapping mapping;
        EClass clazz;
        boolean edges = true;
        boolean nodes = true;
        boolean containers = true;
        boolean borderedNodes = true;

        public DiagramIterator(EObject context, boolean edges, boolean nodes, boolean containers, boolean borderedNodes) {
            this.edges = edges;
            this.nodes = nodes;
            this.containers = containers;
            this.borderedNodes = borderedNodes;
            if (context instanceof DDiagram) {
                this.addElements(this.elements, (Collection<DDiagramElement>)((DDiagram)context).getOwnedDiagramElements());
            } else if (context instanceof DDiagramElement) {
                this.elements.addAll(this.getNexts((DDiagramElement)context));
            }
        }

        private void addElements(Collection<DDiagramElement> elements, Collection<DDiagramElement> toAdd) {
            for (DDiagramElement element : toAdd) {
                if (this.containers && element instanceof DNodeContainer) {
                    elements.add(element);
                    continue;
                }
                if (this.nodes && element instanceof AbstractDNode && !(element instanceof DNodeContainer)) {
                    elements.add(element);
                    continue;
                }
                if (!this.edges || !(element instanceof DEdge)) continue;
                elements.add(element);
            }
        }

        public DiagramIterator(EObject context) {
            this(context, true, true, true, true);
        }

        public DiagramIterator(EObject context, DiagramElementMapping mapping) {
            this(context, mapping, true, true, true, true);
        }

        public DiagramIterator(EObject context, DiagramElementMapping mapping, boolean edges, boolean nodes, boolean containers, boolean borderedNodes) {
            this(context, edges, nodes, containers, borderedNodes);
            this.mapping = mapping;
            if (mapping != null) {
                this.clazz = CapellaServices.getService().getDomainClass(context, mapping);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.elements.size() == 0) {
                return false;
            }
            DDiagramElement element = this.elements.getFirst();
            if (this.mapping == null || this.validMapping(this.mapping, element)) {
                return true;
            }
            LinkedList<DDiagramElement> nexts = new LinkedList<DDiagramElement>();
            nexts.addAll(this.elements);
            while (nexts.size() > 0) {
                DDiagramElement next = (DDiagramElement)nexts.removeFirst();
                if (this.validMapping(this.mapping, next)) {
                    return true;
                }
                nexts.addAll(this.getNexts(next));
            }
            return false;
        }

        protected Collection<DDiagramElement> getNexts(DDiagramElement context) {
            ArrayList<DDiagramElement> element = new ArrayList<DDiagramElement>();
            if (this.borderedNodes && context instanceof AbstractDNode) {
                element.addAll((Collection<DDiagramElement>)((AbstractDNode)context).getOwnedBorderedNodes());
            }
            if (context instanceof DNodeContainer) {
                this.addElements(element, (Collection<DDiagramElement>)((DNodeContainer)context).getOwnedDiagramElements());
            }
            if (context instanceof DNodeList) {
                this.addElements(element, (Collection<DDiagramElement>)((DNodeList)context).getOwnedElements());
            }
            return element;
        }

        @Override
        public DDiagramElement next() {
            if (this.hasNext()) {
                DDiagramElement element = this.elements.removeFirst();
                this.elements.addAll(this.getNexts(element));
                if (this.mapping == null || this.validMapping(this.mapping, element)) {
                    return element;
                }
                return this.next();
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.hasNext()) {
                this.next();
            }
        }

        public boolean validMapping(DiagramElementMapping mapping, DDiagramElement element) {
            return this.isSameDomain(mapping, element) && DiagramServices.this.isMapping(element, mapping);
        }

        public boolean isSameDomain(DiagramElementMapping mapping, DDiagramElement element) {
            if (this.clazz == null) {
                return true;
            }
            return this.clazz.isInstance((Object)element.getTarget());
        }
    }
}

