/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;

public class DragAndDropServices {
    public boolean canBeDropped(EObject semanticObjectToDrop, EObject targetContainerView) {
        CapellaElement capellaElement;
        DSemanticDecorator element;
        EObject target;
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer(targetContainerView);
        for (DDiagramElement anElement : currentDiagram.getDiagramElements()) {
            if (!anElement.getTarget().equals(semanticObjectToDrop)) continue;
            return false;
        }
        if (targetContainerView instanceof DSemanticDecorator && (target = (element = (DSemanticDecorator)targetContainerView).getTarget()) instanceof CapellaElement && semanticObjectToDrop instanceof CapellaElement && !CapellaLayerCheckingExt.isElementFromCurrentOrUpperLayer((CapellaElement)((CapellaElement)semanticObjectToDrop), (CapellaElement)(capellaElement = (CapellaElement)target))) {
            return false;
        }
        if (targetContainerView instanceof DDiagram) {
            return true;
        }
        return CapellaServices.getService().isChild(((DSemanticDecorator)targetContainerView).getTarget(), semanticObjectToDrop);
    }

    public boolean partitionableElementCanBeDropped(Component semanticObjectToDrop, EObject targetContainerView) {
        if (targetContainerView instanceof DDiagramElement) {
            for (DDiagramElement anElement : DiagramServices.getDiagramServices().getDiagramElements(targetContainerView)) {
                if (anElement.getTarget() == null || !anElement.getTarget().equals(semanticObjectToDrop)) continue;
                return false;
            }
        }
        DSemanticDecorator decorator = (DSemanticDecorator)targetContainerView;
        if (targetContainerView instanceof DDiagram) {
            return true;
        }
        for (Part part : semanticObjectToDrop.getRepresentingParts()) {
            java.util.Collection parents = ComponentExt.getPartAncestors((Part)part);
            if (decorator.getTarget() instanceof Part && parents.contains(decorator.getTarget())) {
                return true;
            }
            if (!(decorator.getTarget() instanceof Component)) continue;
            for (Part partE : ((Component)decorator.getTarget()).getRepresentingParts()) {
                if (!parents.contains(partE)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean partitionableElementCanBeDropped(Part part, EObject targetContainerView) {
        DSemanticDecorator decorator = (DSemanticDecorator)targetContainerView;
        if (targetContainerView instanceof DDiagram) {
            return true;
        }
        java.util.Collection parents = ComponentExt.getPartAncestors((Part)part);
        if (decorator.getTarget() instanceof Part && parents.contains(decorator.getTarget())) {
            return true;
        }
        if (decorator.getTarget() instanceof Component) {
            for (Part partE : ((Component)decorator.getTarget()).getRepresentingParts()) {
                if (!parents.contains(partE)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidIDDndInterfaceFromModel(EObject element, DSemanticDecorator newViewContainer) {
        if (element instanceof Interface) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
            if (!DiagramServices.getDiagramServices().isOnDiagram(diagram, element)) {
                if (newViewContainer instanceof DDiagram) {
                    return true;
                }
                EObject target = newViewContainer.getTarget();
                if (target != null && EcoreUtil2.isContainedBy((EObject)element, (EObject)target)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void dndIDInterfaceFromModel(EObject element, DSemanticDecorator newViewContainer) {
    }

    public boolean isValidIDDndInterfaceFromDiagram(EObject element, DSemanticDecorator newViewContainer) {
        if (newViewContainer instanceof DDiagramElement) {
            if (newViewContainer.getTarget() != null) {
                return !ComponentExt.isActor((EObject)newViewContainer.getTarget());
            }
            return false;
        }
        return true;
    }

    public void dndIDInterfaceFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        EObject targetContainer = CsServices.getService().getIBTarget(newViewContainer);
        if (element instanceof Interface) {
            Interface itf = (Interface)element;
            EObject container = CsServices.getService().getParentContainer((EObject)itf);
            if (targetContainer != null && !targetContainer.equals(container)) {
                if (targetContainer instanceof BlockArchitecture) {
                    BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)targetContainer);
                    BlockArchitectureExt.getInterfacePkg((BlockArchitecture)architecture).getOwnedInterfaces().add((Object)itf);
                } else if (targetContainer instanceof Component) {
                    Component component = (Component)targetContainer;
                    ComponentExt.getInterfacePkg((Component)component).getOwnedInterfaces().add((Object)itf);
                }
            }
        }
    }

    public void dndCDClassOrCollectionFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        if (!(element instanceof Class) && !(element instanceof Collection)) {
            return;
        }
        EObject target = newViewContainer.getTarget();
        if (target instanceof DataPkg) {
            DataPkg dataPkg = (DataPkg)target;
            EReference feature = InformationPackage.Literals.DATA_PKG__OWNED_CLASSES;
            Classifier classif = (Classifier)element;
            if (classif instanceof Collection) {
                feature = InformationPackage.Literals.DATA_PKG__OWNED_COLLECTIONS;
            }
            ((java.util.Collection)dataPkg.eGet((EStructuralFeature)feature)).add(classif);
            List allAssociations = ClassExt.getAllAssociationsButIncoming((Classifier)classif);
            for (Association assoc : allAssociations) {
                AssociationExt.moveToCorrectContainer((Association)assoc);
            }
        }
    }

    public void dndCDDataPkgFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        if (!(element instanceof DataPkg)) {
            return;
        }
        EObject target = newViewContainer.getTarget();
        if (target instanceof DataPkg) {
            DataPkg dataPkg = (DataPkg)element;
            ((DataPkg)target).getOwnedDataPkgs().add((Object)dataPkg);
            Set allAssociations = DataPkgExt.getAllInvolvedAssociations((DataPkg)dataPkg);
            for (Association assoc : allAssociations) {
                AssociationExt.moveToCorrectContainer((Association)assoc);
            }
        }
    }

    public boolean isValidIDDndAllocationExchangeItemFromModel(EObject element, DSemanticDecorator newViewContainer) {
        if (element != null && newViewContainer.getTarget() != null) {
            if (element instanceof ExchangeItem) {
                if (newViewContainer.getTarget() instanceof Interface) {
                    return true;
                }
                DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
                if (!DiagramServices.getDiagramServices().isOnDiagram(diagram, element)) {
                    if (newViewContainer instanceof DDiagram) {
                        return true;
                    }
                    EObject target = newViewContainer.getTarget();
                    if (target != null && EcoreUtil2.isContainedBy((EObject)element, (EObject)target)) {
                        return true;
                    }
                }
                return false;
            }
            if (element instanceof ExchangeItemAllocation) {
                return newViewContainer.getTarget() != null && newViewContainer.getTarget() instanceof Interface;
            }
        }
        return false;
    }

    public boolean isValidIDDndAllocationExchangeItemFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        if (element != null) {
            if (element instanceof ExchangeItem) {
                if (newViewContainer instanceof DDiagramElement) {
                    if (newViewContainer.getTarget() instanceof Component && newViewContainer.getTarget() != null) {
                        return !ComponentExt.isActor((EObject)newViewContainer.getTarget());
                    }
                    return newViewContainer.getTarget() instanceof Interface;
                }
                return true;
            }
            if (element instanceof ExchangeItemAllocation) {
                return false;
            }
        }
        return false;
    }

    public void dndIDAllocationExchangeItemFromModel(EObject element, DSemanticDecorator newViewContainer) {
        EObject target = newViewContainer.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
        if (target instanceof Interface) {
            Interface itf = (Interface)target;
            if (element instanceof ExchangeItem) {
                ExchangeItem item = (ExchangeItem)element;
                ExchangeItemAllocation allocation = InterfaceExt.addExchangeItem((Interface)itf, (ExchangeItem)item);
                InformationServices.getService().createOperationView((EObject)newViewContainer, (CapellaElement)allocation, diagram);
            } else if (element instanceof ExchangeItemAllocation) {
                ExchangeItemAllocation allocation = (ExchangeItemAllocation)element;
                if (allocation.eContainer() != itf) {
                    itf.getOwnedExchangeItemAllocations().add((Object)allocation);
                }
                InformationServices.getService().createOperationView((EObject)newViewContainer, (CapellaElement)allocation, diagram);
            }
        }
    }

    public void dndIDAllocationExchangeItemFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        EObject target = newViewContainer.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
        if (target instanceof Interface) {
            Interface itf = (Interface)target;
            if (element instanceof ExchangeItem) {
                ExchangeItem item = (ExchangeItem)element;
                ExchangeItemAllocation allocation = InterfaceExt.addExchangeItem((Interface)itf, (ExchangeItem)item);
                InformationServices.getService().createOperationView((EObject)newViewContainer, (CapellaElement)allocation, diagram);
            } else if (element instanceof ExchangeItemAllocation) {
                ExchangeItemAllocation allocation = (ExchangeItemAllocation)element;
                if (allocation.eContainer() != itf) {
                    itf.getOwnedExchangeItemAllocations().add((Object)allocation);
                }
                InformationServices.getService().createOperationView((EObject)newViewContainer, (CapellaElement)allocation, diagram);
            }
        } else if (target instanceof Component) {
            EObject targetContainer = CsServices.getService().getIBTarget(newViewContainer);
            if (element instanceof ExchangeItem) {
                ExchangeItem item = (ExchangeItem)element;
                EObject container = CsServices.getService().getParentContainer((EObject)item);
                if (targetContainer != null && !targetContainer.equals(container)) {
                    if (targetContainer instanceof BlockArchitecture) {
                        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
                        BlockArchitectureExt.getInterfacePkg((BlockArchitecture)architecture).getOwnedExchangeItems().add((Object)item);
                    } else if (targetContainer instanceof Component) {
                        Component component = (Component)targetContainer;
                        ComponentExt.getInterfacePkg((Component)component).getOwnedExchangeItems().add((Object)item);
                    }
                }
            }
        }
    }

    public boolean isValidIDDndComponentPortFromModel(EObject element, DSemanticDecorator newViewContainer) {
        EObject target;
        if (element instanceof ComponentPort && newViewContainer instanceof DDiagramElement && (target = newViewContainer.getTarget()) != null && target instanceof Component && element.eContainer() != null && element.eContainer().equals(target)) {
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
            return !DiagramServices.getDiagramServices().isOnDiagram(diagram, element);
        }
        return false;
    }

    public EObject dndIDComponentPortFromModel(EObject element, DSemanticDecorator newViewContainer) {
        this.forceHideLabelAfterDndComponentPortFromModel(element, newViewContainer);
        return element;
    }

    public boolean forceHideLabelAfterDndComponentPortFromModel(EObject element, DSemanticDecorator newViewContainer) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
        DDiagramElement portView = DiagramServices.getDiagramServices().getDiagramElement(diagram, element);
        if (portView instanceof DDiagramElement) {
            HideLabelFilter filter = DiagramFactory.eINSTANCE.createHideLabelFilter();
            portView.getGraphicalFilters().add((Object)filter);
            return true;
        }
        return false;
    }

    public void dndIDComponentPortFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        Component cs;
        ComponentPort port = (ComponentPort)element;
        if (newViewContainer.getTarget() != null && newViewContainer.getTarget() instanceof Component && !(cs = (Component)newViewContainer.getTarget()).equals(port.eContainer())) {
            FaServices.getFaServices().removeUselessPortRealizations((Port)port, true, true, false, false);
            FaServices.getFaServices().moveComponentExchanges(port);
            cs.getOwnedFeatures().add((Object)port);
        }
    }

    public boolean isValidIDDndComponentPortFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        if (element instanceof ComponentPort && newViewContainer.getTarget() != null && newViewContainer.getTarget() instanceof Component) {
            return CsServices.getService().linkReconnectSource(oldContainer, oldContainer, newViewContainer.getTarget());
        }
        return false;
    }

    public boolean isValidIDDndComponentFromModel(EObject element, DSemanticDecorator newViewContainer) {
        if (element instanceof Component) {
            EObject target;
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)newViewContainer);
            if (newViewContainer instanceof DDiagram) {
                return !DiagramServices.getDiagramServices().isOnDiagram(diagram, element);
            }
            if (newViewContainer instanceof DNodeContainer && (target = newViewContainer.getTarget()) != null && CsServices.getService().getParentContainersByParts((Component)element).contains(target)) {
                return !DiagramServices.getDiagramServices().isOnDiagram((DNodeContainer)newViewContainer, element);
            }
        }
        return false;
    }

    public void dndIDComponentFromModel(EObject element, DSemanticDecorator newViewContainer) {
    }

    public boolean isValidIDDndComponentFromDiagram(Component component, DSemanticDecorator newViewContainer) {
        EObject newContainer = null;
        if (component.isActor()) {
            newContainer = CsServices.getService().getIBTarget(newViewContainer, true);
            return ABServices.getService().isValidCreationABActor(newContainer);
        }
        newContainer = CsServices.getService().getIBTarget(newViewContainer, false);
        if (newContainer instanceof Component) {
            return ABServices.getService().isValidDndComponent(component, (Component)newContainer);
        }
        if (newContainer instanceof ComponentPkg) {
            return ABServices.getService().isValidDndComponent(component, (ComponentPkg)newContainer);
        }
        return false;
    }

    public void dndIDComponentFromDiagram(EObject element, DSemanticDecorator newViewContainer, EObject oldContainer) {
        ABServices.getService().dndABComponent((NamedElement)element, (NamedElement)oldContainer, (NamedElement)newViewContainer.getTarget());
    }
}

