/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionInvolvement;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityExtend;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityGeneralization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityOperationalCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.queries.QueryIdentifierConstants;

public class InteractionServices {
    public Collection<EObject> getInitialSelection(DDiagram diagram, Collection<EObject> scope) {
        Map<EObject, DSemanticDecorator> elements = DiagramServices.getDiagramServices().getMapOfDiagramElements(diagram);
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject object : scope) {
            if (!elements.containsKey(object)) continue;
            result.add(object);
        }
        return result;
    }

    public List<EObject> getCapabilityDiagramScopeInsertRelationship(EObject source, DDiagram diagram) {
        if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, false, true);
        }
        if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, true, false);
        }
        if ("Missions Blank".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, true, false);
        }
        if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, true, true);
        }
        if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, false, true);
        }
        if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            return this.getScopeInsertRelationship(source, (EObject)diagram, false, true);
        }
        return Collections.EMPTY_LIST;
    }

    public List<Part> getESScopeInsertComponents(Scenario scenario) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IS_SCOPE_INSERT_COMPONENTS, (Object)scenario);
    }

    public List<Part> getESScopeInsertActors(Scenario scenario) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IS_SCOPE_INSERT_ACTORS, (Object)scenario);
    }

    public List<Part> getISScopeInsertComponents(Scenario scenario) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IS_SCOPE_INSERT_COMPONENTS_FOR_LIB, (Object)scenario);
    }

    public List<Part> getISScopeInsertActors(Scenario scenario) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IS_SCOPE_INSERT_ACTORS_FOR_LIB, (Object)scenario);
    }

    protected List<EObject> getScopeInsertRelationship(EObject source, EObject diagram, boolean addActorMissionInvolvement, boolean addCapabilityManagement) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        DDiagram diag = (DDiagram)diagram;
        if (source instanceof AbstractCapability) {
            AbstractCapability capa = (AbstractCapability)source;
            if (diag.isSynchronized()) {
                if (addCapabilityManagement) {
                    if (capa instanceof Capability) {
                        for (CapabilityInvolvement involvement : ((Capability)capa).getOwnedCapabilityInvolvements()) {
                            if (!ComponentExt.isActor((Component)involvement.getSystemComponent())) continue;
                            result.add((EObject)involvement.getSystemComponent());
                        }
                    } else if (capa instanceof OperationalCapability) {
                        EList ownedEntityOperationalCapabilityInvolvements = ((OperationalCapability)capa).getOwnedEntityOperationalCapabilityInvolvements();
                        for (Object involvement : ownedEntityOperationalCapabilityInvolvements) {
                            result.add((EObject)involvement.getEntity());
                        }
                    }
                    result.addAll((Collection<EObject>)capa.getSub());
                    result.addAll((Collection<EObject>)capa.getSuper());
                    result.addAll((Collection<EObject>)capa.getExtendedAbstractCapabilities());
                    for (AbstractCapabilityExtend extend : capa.getExtending()) {
                        result.add((EObject)extend.getExtension());
                    }
                    result.addAll((Collection<EObject>)capa.getIncludedAbstractCapabilities());
                    for (AbstractCapabilityExtend extend : capa.getIncluding()) {
                        result.add((EObject)extend.getInclusion());
                    }
                }
                if (capa instanceof Capability) {
                    result.addAll((Collection<EObject>)((Capability)capa).getPurposeMissions());
                }
            } else {
                if (addCapabilityManagement) {
                    if (capa instanceof Capability) {
                        result.addAll(((Capability)capa).getOwnedCapabilityInvolvements().stream().filter(inv -> ComponentExt.isActor((EObject)inv.getInvolved())).collect(Collectors.toList()));
                    } else if (capa instanceof OperationalCapability) {
                        result.addAll((Collection<EObject>)((OperationalCapability)capa).getOwnedEntityOperationalCapabilityInvolvements());
                    }
                    result.addAll((Collection<EObject>)capa.getSubGeneralizations());
                    result.addAll((Collection<EObject>)capa.getSuperGeneralizations());
                    result.addAll((Collection<EObject>)capa.getExtending());
                    result.addAll((Collection<EObject>)capa.getIncluding());
                    result.addAll((Collection<EObject>)capa.getExtends());
                    result.addAll((Collection<EObject>)capa.getIncludes());
                }
                if (capa instanceof Capability) {
                    result.addAll((Collection<EObject>)((Capability)capa).getPurposes());
                }
            }
        } else if (source instanceof Entity) {
            Entity entity = (Entity)source;
            EList involvingInvolvements = entity.getInvolvingInvolvements();
            if (diag.isSynchronized()) {
                for (Involvement involvement : involvingInvolvements) {
                    InvolverElement involver = involvement.getInvolver();
                    if (involver == null || !(involver instanceof OperationalCapability)) continue;
                    result.add((EObject)involver);
                }
            } else {
                for (Involvement involvement : involvingInvolvements) {
                    InvolverElement involver = involvement.getInvolver();
                    if (involver == null || !(involver instanceof OperationalCapability)) continue;
                    result.add((EObject)involvement);
                }
            }
        } else if (ComponentExt.isActor((EObject)source)) {
            Component actor = (Component)source;
            if (diag.isSynchronized()) {
                result.addAll((Collection<EObject>)actor.getSub());
                result.addAll((Collection<EObject>)actor.getSuper());
                if (addCapabilityManagement) {
                    if (actor instanceof SystemComponent) {
                        result.addAll((Collection<EObject>)((SystemComponent)actor).getInvolvingCapabilities());
                    } else if (actor instanceof CapabilityRealizationInvolvedElement) {
                        result.addAll((Collection<EObject>)((CapabilityRealizationInvolvedElement)actor).getInvolvingCapabilityRealizations());
                    }
                }
                if (addActorMissionInvolvement && actor instanceof SystemComponent) {
                    result.addAll((Collection<EObject>)((SystemComponent)actor).getInvolvingMissions());
                }
            } else {
                result.addAll((Collection<EObject>)actor.getSubGeneralizations());
                result.addAll((Collection<EObject>)actor.getSuperGeneralizations());
                if (addCapabilityManagement) {
                    if (actor instanceof SystemComponent) {
                        result.addAll((Collection<EObject>)((SystemComponent)actor).getCapabilityInvolvements());
                    } else if (actor instanceof CapabilityRealizationInvolvedElement) {
                        result.addAll((Collection<EObject>)((CapabilityRealizationInvolvedElement)actor).getCapabilityRealizationInvolvements());
                    }
                }
                if (addActorMissionInvolvement && actor instanceof SystemComponent) {
                    result.addAll((Collection<EObject>)((SystemComponent)actor).getMissionInvolvements());
                }
            }
        } else if (source instanceof Mission) {
            Mission mission = (Mission)source;
            if (diag.isSynchronized()) {
                result.addAll((Collection<EObject>)mission.getExploitedCapabilities());
                if (addActorMissionInvolvement) {
                    for (MissionInvolvement involvement : mission.getOwnedMissionInvolvements()) {
                        if (!ComponentExt.isActor((Component)involvement.getSystemComponent())) continue;
                        result.add((EObject)involvement.getSystemComponent());
                    }
                }
            } else {
                if (addActorMissionInvolvement) {
                    result.addAll(mission.getOwnedMissionInvolvements().stream().filter(inv -> ComponentExt.isActor((Component)inv.getSystemComponent())).collect(Collectors.toList()));
                }
                result.addAll((Collection<EObject>)mission.getOwnedCapabilityExploitations());
            }
        }
        return result;
    }

    protected EdgeMapping getEdgeMapping(DDiagram diagram, EObject object) {
        String mappingName = null;
        if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            if (object instanceof CapabilityInvolvement) {
                mappingName = "ActCapInv3";
            } else if (object instanceof CapabilityExploitation) {
                mappingName = "CapExploitation3";
            } else if (object instanceof AbstractCapabilityExtend) {
                mappingName = "AbsCapExtends3";
            } else if (object instanceof AbstractCapabilityInclude) {
                mappingName = "AbsCapInclude3";
            } else if (object instanceof AbstractCapabilityGeneralization) {
                mappingName = "Generalization3";
            } else if (object instanceof Generalization) {
                mappingName = "actorGeneralization1";
            }
        } else if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            if (object instanceof CapabilityExploitation) {
                mappingName = "CapExploitation";
            } else if (object instanceof Generalization) {
                mappingName = "actorGeneralization4";
            } else if (object instanceof MissionInvolvement) {
                mappingName = "ActMissInv";
            }
        } else if ("Missions Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof CapabilityExploitation) {
                mappingName = "CapExploitation2";
            } else if (object instanceof Generalization) {
                mappingName = "actorGeneralization3";
            } else if (object instanceof MissionInvolvement) {
                mappingName = "ActMissInv2";
            }
        } else if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof CapabilityInvolvement) {
                mappingName = "ActCapInv4";
            } else if (object instanceof CapabilityExploitation) {
                mappingName = "CapExploitation4";
            } else if (object instanceof AbstractCapabilityExtend) {
                mappingName = "AbsCapExtends4int";
            } else if (object instanceof AbstractCapabilityInclude) {
                mappingName = "AbsCapInclude4int";
            } else if (object instanceof AbstractCapabilityGeneralization) {
                mappingName = "Generalization4int";
            } else if (object instanceof Generalization) {
                mappingName = "actorGeneralization2";
            } else if (object instanceof MissionInvolvement) {
                mappingName = "ActMissInv3";
            }
        } else if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof CommunicationMean) {
                mappingName = "COC_CommunicationMeans";
            } else if (object instanceof EntityOperationalCapabilityInvolvement) {
                mappingName = "COC_EntityOperationalCapabilityInvolvement";
            } else if (object instanceof AbstractCapabilityExtend) {
                mappingName = "COC_OC_Extends";
            } else if (object instanceof AbstractCapabilityInclude) {
                mappingName = "COC_OC_Include";
            } else if (object instanceof AbstractCapabilityGeneralization) {
                mappingName = "COC_OC_Generalization";
            }
        } else if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            if (object instanceof EntityOperationalCapabilityInvolvement) {
                mappingName = "COC2_EntityCapabilityInvolvement";
            } else if (object instanceof AbstractCapabilityExtend) {
                mappingName = "COC2_OC_Extends";
            } else if (object instanceof AbstractCapabilityInclude) {
                mappingName = "COC2_OC_Include";
            } else if (object instanceof AbstractCapabilityGeneralization) {
                mappingName = "COC2_OC_Generalization";
            }
        }
        if (mappingName != null) {
            return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        }
        return null;
    }

    protected AbstractNodeMapping getNodeMapping(DDiagram diagram, EObject object) {
        String mappingName = null;
        if ("Contextual Capability".equals(diagram.getDescription().getName())) {
            if (object instanceof Component) {
                mappingName = "ActorNode3";
            } else if (object instanceof Mission) {
                mappingName = "MissionNode3";
            } else if (object instanceof Capability) {
                mappingName = "Capability3";
            }
        } else if ("Contextual Mission".equals(diagram.getDescription().getName())) {
            if (object instanceof Component) {
                mappingName = "ActorNode";
            } else if (object instanceof Mission) {
                mappingName = "MissionNode";
            } else if (object instanceof Capability) {
                mappingName = "CapNode";
            }
        } else if ("Missions Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof Component) {
                mappingName = "ActorNode2";
            } else if (object instanceof Mission) {
                mappingName = "MissionNode2";
            } else if (object instanceof Capability) {
                mappingName = "CapNode2";
            }
        } else if ("Missions Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof Component) {
                mappingName = "ActorNode4";
            } else if (object instanceof Mission) {
                mappingName = "MissionNode4";
            } else if (object instanceof Capability) {
                mappingName = "CapabilityNode4";
            }
        } else if ("Operational Capabilities Blank".equals(diagram.getDescription().getName())) {
            if (object instanceof Entity) {
                mappingName = "COC_OperationalEntities";
            } else if (object instanceof OperationalCapability) {
                mappingName = "COC_OperationalCapabilities";
            }
        } else if ("Contextual Operational Capability".equals(diagram.getDescription().getName())) {
            if (object instanceof Entity) {
                mappingName = "COC2_Entities";
            } else if (object instanceof OperationalCapability) {
                mappingName = "COC2_OperationalCapabilities";
            }
        }
        if (mappingName != null) {
            return DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, mappingName);
        }
        return null;
    }

    public void showHideRelationshipInCapabilityDiagram(EObject context, EObject sourceView, Collection<EObject> selectedItems, Collection<EObject> scope) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(sourceView);
        DiagramServices ds = DiagramServices.getDiagramServices();
        Map<EObject, DSemanticDecorator> elements = ds.getMapOfDiagramElements(diagram);
        for (EObject object : selectedItems) {
            AbstractNodeMapping nodeMapping = this.getNodeMapping(diagram, object);
            if (nodeMapping != null) {
                AbstractDNode container = ds.createAbstractDNode(nodeMapping, object, (DragAndDropTarget)diagram, diagram);
                elements.put(object, (DSemanticDecorator)container);
                continue;
            }
            EdgeMapping edgeMapping = this.getEdgeMapping(diagram, object);
            if (edgeMapping == null) continue;
            EObject source = null;
            EObject target = null;
            EList<EObject> sourceCandidates = ds.getEdgeSourceCandidates(edgeMapping, object, diagram);
            EList<EObject> targetCandidates = ds.getEdgeTargetCandidates(edgeMapping, object, diagram);
            if (sourceCandidates.size() > 0) {
                source = (EObject)sourceCandidates.get(0);
            }
            if (targetCandidates.size() > 0) {
                target = (EObject)targetCandidates.get(0);
            }
            DSemanticDecorator srcView = elements.get(source);
            if (source != null && (srcView = elements.get(source)) == null && (nodeMapping = this.getNodeMapping(diagram, source)) != null) {
                AbstractDNode container = ds.createAbstractDNode(nodeMapping, source, (DragAndDropTarget)diagram, diagram);
                elements.put(source, (DSemanticDecorator)container);
                srcView = container;
            }
            DSemanticDecorator targetView = elements.get(target);
            if (target != null && (targetView = elements.get(target)) == null && (nodeMapping = this.getNodeMapping(diagram, target)) != null) {
                AbstractDNode container = ds.createAbstractDNode(nodeMapping, target, (DragAndDropTarget)diagram, diagram);
                elements.put(target, (DSemanticDecorator)container);
                targetView = container;
            }
            if (srcView == null || targetView == null || ds.isOnDiagram(diagram, object)) continue;
            ds.createEdge(edgeMapping, (EdgeTarget)srcView, (EdgeTarget)targetView, object);
        }
        for (EObject elementScope : scope) {
            if (!elements.containsKey(elementScope) || selectedItems.contains(elementScope)) continue;
            DSemanticDecorator diagramElement = elements.get(elementScope);
            if (diagramElement instanceof DEdge) {
                ds.removeEdgeView((DEdge)diagramElement);
                continue;
            }
            if (!(diagramElement instanceof AbstractDNode)) continue;
            ds.removeAbstractDNodeView((AbstractDNode)diagramElement);
        }
    }
}

