/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.UIUtil;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SequenceMessageExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.cache.ScenarioCache;

public class SequenceDiagramServices {
    public static InstanceRole currentInstanceRole(EObject eObject) {
        if (eObject instanceof InstanceRole) {
            return (InstanceRole)eObject;
        }
        if (eObject instanceof Execution) {
            return ScenarioCache.getInstance().getInteractionCache(Execution::getCovered, (Execution)eObject);
        }
        if (eObject instanceof AbstractEnd) {
            return ScenarioCache.getInstance().getInteractionCache(AbstractEnd::getCovered, (AbstractEnd)eObject);
        }
        if (eObject instanceof StateFragment) {
            return ScenarioCache.getInstance().getInteractionCache(state -> SequenceDiagramServices.currentInstanceRole((EObject)((StateFragment)state).getStart()), eObject);
        }
        return null;
    }

    public static Collection<Execution> getExecutionsFromInstanceRoleOrParentExecution(EObject eObject) {
        return ScenarioCache.getInstance().getExecutionSemanticCandidates(SequenceDiagramServices.currentInstanceRole(eObject), eObject);
    }

    public static List<InteractionFragment> getOrderedInteractionFragments(Scenario scenario) {
        if (scenario == null) {
            return new ArrayList<InteractionFragment>();
        }
        return scenario.getOwnedInteractionFragments();
    }

    public static EObject getSendingEndEvent(SequenceMessage message) {
        return message.getSendingEnd();
    }

    public static EObject getReceivingEndEvent(SequenceMessage message) {
        return message.getReceivingEnd();
    }

    public static EObject getSendingEnd(SequenceMessage message) {
        MessageEnd end = message.getSendingEnd();
        if (end == null) {
            return message;
        }
        InstanceRole currentInstanceRole = SequenceDiagramServices.currentInstanceRole((EObject)end);
        List<ScenarioCache.SemanticCandidateContext> semanticCandidateContexts = ScenarioCache.getInstance().getSemanticCandidateContexts(currentInstanceRole);
        Optional<ScenarioCache.SemanticCandidateContext> sendingEvent = semanticCandidateContexts.stream().filter(ec -> ec.isStart() && ec.getElement().equals(message)).findFirst();
        return sendingEvent.isPresent() ? sendingEvent.get().getParent() : currentInstanceRole;
    }

    public static EObject getReceivingEnd(SequenceMessage message) {
        MessageEnd end = message.getReceivingEnd();
        if (end == null) {
            return message;
        }
        InstanceRole currentInstanceRole = SequenceDiagramServices.currentInstanceRole((EObject)end);
        List<ScenarioCache.SemanticCandidateContext> semanticCandidateContexts = ScenarioCache.getInstance().getSemanticCandidateContexts(currentInstanceRole);
        Optional<ScenarioCache.SemanticCandidateContext> receivingEvent = semanticCandidateContexts.stream().filter(ec -> !ec.isStart() && ec.getElement().equals(message)).findFirst();
        return receivingEvent.isPresent() ? receivingEvent.get().getParent() : currentInstanceRole;
    }

    public static Scenario getScenario(EObject object) {
        EObject result = object;
        if (result instanceof DSemanticDecorator) {
            result = ((DSemanticDecorator)result).getTarget();
        }
        while (!(result instanceof Scenario)) {
            result = result.eContainer();
        }
        return (Scenario)(result instanceof Scenario ? result : null);
    }

    public static SequenceMessage getInvocationMessage(SequenceMessage message) {
        return SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)message);
    }

    public static EObject doReorder(EObject object, EObject startingEndPredecessorAfter, EObject finishingEndPredecessorAfter) {
        InteractionFragment newPredecessor = (InteractionFragment)startingEndPredecessorAfter;
        InteractionFragment newPredecessorOfEnd = (InteractionFragment)finishingEndPredecessorAfter;
        Scenario scenario = (Scenario)object.eContainer();
        if (object instanceof SequenceMessage) {
            SequenceMessage reorderedMessage = (SequenceMessage)object;
            SequenceDiagramServices.reorderSequenceMessage(scenario, newPredecessor, newPredecessorOfEnd, reorderedMessage);
        } else if (object instanceof TimeLapse) {
            TimeLapse execution = (TimeLapse)object;
            SequenceDiagramServices.reorderTimeLapse(scenario, newPredecessor, newPredecessorOfEnd, execution);
        } else if (object instanceof InteractionState) {
            InteractionState interactionState = (InteractionState)object;
            SequenceDiagramServices.reorderInteractionState(scenario, newPredecessor, newPredecessorOfEnd, interactionState);
        } else if (object instanceof InteractionOperand) {
            InteractionOperand interactionOperand = (InteractionOperand)object;
            SequenceDiagramServices.reorderInteractionOperand(scenario, newPredecessor, newPredecessorOfEnd, interactionOperand);
        }
        return object;
    }

    public static void validateOrdering(Scenario scenario) {
        if (!ScenarioExt.checkOrdering((Scenario)scenario)) {
            SequenceDiagramServices.orderingError(scenario);
        }
    }

    private static void reorderInteractionFragment(Scenario scenario, InteractionFragment newPredecessor, InteractionFragment currentFragment) {
        int currentFragmentIndex = -1;
        if (currentFragment != null) {
            currentFragmentIndex = scenario.getOwnedInteractionFragments().indexOf((Object)currentFragment);
            int currentIndexNewPredecessor = -1;
            if (newPredecessor != null) {
                currentIndexNewPredecessor = scenario.getOwnedInteractionFragments().indexOf((Object)newPredecessor);
            }
            if (currentFragmentIndex < currentIndexNewPredecessor) {
                scenario.getOwnedInteractionFragments().move(currentIndexNewPredecessor, currentFragmentIndex);
            } else if (currentFragmentIndex > currentIndexNewPredecessor) {
                scenario.getOwnedInteractionFragments().move(currentIndexNewPredecessor + 1, currentFragmentIndex);
            }
        }
    }

    private static void reorderInteractionState(Scenario scenario, InteractionFragment newPredecessor, InteractionFragment newPredecessorOfEnd, InteractionState interactionState) {
        SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessor, (InteractionFragment)interactionState);
    }

    private static void reorderInteractionOperand(Scenario scenario, InteractionFragment newPredecessor, InteractionFragment newPredecessorOfEnd, InteractionOperand interactionOperand) {
        SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessor, (InteractionFragment)interactionOperand);
    }

    private static void reorderTimeLapse(Scenario scenario, InteractionFragment newPredecessor, InteractionFragment newPredecessorOfEnd, TimeLapse execution) {
        SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessor, execution.getStart());
        SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessorOfEnd, execution.getFinish());
    }

    private static void reorderSequenceMessage(Scenario scenario, InteractionFragment newPredecessor, InteractionFragment newPredecessorOfEnd, SequenceMessage reorderedMessage) {
        MessageEnd begin = reorderedMessage.getSendingEnd();
        MessageEnd end = reorderedMessage.getReceivingEnd();
        if (begin != null) {
            SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessor, (InteractionFragment)begin);
        }
        if (end != null) {
            SequenceDiagramServices.reorderInteractionFragment(scenario, newPredecessorOfEnd, (InteractionFragment)end);
        }
        EList fragments = null;
        EList messages = null;
        fragments = scenario.getOwnedInteractionFragments();
        messages = scenario.getOwnedMessages();
        if (newPredecessor == null) {
            messages.move(0, (Object)reorderedMessage);
        } else {
            SequenceMessage previousMessage = SequenceDiagramServices.findCorrespondingPreviousMessage((EList<InteractionFragment>)fragments, newPredecessor);
            if (previousMessage != null) {
                int positionMessage = messages.indexOf((Object)previousMessage);
                if (positionMessage + 1 < messages.size()) {
                    messages.move(positionMessage + 1, (Object)reorderedMessage);
                } else {
                    messages.move(positionMessage, (Object)reorderedMessage);
                }
            } else {
                messages.move(0, (Object)reorderedMessage);
            }
        }
    }

    private static SequenceMessage findCorrespondingPreviousMessage(EList<InteractionFragment> fragments, InteractionFragment predecessor) {
        if (predecessor instanceof MessageEnd) {
            return ((MessageEnd)predecessor).getMessage();
        }
        int pos = fragments.indexOf((Object)predecessor);
        if (pos != 0) {
            return SequenceDiagramServices.findCorrespondingPreviousMessage(fragments, (InteractionFragment)fragments.get(pos - 1));
        }
        return null;
    }

    public static boolean allowCreateMessageCreation2(EObject current, EObject preTarget, EObject preSource, EObject eventEndBefore, EObject eventEndAfter) {
        EObject preMessageEndBefore = null;
        EventEnd eventEndBefore_ = (EventEnd)eventEndBefore;
        if (eventEndBefore_ != null) {
            preMessageEndBefore = eventEndBefore_.getSemanticEnd();
        }
        EObject preMessageEndAfter = null;
        EventEnd eventEndAfter_ = (EventEnd)eventEndAfter;
        if (eventEndAfter_ != null) {
            preMessageEndAfter = eventEndAfter_.getSemanticEnd();
        }
        return SequenceDiagramServices.allowCreateMessageCreation(current, preTarget, preSource, preMessageEndBefore, preMessageEndAfter);
    }

    public static boolean allowCreateMessageCreation(EObject current, EObject preTarget, EObject preSource, EObject preMessageEndBefore, EObject preMessageEndAfter) {
        if (preSource.equals(preTarget)) {
            return false;
        }
        Scenario scenario = (Scenario)current.eContainer();
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            InstanceRole ir;
            if (message.getKind() != MessageKind.CREATE || (ir = message.getReceivingEnd().getCovered()) != preTarget) continue;
            return false;
        }
        if (preMessageEndBefore == null) {
            return true;
        }
        for (InteractionFragment fragment : scenario.getOwnedInteractionFragments()) {
            if (fragment == preMessageEndBefore || fragment == preMessageEndAfter) break;
            if (!fragment.getCoveredInstanceRoles().contains((Object)preTarget)) continue;
            return false;
        }
        return true;
    }

    public static boolean allowDeleteMessageCreation2(EObject current, EObject preTarget, EObject preSource, EObject eventEndBefore, EObject eventEndAfter) {
        EObject preMessageEndBefore = null;
        EventEnd eventEndBefore_ = (EventEnd)eventEndBefore;
        if (eventEndBefore_ != null) {
            preMessageEndBefore = eventEndBefore_.getSemanticEnd();
        }
        EObject preMessageEndAfter = null;
        EventEnd eventEndAfter_ = (EventEnd)eventEndAfter;
        if (eventEndAfter_ != null) {
            preMessageEndAfter = eventEndAfter_.getSemanticEnd();
        }
        return SequenceDiagramServices.allowDeleteMessageCreation(current, preTarget, preSource, preMessageEndBefore, preMessageEndAfter);
    }

    public static boolean allowDeleteMessageCreation(EObject current, EObject preTarget, EObject preSource, EObject preMessageEndBefore, EObject preMessageEndAfter) {
        if (preSource.equals(preTarget)) {
            return false;
        }
        Scenario scenario = (Scenario)current.eContainer();
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            InstanceRole ir;
            if (message.getKind() != MessageKind.DELETE || (ir = message.getReceivingEnd().getCovered()) != preTarget) continue;
            return false;
        }
        ArrayList<InteractionFragment> fragments = new ArrayList<InteractionFragment>(scenario.getOwnedInteractionFragments().size());
        for (InteractionFragment fragment : scenario.getOwnedInteractionFragments()) {
            fragments.add(0, fragment);
        }
        for (InteractionFragment fragment : fragments) {
            if (fragment == preMessageEndBefore || fragment == preMessageEndAfter) break;
            if (!fragment.getCoveredInstanceRoles().contains((Object)preTarget)) continue;
            return false;
        }
        return true;
    }

    public static boolean allowMessageCreation2(EObject current, EObject preSource, EObject preTarget, boolean withReturn, EObject eventEndBefore, EObject eventEndAfter) {
        EObject preMessageEndBefore = null;
        EventEnd eventEndBefore_ = (EventEnd)eventEndBefore;
        if (eventEndBefore_ != null) {
            preMessageEndBefore = eventEndBefore_.getSemanticEnd();
        }
        EObject preMessageEndAfter = null;
        EventEnd eventEndAfter_ = (EventEnd)eventEndAfter;
        if (eventEndAfter_ != null) {
            preMessageEndAfter = eventEndAfter_.getSemanticEnd();
        }
        return SequenceDiagramServices.allowMessageCreation(current, preSource, preTarget, withReturn, preMessageEndBefore, preMessageEndAfter);
    }

    public static boolean allowMessageCreation(EObject current, EObject preSource, EObject preTarget, boolean withReturn, EObject endBefore, EObject endAfter) {
        InstanceRole targetInstance;
        Execution exec;
        InstanceRole sourceInstance;
        InstanceRole ir;
        if (preSource == null) {
            return false;
        }
        if (preTarget == null) {
            return false;
        }
        if (preSource instanceof InstanceRole) {
            sourceInstance = ir = (InstanceRole)preSource;
        } else {
            exec = (Execution)preSource;
            sourceInstance = exec.getCovered();
        }
        if (preTarget instanceof InstanceRole) {
            targetInstance = ir = (InstanceRole)preTarget;
        } else {
            exec = (Execution)preTarget;
            targetInstance = exec.getCovered();
        }
        InstanceRole exchangeItemLifeLine = null;
        if (sourceInstance.getRepresentedInstance() instanceof ExchangeItemInstance) {
            exchangeItemLifeLine = sourceInstance;
        }
        if (targetInstance.getRepresentedInstance() instanceof ExchangeItemInstance) {
            exchangeItemLifeLine = targetInstance;
        }
        if (sourceInstance.equals(targetInstance)) {
            Scenario s = (Scenario)sourceInstance.eContainer();
            boolean betweenElement = endBefore == null;
            for (InteractionFragment interactionFragment : s.getOwnedInteractionFragments()) {
                if (interactionFragment instanceof InteractionOperand && betweenElement) {
                    return false;
                }
                if (interactionFragment.equals(endAfter)) break;
                if (!interactionFragment.equals(endBefore)) continue;
                betweenElement = true;
            }
        }
        if (exchangeItemLifeLine == null) {
            return true;
        }
        ExchangeItem exchangeItem = (ExchangeItem)exchangeItemLifeLine.getRepresentedInstance().getAbstractType();
        if (exchangeItem.getExchangeMechanism() == ExchangeMechanism.SHARED_DATA) {
            return SequenceDiagramServices.allowMessageCreationOnSharedData(preSource, preTarget, withReturn, sourceInstance, targetInstance, exchangeItemLifeLine);
        }
        return SequenceDiagramServices.allowMessageCreationOnEvent(preSource, preTarget, withReturn, sourceInstance, targetInstance, exchangeItemLifeLine);
    }

    private static boolean allowMessageCreationOnEvent(EObject preSource, EObject preTarget, boolean withReturn, InstanceRole sourceInstance, InstanceRole targetInstance, InstanceRole exchangeItemLifeLine) {
        return !withReturn && targetInstance.getRepresentedInstance() instanceof Part;
    }

    private static boolean allowMessageCreationOnSharedData(EObject preSource, EObject preTarget, boolean withReturn, InstanceRole sourceInstance, InstanceRole targetInstance, InstanceRole exchangeItemLifeLine) {
        boolean case2found = false;
        boolean case3found = false;
        Scenario s = (Scenario)sourceInstance.eContainer();
        for (SequenceMessage existingSequenceMessage : s.getOwnedMessages()) {
            if ((existingSequenceMessage.getSendingEnd().getCovered() != sourceInstance || existingSequenceMessage.getReceivingEnd().getCovered() != targetInstance) && (existingSequenceMessage.getSendingEnd().getCovered() != targetInstance || existingSequenceMessage.getReceivingEnd().getCovered() != sourceInstance)) continue;
            if (existingSequenceMessage.getReceivingEnd().getCovered() == exchangeItemLifeLine && SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)existingSequenceMessage) != null) {
                case3found = true;
            }
            if (existingSequenceMessage.getSendingEnd().getCovered() != exchangeItemLifeLine || existingSequenceMessage.getKind() == MessageKind.REPLY) continue;
            case2found = true;
        }
        if (!withReturn && sourceInstance.getRepresentedInstance() instanceof Part && preTarget instanceof InstanceRole) {
            return true;
        }
        if (!case3found && !withReturn && targetInstance.getRepresentedInstance() instanceof Part && (preSource instanceof Execution || preSource instanceof InstanceRole)) {
            return true;
        }
        return !case2found && withReturn && sourceInstance.getRepresentedInstance() instanceof Part && (preTarget instanceof Execution || preTarget instanceof InstanceRole);
    }

    public static AbstractFragment getFragmentFromContained(EObject context) {
        if (context instanceof AbstractFragment) {
            AbstractFragment af = (AbstractFragment)context;
            return af;
        }
        if (context instanceof InteractionOperand) {
            ScenarioCache.OperandContext operandContext = ScenarioCache.getInstance().getOperandContext((InteractionOperand)context);
            return operandContext.getCombinedFragment();
        }
        return null;
    }

    public static void refreshOrdering(DDiagram ddiagram) {
        UIUtil.getInstance().refreshActiveDiagram((EObject)ddiagram);
    }

    public static void setCoveredIR(AbstractFragment fragment, List<InstanceRole> newCovered) {
        fragment.getStart().getCoveredInstanceRoles().clear();
        fragment.getStart().getCoveredInstanceRoles().addAll(newCovered);
        fragment.getFinish().getCoveredInstanceRoles().clear();
        fragment.getFinish().getCoveredInstanceRoles().addAll(newCovered);
        if (fragment instanceof CombinedFragment) {
            CombinedFragment new_name = (CombinedFragment)fragment;
            for (InteractionOperand op : new_name.getReferencedOperands()) {
                op.getCoveredInstanceRoles().clear();
                op.getCoveredInstanceRoles().addAll(newCovered);
            }
        }
    }

    public static List<String> getOperators(EObject context) {
        ArrayList<String> result = new ArrayList<String>(10);
        InteractionOperatorKind[] interactionOperatorKindArray = InteractionOperatorKind.values();
        int n = interactionOperatorKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            InteractionOperatorKind kind = interactionOperatorKindArray[n2];
            String str = kind.toString();
            if (!(str.equals("") || str.equals("ALT") || str.equals("LOOP") || str.equals("PAR"))) {
                result.add(str);
            }
            ++n2;
        }
        return result;
    }

    public static void removeInstanceRoles(EObject context, Collection<EObject> result, Collection<EObject> current) {
        HashSet<InstanceRole> irToRemove = new HashSet<InstanceRole>();
        for (EObject obj : current) {
            InstanceRole ir;
            if (!(obj instanceof InstanceRole) || result.contains((ir = (InstanceRole)obj).getRepresentedInstance())) continue;
            irToRemove.add(ir);
        }
        CapellaDeleteCommand mdc = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)context), irToRemove, false, false, true);
        if (mdc.canExecute()) {
            mdc.execute();
        }
    }

    public static void orderingError(Scenario scenario) {
        OperationCanceledException exception = new OperationCanceledException(Messages.SequenceDiagramServices_3);
        Status errorStatus = new Status(4, "org.polarsys.capella.core.sirius.analysis", 0, Messages.SequenceDiagramServices_0, (Throwable)exception);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.SequenceDiagramServices_1, (String)Messages.SequenceDiagramServices_2, (IStatus)errorStatus);
        throw exception;
    }

    private static boolean containsOaActivity(Scenario s) {
        for (InstanceRole ir : s.getOwnedInstanceRoles()) {
            if (!(ir.getRepresentedInstance() instanceof OperationalActivity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidEntityScenario(EObject ctx) {
        if (ctx instanceof Scenario) {
            Scenario s = (Scenario)ctx;
            if (CapellaServices.getService().isOperationalContext(s) && (s.getKind().equals((Object)ScenarioKind.INTERACTION) || s.getKind().equals((Object)ScenarioKind.UNSET))) {
                return s.getOwnedInstanceRoles().size() == 0 || !SequenceDiagramServices.containsOaActivity(s);
            }
            return false;
        }
        return CapellaServices.getService().isOperationalContext((AbstractCapability)ctx);
    }

    public static boolean isValidActivityScenario(EObject ctx) {
        if (ctx instanceof Scenario) {
            Scenario s = (Scenario)ctx;
            if (CapellaServices.getService().isOperationalContext(s) && (s.getKind().equals((Object)ScenarioKind.INTERACTION) || s.getKind().equals((Object)ScenarioKind.UNSET))) {
                return s.getOwnedInstanceRoles().size() == 0 || SequenceDiagramServices.containsOaActivity(s);
            }
            return false;
        }
        return CapellaServices.getService().isOperationalContext((AbstractCapability)ctx);
    }

    public static boolean isValidIS(EObject ctx) {
        if (ctx instanceof Scenario) {
            Scenario s = (Scenario)ctx;
            return !CapellaServices.getService().isOperationalContext(s) && (s.getKind().equals((Object)ScenarioKind.INTERFACE) || s.getKind().equals((Object)ScenarioKind.UNSET));
        }
        return !CapellaServices.getService().isOperationalContext((AbstractCapability)ctx);
    }

    public static boolean isValidES(EObject ctx) {
        if (ctx instanceof Scenario) {
            Scenario s = (Scenario)ctx;
            return !CapellaServices.getService().isOperationalContext(s) && !CapellaServices.getService().isEPBSContext((ModelElement)s) && (s.getKind().equals((Object)ScenarioKind.DATA_FLOW) || s.getKind().equals((Object)ScenarioKind.UNSET));
        }
        AbstractCapability capa = (AbstractCapability)ctx;
        return !CapellaServices.getService().isOperationalContext(capa) && !CapellaServices.getService().isEPBSContext((ModelElement)capa);
    }

    public static boolean isValidFS(EObject ctx) {
        if (ctx instanceof Scenario) {
            Scenario s = (Scenario)ctx;
            return !CapellaServices.getService().isOperationalContext(s) && !CapellaServices.getService().isEPBSContext((ModelElement)s) && (s.getKind().equals((Object)ScenarioKind.FUNCTIONAL) || s.getKind().equals((Object)ScenarioKind.UNSET));
        }
        AbstractCapability capa = (AbstractCapability)ctx;
        return !CapellaServices.getService().isOperationalContext(capa) && !CapellaServices.getService().isEPBSContext((ModelElement)capa);
    }

    private static boolean isSameInstanceRole(InteractionFragment a, InteractionFragment b) {
        InstanceRole ir2;
        InstanceRole ir1 = (InstanceRole)a.getCoveredInstanceRoles().get(0);
        return ir1 == (ir2 = (InstanceRole)b.getCoveredInstanceRoles().get(0));
    }

    public static InteractionFragment getCorrespondingIFStart(EObject context, EObject obj, EObject correspondingFinish) {
        if (obj instanceof InteractionFragment) {
            InteractionFragment if_ = (InteractionFragment)obj;
            return if_;
        }
        if (obj instanceof TimeLapse) {
            TimeLapse tl = (TimeLapse)obj;
            if (correspondingFinish instanceof TimeLapse) {
                return tl.getStart();
            }
            if (correspondingFinish instanceof SequenceMessage) {
                return tl.getStart();
            }
        } else if (obj instanceof SequenceMessage) {
            SequenceMessage sm = (SequenceMessage)obj;
            if (correspondingFinish instanceof TimeLapse) {
                return SequenceDiagramServices.getMessageEndOnSameInstanceRole(sm, ((TimeLapse)correspondingFinish).getStart());
            }
            if (correspondingFinish instanceof SequenceMessage && sm.getSendingEnd() != null) {
                return sm.getSendingEnd();
            }
            if (correspondingFinish instanceof SequenceMessage && sm.getSendingEnd() == null) {
                return sm.getReceivingEnd();
            }
        }
        return null;
    }

    public static InteractionFragment getCorrespondingIFFinish(EObject context, EObject obj, EObject correspondingStart) {
        if (obj instanceof InteractionFragment) {
            InteractionFragment if_ = (InteractionFragment)obj;
            return if_;
        }
        if (obj instanceof TimeLapse) {
            TimeLapse tl = (TimeLapse)obj;
            if (correspondingStart instanceof TimeLapse) {
                return tl.getFinish();
            }
            if (correspondingStart instanceof SequenceMessage) {
                return tl.getFinish();
            }
        } else if (obj instanceof SequenceMessage) {
            SequenceMessage sm = (SequenceMessage)obj;
            if (correspondingStart instanceof TimeLapse) {
                return SequenceDiagramServices.getMessageEndOnSameInstanceRole(sm, ((TimeLapse)correspondingStart).getStart());
            }
            if (correspondingStart instanceof SequenceMessage && sm.getReceivingEnd() != null) {
                return sm.getReceivingEnd();
            }
            if (correspondingStart instanceof SequenceMessage && sm.getReceivingEnd() == null) {
                return sm.getSendingEnd();
            }
            if (correspondingStart instanceof InteractionFragment) {
                return SequenceDiagramServices.getMessageEndOnSameInstanceRole(sm, (InteractionFragment)correspondingStart);
            }
        }
        return null;
    }

    private static InteractionFragment getMessageEndOnSameInstanceRole(SequenceMessage sm, InteractionFragment startFragment) {
        InstanceRole ir1 = (InstanceRole)startFragment.getCoveredInstanceRoles().get(0);
        if (sm.getSendingEnd() != null && sm.getSendingEnd().getCovered().equals(ir1)) {
            return sm.getSendingEnd();
        }
        if (sm.getReceivingEnd() != null && sm.getReceivingEnd().getCovered().equals(ir1)) {
            return sm.getReceivingEnd();
        }
        return SequenceDiagramServices.getNearestIR(sm, ir1);
    }

    private static InteractionFragment getNearestIR(SequenceMessage sm, InstanceRole ir1) {
        int dist2;
        Scenario s = (Scenario)ir1.eContainer();
        int refPos = s.getOwnedInstanceRoles().indexOf((Object)ir1);
        int posSend = 999;
        int posReceive = 999;
        posReceive = sm.getReceivingEnd() != null ? s.getOwnedInstanceRoles().indexOf((Object)sm.getReceivingEnd().getCovered()) : s.getOwnedInstanceRoles().indexOf((Object)sm.getSendingEnd().getCovered());
        posSend = sm.getSendingEnd() != null ? s.getOwnedInstanceRoles().indexOf((Object)sm.getSendingEnd().getCovered()) : s.getOwnedInstanceRoles().indexOf((Object)sm.getReceivingEnd().getCovered());
        int dist1 = (refPos - posSend) * (refPos - posSend);
        if (dist1 < (dist2 = (refPos - posReceive) * (refPos - posReceive))) {
            return sm.getSendingEnd();
        }
        return sm.getReceivingEnd();
    }

    public List<ExchangeItem> getAvailableExchangeItemForSD(EObject context, List<ExchangeItem> allExchangeItemsFromModel) {
        ArrayList<ExchangeItem> elmentAlReadyInDiagram = new ArrayList<ExchangeItem>();
        if (context != null && context instanceof DDiagram) {
            DDiagram diagram = (DDiagram)context;
            Iterable<DDiagramElement> diagramElements = DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram);
            for (DDiagramElement dDiagramElement : diagramElements) {
                ExchangeItemInstance etInstance;
                AbstractType abstractType;
                InstanceRole role;
                AbstractInstance representedInstance;
                EObject target = dDiagramElement.getTarget();
                if (target == null || !(target instanceof InstanceRole) || (representedInstance = (role = (InstanceRole)target).getRepresentedInstance()) == null || !(representedInstance instanceof ExchangeItemInstance) || (abstractType = (etInstance = (ExchangeItemInstance)representedInstance).getAbstractType()) == null || !(abstractType instanceof ExchangeItem)) continue;
                elmentAlReadyInDiagram.add((ExchangeItem)abstractType);
            }
        }
        if (!allExchangeItemsFromModel.isEmpty() && !elmentAlReadyInDiagram.isEmpty()) {
            allExchangeItemsFromModel.removeAll(elmentAlReadyInDiagram);
        }
        return allExchangeItemsFromModel;
    }
}

