/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.Collection;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.sirius.business.api.color.RGBValuesProvider;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.ComputedColor;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;

public class ShapeUtil {
    public static RGBValues convertRGBtoRGBValues(RGB color) {
        if (color == null) {
            return null;
        }
        RGBValues newValuesContent = RGBValues.create((int)color.red, (int)color.green, (int)color.blue);
        return newValuesContent;
    }

    public static RGBValues getBlackColor() {
        return ShapeUtil.convertRGBtoRGBValues(new RGB(0, 0, 0));
    }

    public static RGB getDefaultColor(View graphicalElement) {
        RGB retColor = null;
        RootEditPart root = ShapeUtil.getEditPart((View)((Diagram)graphicalElement.eContainer())).getParent().getRoot();
        PreferencesHint pref = null;
        pref = root instanceof IDiagramPreferenceSupport ? ((IDiagramPreferenceSupport)root).getPreferencesHint() : PreferencesHint.USE_DEFAULTS;
        Object preferenceStore = pref.getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore) {
            retColor = PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.lineColor");
        }
        return retColor;
    }

    public static GraphicalEditPart getEditPart(View currentNode) {
        Map editPartRegistry;
        GraphicalEditPart targetEditPart;
        GraphicalEditPart ret = null;
        View sourceNode = currentNode;
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (sourceNode != null && editor instanceof DiagramEditor && (targetEditPart = (GraphicalEditPart)(editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(sourceNode)) != null) {
            ret = targetEditPart;
        }
        return ret;
    }

    public static Point getLocation(Node currentNode) {
        return new Point(GMFNotationHelper.getX((Node)currentNode), GMFNotationHelper.getY((Node)currentNode));
    }

    public static Point getLocationDRAW2D(Node currentNode) {
        int iX = -1;
        int iY = -1;
        Point location = null;
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        if (gep != null) {
            iX = gep.getFigure().getBounds().x;
            iY = gep.getFigure().getBounds().y;
            location = new Point(iX, iY);
        }
        return location;
    }

    public static RGBValues getNodeColorStyle(DNode node) {
        NodeStyle shape = node.getOwnedStyle();
        if (shape instanceof Ellipse) {
            return ((Ellipse)shape).getColor();
        }
        if (shape instanceof Square) {
            return ((Square)shape).getColor();
        }
        return null;
    }

    public static int getNodeHeight(Node currentNode) {
        int height = GMFNotationHelper.getHeight((Node)currentNode);
        if (height == -1) {
            height = ShapeUtil.getNodeHeightDRAW2D(currentNode);
        }
        return height;
    }

    public static int getNodeHeightDRAW2D(Node currentNode) {
        int iHeight = -1;
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        if (gep != null) {
            iHeight = gep.getFigure().getBounds().height;
        }
        return iHeight;
    }

    public static int getNodeWidth(Node currentNode) {
        int width = GMFNotationHelper.getWidth((Node)currentNode);
        if (width == -1) {
            width = ShapeUtil.getNodeWidthDRAW2D(currentNode);
        }
        return width;
    }

    public static int getNodeWidthDRAW2D(Node currentNode) {
        int iWidth = -1;
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        if (gep != null) {
            iWidth = gep.getFigure().getBounds().width;
        }
        return iWidth;
    }

    public static boolean isLabelShowIcon(Node currentNode) {
        boolean isShown = true;
        DNodeContainer container = (DNodeContainer)currentNode.getElement();
        if (container != null) {
            isShown = container.getOwnedStyle().isShowIcon();
        }
        return isShown;
    }

    public static boolean isRed(RGBValues color) {
        return color.getRed() == 255 && color.getGreen() == 0 && color.getBlue() == 0;
    }

    public static boolean isSameColor(RGBValues color1, RGB color2) {
        return ShapeUtil.isSameColor(color1, ShapeUtil.convertRGBtoRGBValues(color2));
    }

    public static boolean isSameColor(RGBValues color1, RGBValues color2) {
        if (color1 == null && color2 == null) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        return color1.getGreen() == color2.getGreen() && color1.getBlue() == color2.getBlue() && color1.getRed() == color2.getRed();
    }

    public static void removeColorFromList(RGBValues colorToRemove, Collection<RGB> colorList) {
        RGB toRemove = null;
        for (RGB aColor : colorList) {
            if (!ShapeUtil.isSameColor(colorToRemove, aColor)) continue;
            toRemove = aColor;
            break;
        }
        if (toRemove != null) {
            colorList.remove(toRemove);
        }
    }

    public static View retrieveNode(Diagram diagram, DDiagramElement siriusNode) {
        Node ret = null;
        if (siriusNode instanceof DEdge) {
            for (Object oIte : diagram.getPersistedEdges()) {
                Edge edgeIte;
                if (!(oIte instanceof Edge) || (edgeIte = (Edge)oIte).getElement() != siriusNode) continue;
                ret = edgeIte;
                break;
            }
        } else if (siriusNode instanceof DNodeContainer || siriusNode instanceof DNode) {
            ret = ShapeUtil.retrieveNodeRec((View)diagram, siriusNode);
        }
        return ret;
    }

    private static Node retrieveNodeRec(View anchor, DDiagramElement siriusNode) {
        Node ret = null;
        for (Object oIte : anchor.getPersistedChildren()) {
            if (!(oIte instanceof Node)) continue;
            Node nodeIte = (Node)oIte;
            if (nodeIte.getElement() == siriusNode) {
                ret = nodeIte;
                break;
            }
            Node node = ShapeUtil.retrieveNodeRec((View)nodeIte, siriusNode);
            if (node == null) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public static void setDefaultFont(View currentNode) {
        GraphicalEditPart gep = ShapeUtil.getEditPart(currentNode);
        Object preferredValue = gep.getPreferredValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor());
        RGB color = null;
        if (preferredValue instanceof Integer) {
            color = FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
        }
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor(), (Object)FigureUtilities.RGBToInteger((RGB)color));
        preferredValue = gep.getPreferredValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight());
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight(), (Object)((Integer)preferredValue));
        preferredValue = gep.getPreferredValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold());
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold(), (Object)((Boolean)preferredValue));
    }

    public static void setEdgeColorStyle(DEdge currentEdge, RGB color) {
        if (currentEdge != null && color != null) {
            EdgeStyle edgeStyle = currentEdge.getOwnedStyle();
            RGBValues c = ShapeUtil.convertRGBtoRGBValues(color);
            if (edgeStyle != null && !ShapeUtil.isSameColor(c, edgeStyle.getStrokeColor())) {
                edgeStyle.setStrokeColor(c);
                ShapeUtil.addCustomisation((Style)edgeStyle, new EStructuralFeature[]{DiagramPackage.Literals.EDGE_STYLE__STROKE_COLOR});
                ShapeUtil.getStyleHelper((DSemanticDecorator)currentEdge).refreshStyle((Style)edgeStyle);
            }
        }
    }

    public static void resetEdgeColorStyle(DEdge currentEdge, RGB color) {
        if (currentEdge != null && color != null) {
            EdgeStyle edgeStyle = currentEdge.getOwnedStyle();
            RGBValues c = ShapeUtil.convertRGBtoRGBValues(color);
            if (edgeStyle != null && !ShapeUtil.isSameColor(c, edgeStyle.getStrokeColor())) {
                edgeStyle.setStrokeColor(c);
                ShapeUtil.removeCustomisation((Style)edgeStyle, new EStructuralFeature[]{DiagramPackage.Literals.EDGE_STYLE__STROKE_COLOR});
                ShapeUtil.getStyleHelper((DSemanticDecorator)currentEdge).refreshStyle((Style)edgeStyle);
            }
        }
    }

    public static boolean setEdgeThickStyle(DEdge currentEdge, Integer pThick) {
        EdgeStyle edgeStyle;
        if (currentEdge != null && pThick != null && (edgeStyle = currentEdge.getOwnedStyle()).getSize().intValue() != pThick.intValue()) {
            edgeStyle.setSize(pThick);
            ShapeUtil.addCustomisation((Style)edgeStyle, new EStructuralFeature[]{DiagramPackage.Literals.EDGE_STYLE__SIZE});
            ShapeUtil.getStyleHelper((DSemanticDecorator)currentEdge).refreshStyle((Style)edgeStyle);
            return true;
        }
        return false;
    }

    public static boolean resetEdgeThickStyle(DEdge currentEdge, Integer pThick) {
        EdgeStyle edgeStyle;
        if (currentEdge != null && pThick != null && (edgeStyle = currentEdge.getOwnedStyle()).getSize().intValue() != pThick.intValue()) {
            edgeStyle.setSize(pThick);
            ShapeUtil.removeCustomisation((Style)edgeStyle, new EStructuralFeature[]{DiagramPackage.Literals.EDGE_STYLE__SIZE});
            ShapeUtil.getStyleHelper((DSemanticDecorator)currentEdge).refreshStyle((Style)edgeStyle);
            return true;
        }
        return false;
    }

    public static void setFontColor(View currentNode, RGB color) {
        GraphicalEditPart gep = ShapeUtil.getEditPart(currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor(), (Object)FigureUtilities.RGBToInteger((RGB)color));
        gep.refresh();
    }

    public static void setLocation(Node currentNode, int pX, int pY) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)pX);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)pY);
        gep.refresh();
    }

    public static void setLocation(Node currentNode, Point pPoint) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)pPoint.x);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)pPoint.y);
        gep.refresh();
    }

    public static boolean setBorderColorStyle(AbstractDNode currentNode, RGB color) {
        Style style;
        if (currentNode != null && color != null && (style = ShapeUtil.getCurrentStyle((DDiagramElement)currentNode)) instanceof BorderedStyle) {
            BorderedStyle bStyle = (BorderedStyle)style;
            RGBValues vColor = ShapeUtil.convertRGBtoRGBValues(color);
            if (!ShapeUtil.isSameColor(vColor, bStyle.getBorderColor())) {
                bStyle.setBorderColor(vColor);
                ShapeUtil.addCustomisation(style, new EStructuralFeature[]{DiagramPackage.Literals.BORDERED_STYLE__BORDER_COLOR});
                ShapeUtil.getStyleHelper((DSemanticDecorator)currentNode).refreshStyle(style);
                return true;
            }
        }
        return false;
    }

    public static boolean resetBorderColorStyle(AbstractDNode currentNode, RGB color) {
        Style style;
        if (currentNode != null && color != null && (style = ShapeUtil.getCurrentStyle((DDiagramElement)currentNode)) instanceof BorderedStyle) {
            BorderedStyle bStyle = (BorderedStyle)style;
            RGBValues vColor = ShapeUtil.convertRGBtoRGBValues(color);
            if (!ShapeUtil.isSameColor(vColor, bStyle.getBorderColor())) {
                bStyle.setBorderColor(vColor);
                ShapeUtil.removeCustomisation(style, new EStructuralFeature[]{DiagramPackage.Literals.BORDERED_STYLE__BORDER_COLOR});
                ShapeUtil.getStyleHelper((DSemanticDecorator)currentNode).refreshStyle(style);
                return true;
            }
        }
        return false;
    }

    public static boolean setBorderStyle(AbstractDNode currentNode, Integer pThick) {
        BorderedStyle bStyle;
        Style style;
        if (currentNode != null && pThick != null && (style = ShapeUtil.getCurrentStyle((DDiagramElement)currentNode)) instanceof BorderedStyle && !(bStyle = (BorderedStyle)style).getBorderSize().equals(pThick)) {
            bStyle.setBorderSize(pThick);
            ShapeUtil.addCustomisation((Style)bStyle, new EStructuralFeature[]{DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE});
            ShapeUtil.getStyleHelper((DSemanticDecorator)currentNode).refreshStyle((Style)bStyle);
            return true;
        }
        return false;
    }

    public static boolean resetBorderStyle(AbstractDNode currentNode, Integer pThick) {
        BorderedStyle bStyle;
        Style style;
        if (currentNode != null && pThick != null && (style = ShapeUtil.getCurrentStyle((DDiagramElement)currentNode)) instanceof BorderedStyle && !(bStyle = (BorderedStyle)style).getBorderSize().equals(pThick)) {
            bStyle.setBorderSize(pThick);
            ShapeUtil.removeCustomisation((Style)bStyle, new EStructuralFeature[]{DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE});
            ShapeUtil.getStyleHelper((DSemanticDecorator)currentNode).refreshStyle((Style)bStyle);
            return true;
        }
        return false;
    }

    public static void setColorStyle(DNode currentNode, RGB color) {
        if (currentNode != null && color != null) {
            NodeStyle shape = currentNode.getOwnedStyle();
            if (shape instanceof Ellipse) {
                ShapeUtil.addCustomisation((Style)shape, new EStructuralFeature[]{DiagramPackage.Literals.ELLIPSE__COLOR});
                ((Ellipse)shape).setColor(RGBValues.create((int)color.red, (int)color.green, (int)color.blue));
            } else if (shape instanceof Square) {
                ShapeUtil.addCustomisation((Style)shape, new EStructuralFeature[]{DiagramPackage.Literals.SQUARE__COLOR});
                ((Square)shape).setColor(RGBValues.create((int)color.red, (int)color.green, (int)color.blue));
            }
            ShapeUtil.getStyleHelper((DSemanticDecorator)currentNode).refreshStyle((Style)shape);
        }
    }

    public static Style getCurrentStyle(DDiagramElement element) {
        if (element instanceof DNodeContainer) {
            return ((DNodeContainer)element).getOwnedStyle();
        }
        if (element instanceof DNodeList) {
            return ((DNodeList)element).getOwnedStyle();
        }
        if (element instanceof DNode) {
            return ((DNode)element).getOwnedStyle();
        }
        if (element instanceof DEdge) {
            return ((DEdge)element).getOwnedStyle();
        }
        return null;
    }

    public static void setNodeHeight(Node currentNode, int pHeight) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)pHeight);
        gep.refresh();
    }

    public static void setNodeWidth(Node currentNode, int pWidth) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)pWidth);
        gep.refresh();
    }

    public static void setShapeColor(Node currentNode, RGB color) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)color));
        gep.refresh();
    }

    public static void setXLocation(Node currentNode, int pX) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)pX);
    }

    public static void setYLocation(Node currentNode, int pY) {
        GraphicalEditPart gep = ShapeUtil.getEditPart((View)currentNode);
        ViewUtil.setStructuralFeatureValue((View)((View)gep.getAdapter(View.class)), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)pY);
        gep.refresh();
    }

    public static RGB getDefaultColor(DSemanticDecorator aEdge, EObject desc, ColorDescription descColor) {
        RGBValues color = null;
        if (descColor != null) {
            RGBValuesProvider colors = new RGBValuesProvider();
            if (descColor instanceof FixedColor) {
                color = colors.getRGBValues((FixedColor)descColor);
            } else if (descColor instanceof ComputedColor) {
                color = colors.getRGBValues((ComputedColor)descColor, aEdge.getTarget(), InterpreterUtil.getInterpreter((EObject)aEdge.getTarget()));
            } else if (descColor instanceof InterpolatedColor) {
                color = colors.getRGBValues((InterpolatedColor)descColor, aEdge.getTarget(), InterpreterUtil.getInterpreter((EObject)aEdge.getTarget()));
            }
        }
        if (color == null) {
            return new RGB(0, 0, 0);
        }
        return new RGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void copyCustomStyle(DDiagramElement sourceElement, DDiagramElement targetElement) {
        ContainerStyle sourceStyle = null;
        if (sourceElement instanceof DNodeContainer && targetElement instanceof DNodeContainer) {
            DNodeContainer srcElement = (DNodeContainer)sourceElement;
            DNodeContainer tgtElement = (DNodeContainer)targetElement;
            sourceStyle = srcElement.getOwnedStyle();
            EObject style = EcoreUtil.copy((EObject)sourceStyle);
            tgtElement.setOwnedStyle((ContainerStyle)style);
        } else if (sourceElement instanceof DNode && targetElement instanceof DNode) {
            DNode srcElement = (DNode)sourceElement;
            DNode tgtElement = (DNode)targetElement;
            sourceStyle = srcElement.getOwnedStyle();
            EObject style = EcoreUtil.copy((EObject)sourceStyle);
            tgtElement.setOwnedStyle((NodeStyle)style);
        } else if (sourceElement instanceof DEdge && targetElement instanceof DEdge) {
            DEdge srcElement = (DEdge)sourceElement;
            DEdge tgtElement = (DEdge)targetElement;
            sourceStyle = srcElement.getOwnedStyle();
            EObject style = EcoreUtil.copy((EObject)sourceStyle);
            tgtElement.setOwnedStyle((EdgeStyle)style);
        }
    }

    private static StyleHelper getStyleHelper(DSemanticDecorator semanticDecorator) {
        return new StyleHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }

    public static void removeCustomisation(Style style, EStructuralFeature[] features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            style.getCustomFeatures().remove((Object)feature.getName());
            ++n2;
        }
    }

    public static boolean isCustomisation(Style style, EStructuralFeature feature) {
        for (String name : style.getCustomFeatures()) {
            if (!name.equals(feature.getName())) continue;
            return true;
        }
        return false;
    }

    public static void addCustomisation(Style style, EStructuralFeature[] features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            style.getCustomFeatures().add((Object)feature.getName());
            ++n2;
        }
    }

    public static void setCustom(Style style, boolean value) {
        if (!value) {
            style.getCustomFeatures().clear();
        }
    }

    public static boolean isCustom(Style style) {
        return !style.getCustomFeatures().isEmpty();
    }

    public static RGBValues getColor(Collection<RGBValues> colors) {
        if (colors.size() > 1) {
            return ShapeUtil.getBlackColor();
        }
        return colors.iterator().next();
    }
}

