/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.sirius.analysis.helpers.InvolvementHierarchyContext;

public class FunctionalChainReferenceHierarchyHelper {
    private FunctionalChainReferenceHierarchyHelper() {
    }

    public static List<FunctionalChainReference> computeHierarchy(EdgeTarget edgeTarget, FunctionalChain endFunctionalChain) {
        return new InvolvementHierarchyContext(edgeTarget).getReferences(endFunctionalChain);
    }

    public static List<FunctionalChainReference> computeHierarchy(EdgeTarget edgeTarget) {
        return new InvolvementHierarchyContext(edgeTarget).getReferences();
    }

    public static FunctionalChain computeContainerFunctionalChain(EdgeTarget sourceView, EdgeTarget targetView) {
        InvolvementHierarchyContext sourceHierarchyContext = new InvolvementHierarchyContext(sourceView);
        InvolvementHierarchyContext targetHierarchyContext = new InvolvementHierarchyContext(targetView);
        return sourceHierarchyContext.extractCommonFunctionalChain(targetHierarchyContext);
    }

    public static EObject getDiagramElementForTopHierarchy(List<FunctionalChainReference> referenceHierarchy, DDiagramElement startingDiagramElement) {
        int startIndex;
        ArrayList<FunctionalChainReference> semanticHierarchy = new ArrayList<FunctionalChainReference>(referenceHierarchy);
        EObject diagramElementTarget = startingDiagramElement.getTarget();
        if (startingDiagramElement instanceof DNode && diagramElementTarget instanceof SequenceLinkEnd) {
            semanticHierarchy.add(0, (FunctionalChainReference)diagramElementTarget);
        }
        if ((startIndex = semanticHierarchy.indexOf(diagramElementTarget)) == -1) {
            return null;
        }
        DDiagramElement topContainer = startingDiagramElement;
        int i = startIndex;
        while (i < semanticHierarchy.size() - 1) {
            DDiagramElement upperContainer = (DDiagramElement)topContainer.eContainer().eContainer();
            if (upperContainer == null) {
                return null;
            }
            EObject nextSemanticInHierarchy = (EObject)semanticHierarchy.get(i + 1);
            if (!nextSemanticInHierarchy.equals(upperContainer.getTarget())) {
                return null;
            }
            topContainer = upperContainer;
            ++i;
        }
        return topContainer;
    }
}

