/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.preferences;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;

public class TitleBlockDialog
extends TitleAreaDialog {
    private final String TITLE_NAME = "Add name and content";
    private final String NAME_LABEL = "Name";
    private final String CONTENT_LABEL = "Content";
    private final String INTERPRETOR_ERROR = "The expression is not valid\r\n";
    private final String INFO_MESSAGE = "The content field can be customized via aql, feature or capella queries.\r\n";
    private Text txtName;
    private Text txtContent;
    private String name;
    private String content;
    private String currentName;
    private String currentContent;

    public TitleBlockDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Add name and content");
        this.setMessage("The content field can be customized via aql, feature or capella queries.\r\n", 2);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createName(container);
        this.createContent(container);
        return area;
    }

    private void createName(Composite container) {
        Label lbName = new Label(container, 0);
        lbName.setText("Name");
        GridData dataName = new GridData();
        dataName.grabExcessHorizontalSpace = true;
        dataName.horizontalAlignment = 4;
        this.txtName = new Text(container, 2048);
        this.txtName.setText(this.currentName);
        this.txtName.setLayoutData((Object)dataName);
    }

    private void createContent(Composite container) {
        Label lbContent = new Label(container, 0);
        lbContent.setText("Content");
        GridData dataContent = new GridData();
        dataContent.grabExcessHorizontalSpace = true;
        dataContent.horizontalAlignment = 4;
        this.txtContent = new Text(container, 2048);
        this.txtContent.setText(this.currentContent);
        this.txtContent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TitleBlockDialog.this.txtContent.getText().equals(TitleBlockDialog.this.content) && TitleBlockDialog.this.txtContent.getText().contains("capella:") && TitleBlockDialog.this.evaluate()) {
                    TitleBlockDialog.this.txtName.setText(TitleBlockHelper.getServiceName((String)TitleBlockDialog.this.txtContent.getText()));
                }
            }
        });
        this.txtContent.setLayoutData((Object)dataContent);
        TitleBlockHelper.getServicesProposals((Text)this.txtContent, (EObject)ViewpointFactory.eINSTANCE.createDRepresentationDescriptor());
    }

    protected boolean isResizable() {
        return true;
    }

    private boolean saveInput() {
        boolean evalResult = this.evaluate();
        if (evalResult) {
            this.name = this.txtName.getText();
            this.content = this.txtContent.getText();
        }
        return evalResult;
    }

    private boolean evaluate() {
        Object evaluateResult = TitleBlockHelper.getResultOfExpression((DRepresentationDescriptor)ViewpointFactory.eINSTANCE.createDRepresentationDescriptor(), (String)this.txtContent.getText(), null);
        if (evaluateResult instanceof EvaluationException) {
            this.setErrorMessage("The expression is not valid\r\n");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void okPressed() {
        if (this.saveInput()) {
            super.okPressed();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setCurrentName(String name) {
        this.currentName = name;
    }

    public void setCurrentContent(String content) {
        this.currentContent = content;
    }
}

