/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;

public class ContextualComponentInternalInterfacesRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram diagram) {
        super.beforeRefresh(diagram);
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        EObject root = ((DSemanticDecorator)diagram).getTarget();
        if (!(root instanceof Component)) {
            return;
        }
        DDiagramContents content = new DDiagramContents(diagram);
        ContainerMapping componentMapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, "CCII_Component");
        LinkedList<Component> components = new LinkedList<Component>();
        LinkedList<Interface> interfaces = new LinkedList<Interface>();
        LinkedList<CommunicationLink> links = new LinkedList<CommunicationLink>();
        Component component = (Component)root;
        components.addAll(CsServices.getService().getSubUsedComponents((CapellaElement)component));
        components.addFirst(component);
        for (Component current : components) {
            if (!content.containsView((EObject)current, (DiagramElementMapping)componentMapping)) {
                DNodeContainer created = DiagramServices.getDiagramServices().createContainer(componentMapping, (EObject)current, content.getBestContainer((EObject)current), diagram);
                content.addView((DDiagramElement)created);
            }
            interfaces.addAll(CsServices.getService().getRelatedInterfaces(current));
            links.addAll(CsServices.getService().getRelatedCommunicationLinks(current));
        }
        NodeMapping interfaceMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCII_Interface");
        for (Interface itf : interfaces) {
            if (content.containsView((EObject)itf, (DiagramElementMapping)interfaceMapping)) continue;
            AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode((AbstractNodeMapping)interfaceMapping, (EObject)itf, content.getBestContainer((EObject)itf), diagram);
            content.addView((DDiagramElement)node);
        }
        NodeMapping exchangeItemMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCII_ExchangeItem");
        for (CommunicationLink link : links) {
            ExchangeItem item = link.getExchangeItem();
            if (item == null || content.containsView((EObject)item, (DiagramElementMapping)exchangeItemMapping)) continue;
            AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode((AbstractNodeMapping)exchangeItemMapping, (EObject)item, content.getBestContainer((EObject)item), diagram);
            content.addView((DDiagramElement)node);
        }
        this.reorderElements(content);
    }

    @Override
    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        ArrayList<AbstractNodeMapping> returnedList = new ArrayList<AbstractNodeMapping>();
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "CCII_Component"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCII_Interface"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCII_ExchangeItem"));
        return returnedList;
    }
}

