/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunction;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideFunctionalExchange
extends ShowHideFunction {
    public ShowHideFunctionalExchange(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        ActivityNode port;
        EObject container;
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof FunctionalExchange) {
            FunctionalExchange exchange = (FunctionalExchange)lastContext.getValue();
            value.put("source", (EObject)this.getSource(exchange));
            value.put("target", (EObject)this.getTarget(exchange));
        } else if ("source".equals(lastContext.getKey()) && lastContext.getValue() instanceof ActivityNode) {
            ActivityNode port2 = (ActivityNode)lastContext.getValue();
            EObject container2 = this.getContainer(port2);
            if (container2 != null) {
                value.put("container", container2);
            }
        } else if ("target".equals(lastContext.getKey()) && lastContext.getValue() instanceof ActivityNode && (container = this.getContainer(port = (ActivityNode)lastContext.getValue())) != null) {
            value.put("container", container);
        }
        return value;
    }

    private EObject getContainer(ActivityNode port) {
        DragAndDropTarget node = this.getContent().getBestContainer((EObject)port);
        if (port instanceof OperationalActivity && node instanceof DDiagram) {
            return null;
        }
        if (node instanceof DSemanticDecorator && !(node instanceof DDiagram)) {
            return ((DSemanticDecorator)node).getTarget();
        }
        return port.eContainer();
    }

    private ActivityNode getSource(FunctionalExchange exchange) {
        if (!(exchange.getSource() instanceof OperationalActivity)) {
            return exchange.getSource();
        }
        if (!this.getContent().getDiagramElements((EObject)exchange.getSource()).isEmpty()) {
            return exchange.getSource();
        }
        DragAndDropTarget node = this.getContent().getBestContainer((EObject)exchange.getSource());
        if (node instanceof DSemanticDecorator && !(node instanceof DDiagram)) {
            return (ActivityNode)((DSemanticDecorator)node).getTarget();
        }
        return exchange.getSource();
    }

    private ActivityNode getTarget(FunctionalExchange exchange) {
        if (!(exchange.getTarget() instanceof OperationalActivity)) {
            return exchange.getTarget();
        }
        if (!this.getContent().getDiagramElements((EObject)exchange.getTarget()).isEmpty()) {
            return exchange.getTarget();
        }
        DragAndDropTarget node = this.getContent().getBestContainer((EObject)exchange.getTarget());
        if (node instanceof DSemanticDecorator && !(node instanceof DDiagram)) {
            return (ActivityNode)((DSemanticDecorator)node).getTarget();
        }
        return exchange.getTarget();
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        if (semantic_p instanceof FunctionalExchange) {
            String mappingName = MappingConstantsHelper.getMappingFunctionalExchange(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        } else if (semantic_p instanceof FunctionInputPort) {
            String mappingName = MappingConstantsHelper.getMappingFunctionPort(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        } else if (semantic_p instanceof FunctionOutputPort) {
            String mappingName = MappingConstantsHelper.getMappingFunctionPort(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        } else if (semantic_p instanceof OperationalActivity) {
            String mappingName = MappingConstantsHelper.getMappingFunction(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (semantic_p instanceof AbstractFunction) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof FunctionalExchange) {
            return true;
        }
        if (semantic instanceof FunctionInputPort) {
            return true;
        }
        if (semantic instanceof FunctionOutputPort) {
            return true;
        }
        if (semantic instanceof OperationalActivity) {
            return false;
        }
        return super.mustHide(originCouple_p, context_p);
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        if (view_p.getTarget() instanceof FunctionalExchange) {
            return true;
        }
        return super.mustHide(view_p, context_p);
    }
}

