/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.information.Port;

public class PhysicalLinkExt {
    public static Collection<PhysicalLinkEnd> getRelatedPhysicalLinkEnds(Port element) {
        LinkedHashSet<PhysicalLinkEnd> result = new LinkedHashSet<PhysicalLinkEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CsPackage.Literals.PHYSICAL_LINK_END__PORT);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            result.add((PhysicalLinkEnd)objectRef);
        }
        return result;
    }

    public static Collection<PhysicalLinkEnd> getRelatedPhysicalLinkEnds(Part element) {
        LinkedHashSet<PhysicalLinkEnd> result = new LinkedHashSet<PhysicalLinkEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CsPackage.Literals.PHYSICAL_LINK_END__PART);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            result.add((PhysicalLinkEnd)objectRef);
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(PhysicalPort element) {
        LinkedHashSet<PhysicalLink> result = new LinkedHashSet<PhysicalLink>();
        result.addAll((Collection<PhysicalLink>)element.getInvolvedLinks());
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds((Port)element)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(Component element) {
        LinkedHashSet<PhysicalLink> result = new LinkedHashSet<PhysicalLink>();
        for (PhysicalPort port : element.getContainedPhysicalPorts()) {
            result.addAll((Collection)ModelCache.getCache(PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)port));
        }
        return result;
    }

    public static final List<PhysicalLink> getPhysicalLinks(Part part) {
        ArrayList<PhysicalLink> result = new ArrayList<PhysicalLink>();
        for (AbstractInformationFlow flow : part.getInformationFlows()) {
            if (!(flow instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)flow);
        }
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds(part)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(Part element) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        if (element.getAbstractType() instanceof Component) {
            Component component = (Component)element.getAbstractType();
            result.addAll((Collection)ModelCache.getCache(PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)component));
        }
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds(element)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static EObject getSource(PhysicalLink link) {
        if (!link.getLinkEnds().isEmpty()) {
            return (EObject)link.getLinkEnds().get(0);
        }
        return null;
    }

    public static EObject getTarget(PhysicalLink link) {
        if (link.getLinkEnds().size() > 1) {
            return (EObject)link.getLinkEnds().get(1);
        }
        return null;
    }

    public static Port getSourcePort(PhysicalLink link) {
        EObject source = PhysicalLinkExt.getSource(link);
        if (source instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)source).getPort();
        }
        if (source instanceof Port) {
            return (Port)source;
        }
        return null;
    }

    public static Port getTargetPort(PhysicalLink link) {
        EObject target = PhysicalLinkExt.getTarget(link);
        if (target instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)target).getPort();
        }
        if (target instanceof Port) {
            return (Port)target;
        }
        return null;
    }

    public static Part getSourcePart(PhysicalLink link) {
        Iterator iterator;
        EObject eContainer;
        EObject source = PhysicalLinkExt.getSource(link);
        if (source instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)source).getPart();
        }
        if (source instanceof Port && (eContainer = source.eContainer()) instanceof Component && (iterator = ((Component)eContainer).getRepresentingParts().iterator()).hasNext()) {
            Part part = (Part)iterator.next();
            return part;
        }
        return null;
    }

    public static Collection<Part> getSourceParts(PhysicalLink link) {
        Part part = PhysicalLinkExt.getSourcePart(link);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component sourceComponent = PhysicalLinkExt.getSourceComponent(link);
        if (sourceComponent != null) {
            ArrayList<Part> result = new ArrayList<Part>();
            for (Part aPart : sourceComponent.getRepresentingParts()) {
                result.add(aPart);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Part getTargetPart(PhysicalLink link) {
        Iterator iterator;
        EObject eContainer;
        EObject target = PhysicalLinkExt.getTarget(link);
        if (target instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)target).getPart();
        }
        if (target instanceof Port && (eContainer = target.eContainer()) instanceof Component && (iterator = ((Component)eContainer).getRepresentingParts().iterator()).hasNext()) {
            Part part = (Part)iterator.next();
            return part;
        }
        return null;
    }

    public static Collection<Part> getTargetParts(PhysicalLink link) {
        Part part = PhysicalLinkExt.getTargetPart(link);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component targetComponent = PhysicalLinkExt.getTargetComponent(link);
        if (targetComponent != null) {
            ArrayList<Part> result = new ArrayList<Part>();
            for (Part aPart : targetComponent.getRepresentingParts()) {
                result.add(aPart);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Component getSourceComponent(PhysicalLink link) {
        EObject eContainer;
        Port sourcePort = PhysicalLinkExt.getSourcePort(link);
        if (sourcePort != null && (eContainer = sourcePort.eContainer()) instanceof Component) {
            return (Component)eContainer;
        }
        return null;
    }

    public static Component getTargetComponent(PhysicalLink link) {
        EObject eContainer;
        Port sourcePort = PhysicalLinkExt.getTargetPort(link);
        if (sourcePort != null && (eContainer = sourcePort.eContainer()) instanceof Component) {
            return (Component)eContainer;
        }
        return null;
    }

    public static Part getCommonPart(PhysicalLink link1, PhysicalLink link2) {
        Part sourceLink1Part = PhysicalLinkExt.getSourcePart(link1);
        Part targetLink1Part = PhysicalLinkExt.getTargetPart(link1);
        Part sourceLink2Part = PhysicalLinkExt.getSourcePart(link2);
        Part targetLink2Part = PhysicalLinkExt.getTargetPart(link2);
        if (sourceLink1Part.equals(sourceLink2Part) || sourceLink1Part.equals(targetLink2Part)) {
            return sourceLink1Part;
        }
        if (targetLink1Part.equals(sourceLink2Part) || targetLink1Part.equals(targetLink2Part)) {
            return targetLink1Part;
        }
        return null;
    }

    public static PhysicalPort getRelatedPort(AbstractPhysicalLinkEnd end) {
        if (end instanceof PhysicalPort) {
            return (PhysicalPort)end;
        }
        if (end instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)end).getPort();
        }
        return null;
    }

    public static Set<PhysicalPath> getInvolvingPhysicalPaths(PhysicalLink targetPL) {
        HashSet<PhysicalPath> involvingPhysicalPaths = new HashSet<PhysicalPath>();
        EList involvments = targetPL.getInvolvingInvolvements();
        for (Involvement involvingInvolvement : involvments) {
            PhysicalPathInvolvement inv;
            EObject container;
            if (involvingInvolvement == null || !(involvingInvolvement instanceof PhysicalPathInvolvement) || (container = (inv = (PhysicalPathInvolvement)involvingInvolvement).eContainer()) == null || !(container instanceof PhysicalPath)) continue;
            involvingPhysicalPaths.add((PhysicalPath)container);
        }
        return involvingPhysicalPaths;
    }
}

