/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.epbs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.helpers.cs.delegates.BlockArchitectureHelper;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;

public class EPBSArchitectureHelper {
    private static EPBSArchitectureHelper instance;

    private EPBSArchitectureHelper() {
    }

    public static EPBSArchitectureHelper getInstance() {
        if (instance == null) {
            instance = new EPBSArchitectureHelper();
        }
        return instance;
    }

    public Object doSwitch(EPBSArchitecture element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(EpbsPackage.Literals.EPBS_ARCHITECTURE__ALLOCATED_PHYSICAL_ARCHITECTURE_REALIZATIONS)) {
            ret = this.getAllocatedPhysicalArchitectureRealizations(element);
        } else if (feature.equals(EpbsPackage.Literals.EPBS_ARCHITECTURE__CONTAINED_CAPABILITY_REALIZATION_PKG)) {
            ret = this.getContainedCapabilityRealizationPkg(element);
        } else if (feature.equals(EpbsPackage.Literals.EPBS_ARCHITECTURE__ALLOCATED_PHYSICAL_ARCHITECTURES)) {
            ret = this.getAllocatedPhysicalArchitectures(element);
        }
        if (ret == null) {
            ret = BlockArchitectureHelper.getInstance().doSwitch((BlockArchitecture)element, feature);
        }
        return ret;
    }

    protected List<PhysicalArchitectureRealization> getAllocatedPhysicalArchitectureRealizations(EPBSArchitecture element) {
        ArrayList<PhysicalArchitectureRealization> ret = new ArrayList<PhysicalArchitectureRealization>();
        for (ArchitectureAllocation architectureAllocation : element.getProvisionedArchitectureAllocations()) {
            if (!(architectureAllocation instanceof PhysicalArchitectureRealization)) continue;
            ret.add((PhysicalArchitectureRealization)architectureAllocation);
        }
        return ret;
    }

    protected CapabilityRealizationPkg getContainedCapabilityRealizationPkg(EPBSArchitecture element) {
        AbstractCapabilityPkg abstractCapabilityPkg = element.getOwnedAbstractCapabilityPkg();
        if (abstractCapabilityPkg instanceof CapabilityRealizationPkg) {
            return (CapabilityRealizationPkg)abstractCapabilityPkg;
        }
        return null;
    }

    protected List<PhysicalArchitecture> getAllocatedPhysicalArchitectures(EPBSArchitecture element) {
        ArrayList<PhysicalArchitecture> ret = new ArrayList<PhysicalArchitecture>();
        for (BlockArchitecture architecture : element.getAllocatedArchitectures()) {
            if (!(architecture instanceof PhysicalArchitecture)) continue;
            ret.add((PhysicalArchitecture)architecture);
        }
        return ret;
    }
}

