/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.PortRealization;

public class PortHelper {
    private static PortHelper instance;

    private PortHelper() {
    }

    public static PortHelper getInstance() {
        if (instance == null) {
            instance = new PortHelper();
        }
        return instance;
    }

    public Object doSwitch(Port element, EStructuralFeature feature) {
        List<PortAllocation> ret = null;
        if (feature.equals(InformationPackage.Literals.PORT__INCOMING_PORT_REALIZATIONS)) {
            ret = this.getIncomingPortRealizations(element);
        } else if (feature.equals(InformationPackage.Literals.PORT__OUTGOING_PORT_REALIZATIONS)) {
            ret = this.getOutgoingPortRealizations(element);
        } else if (feature.equals(InformationPackage.Literals.PORT__INCOMING_PORT_ALLOCATIONS)) {
            ret = this.getIncomingPortAllocations(element);
        } else if (feature.equals(InformationPackage.Literals.PORT__OUTGOING_PORT_ALLOCATIONS)) {
            ret = this.getOutgoingPortAllocations(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        return ret;
    }

    protected List<PortAllocation> getIncomingPortAllocations(Port element) {
        EList traces = element.getIncomingTraces();
        ArrayList<PortAllocation> ret = new ArrayList<PortAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof PortAllocation)) continue;
            ret.add((PortAllocation)trace);
        }
        return ret;
    }

    protected List<PortAllocation> getOutgoingPortAllocations(Port element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<PortAllocation> ret = new ArrayList<PortAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof PortAllocation)) continue;
            ret.add((PortAllocation)trace);
        }
        return ret;
    }

    protected List<PortRealization> getIncomingPortRealizations(Port element) {
        EList traces = element.getIncomingTraces();
        ArrayList<PortRealization> ret = new ArrayList<PortRealization>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof PortRealization)) continue;
            ret.add((PortRealization)trace);
        }
        return ret;
    }

    protected List<PortRealization> getOutgoingPortRealizations(Port element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<PortRealization> ret = new ArrayList<PortRealization>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof PortRealization)) continue;
            ret.add((PortRealization)trace);
        }
        return ret;
    }
}

