/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.oa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractInstanceHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;

public class RoleHelper {
    private static RoleHelper instance;

    private RoleHelper() {
    }

    public static RoleHelper getInstance() {
        if (instance == null) {
            instance = new RoleHelper();
        }
        return instance;
    }

    public Object doSwitch(Role element, EStructuralFeature feature) {
        List<Entity> ret = null;
        if (feature.equals(OaPackage.Literals.ROLE__ROLE_ALLOCATIONS)) {
            ret = this.getRoleAllocations(element);
        } else if (feature.equals(OaPackage.Literals.ROLE__ACTIVITY_ALLOCATIONS)) {
            ret = this.getActivityAllocations(element);
        } else if (feature.equals(OaPackage.Literals.ROLE__ALLOCATING_ENTITIES)) {
            ret = this.getAllocatingEntities(element);
        } else if (feature.equals(OaPackage.Literals.ROLE__ALLOCATED_OPERATIONAL_ACTIVITIES)) {
            ret = this.getAllocatedOperationalActivities(element);
        }
        if (ret == null) {
            ret = AbstractInstanceHelper.getInstance().doSwitch((AbstractInstance)element, feature);
        }
        return ret;
    }

    protected List<RoleAllocation> getRoleAllocations(Role element) {
        ArrayList<RoleAllocation> ret = new ArrayList<RoleAllocation>();
        for (AbstractTrace abstractTrace : element.getIncomingTraces()) {
            if (!(abstractTrace instanceof RoleAllocation)) continue;
            ret.add((RoleAllocation)abstractTrace);
        }
        return ret;
    }

    protected List<ActivityAllocation> getActivityAllocations(Role element) {
        ArrayList<ActivityAllocation> ret = new ArrayList<ActivityAllocation>();
        for (AbstractTrace abstractTrace : element.getOutgoingTraces()) {
            if (!(abstractTrace instanceof ActivityAllocation)) continue;
            ret.add((ActivityAllocation)abstractTrace);
        }
        return ret;
    }

    protected List<Entity> getAllocatingEntities(Role element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (RoleAllocation roleAllocation : element.getRoleAllocations()) {
            Entity entity = roleAllocation.getEntity();
            if (entity == null) continue;
            ret.add(entity);
        }
        return ret;
    }

    protected List<OperationalActivity> getAllocatedOperationalActivities(Role element) {
        ArrayList<OperationalActivity> ret = new ArrayList<OperationalActivity>();
        for (ActivityAllocation activityAllocation : element.getActivityAllocations()) {
            OperationalActivity activity = activityAllocation.getActivity();
            if (activity == null) continue;
            ret.add(activity);
        }
        return ret;
    }
}

