/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.capellamodeller.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.validation.AbstractPkgDependenciesCycleValidationRule;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;

public class PkgDependenciesCycleLiveValidationRule
extends AbstractPkgDependenciesCycleValidationRule {
    private Map<DependencyDescriptor, Collection<EObject>> dependencyCache = new HashMap<DependencyDescriptor, Collection<EObject>>();

    @Override
    protected boolean shouldValidate(IValidationContext ctx) {
        EMFEventType eType = ctx.getEventType();
        return eType == EMFEventType.ADD && this.getTarget(ctx) instanceof AbstractDependenciesPkg;
    }

    @Override
    protected IStatus doValidate(IValidationContext ctx) {
        IStatus status = ctx.createSuccessStatus();
        Object newValue = ctx.getFeatureNewValue();
        if (newValue instanceof Association) {
            status = this.doValidateNewAssociation((Association)newValue, ctx);
        }
        this.dependencyCache.clear();
        return status;
    }

    private IStatus doValidateNewAssociation(Association association, IValidationContext ctx) {
        Class sourceClass = AssociationExt.getSourceClass((Association)association);
        Set navigableMembersClassifiers = AssociationExt.getNavigableMembersClassifiers((Association)association);
        if (sourceClass != null && !navigableMembersClassifiers.isEmpty()) {
            List<List<AbstractDependenciesPkg>> relevantCycles;
            ArrayList<AbstractDependenciesPkg> allPkgs = new ArrayList<AbstractDependenciesPkg>();
            AbstractDependenciesPkg srcPkg = (AbstractDependenciesPkg)this.getAncestor((EObject)sourceClass, CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
            allPkgs.add(srcPkg);
            AbstractDependenciesPkg trgtPkg = (AbstractDependenciesPkg)this.getAncestor((EObject)navigableMembersClassifiers.iterator().next(), CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
            allPkgs.add(trgtPkg);
            if (EcoreUtil.equals((EObject)srcPkg, (EObject)trgtPkg) || EcoreUtil.isAncestor((EObject)srcPkg, (EObject)trgtPkg)) {
                return ctx.createSuccessStatus();
            }
            if (EcoreUtil.isAncestor((EObject)trgtPkg, (EObject)srcPkg)) {
                return ctx.createFailureStatus(new Object[]{this.toString(allPkgs)});
            }
            List<List<AbstractDependenciesPkg>> detectedCycles = this.getInterPackageCycles(allPkgs);
            List<List<AbstractDependenciesPkg>> list = relevantCycles = detectedCycles.isEmpty() ? Collections.emptyList() : this.getRelevantCycles(sourceClass, detectedCycles);
            if (!relevantCycles.isEmpty()) {
                return this.createCycleFailureStatus(ctx, relevantCycles);
            }
        }
        return ctx.createSuccessStatus();
    }

    private List<List<AbstractDependenciesPkg>> getRelevantCycles(Class sourceClass, List<List<AbstractDependenciesPkg>> detectedCycles) {
        ArrayList<List<AbstractDependenciesPkg>> relevantCycles = new ArrayList<List<AbstractDependenciesPkg>>();
        for (List<AbstractDependenciesPkg> cycle : detectedCycles) {
            for (Map.Entry<DependencyDescriptor, Collection<EObject>> entry : this.dependencyCache.entrySet()) {
                if (!entry.getKey().isRelatedTo(cycle) || !entry.getValue().contains(sourceClass)) continue;
                relevantCycles.add(cycle);
            }
        }
        return relevantCycles;
    }

    @Override
    protected Collection<AbstractDependenciesPkg> getPkgDependencies(AbstractDependenciesPkg pkgToCheck) {
        if (pkgToCheck instanceof DataPkg) {
            Map dependencies = DataPkgExt.getDataPkgDependenciesHierarchy2((DataPkg)((DataPkg)pkgToCheck));
            this.addDescriptors(pkgToCheck, dependencies);
            return dependencies.keySet();
        }
        if (pkgToCheck instanceof InterfacePkg) {
            Map dependencies = InterfacePkgExt.getInterfacePkgDependenciesHierarchy2((InterfacePkg)((InterfacePkg)pkgToCheck));
            this.addDescriptors(pkgToCheck, dependencies);
            return dependencies.keySet();
        }
        return Collections.emptyList();
    }

    private void addDescriptors(AbstractDependenciesPkg pkgToCheck, Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> dependencies) {
        for (AbstractDependenciesPkg dependentPkg : dependencies.keySet()) {
            DependencyDescriptor descriptor = new DependencyDescriptor(pkgToCheck, dependentPkg);
            Collection<EObject> cachedCollection = this.dependencyCache.get(descriptor);
            if (cachedCollection == null) {
                cachedCollection = new HashSet<EObject>();
                this.addDependencyOrigin(dependencies, dependentPkg, cachedCollection);
                this.dependencyCache.put(descriptor, cachedCollection);
                continue;
            }
            this.addDependencyOrigin(dependencies, dependentPkg, cachedCollection);
        }
    }

    private void addDependencyOrigin(Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> dependencies, AbstractDependenciesPkg pkg, Collection<EObject> collection) {
        Collection<Couple<EObject, Collection<EObject>>> origin = dependencies.get(pkg);
        for (Couple<EObject, Collection<EObject>> couple : origin) {
            collection.add((EObject)couple.getKey());
        }
    }

    private EObject getAncestor(EObject context, EClass eclass) {
        return EcoreUtil2.getFirstContainer((EObject)context, (EClass)eclass);
    }

    class DependencyDescriptor {
        private AbstractDependenciesPkg src;
        private AbstractDependenciesPkg trgt;

        public DependencyDescriptor(AbstractDependenciesPkg src, AbstractDependenciesPkg trgt) {
            this.src = src;
            this.trgt = trgt;
        }

        public boolean isRelatedTo(Collection<AbstractDependenciesPkg> cycle) {
            return cycle.contains(this.src) && cycle.contains(this.trgt);
        }

        private PkgDependenciesCycleLiveValidationRule getOuterType() {
            return PkgDependenciesCycleLiveValidationRule.this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyDescriptor other = (DependencyDescriptor)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.src == null ? other.src != null : !this.src.equals(other.src)) {
                return false;
            }
            return !(this.trgt == null ? other.trgt != null : !this.trgt.equals(other.trgt));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.src == null ? 0 : this.src.hashCode());
            result = 31 * result + (this.trgt == null ? 0 : this.trgt.hashCode());
            return result;
        }
    }
}

