/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.constraint;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class UniqueInvolvementConstraint
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Involvement involvement = (Involvement)ctx.getTarget();
        InvolverElement involvementSource = involvement.getInvolver();
        InvolvedElement involvementTarget = involvement.getInvolved();
        if (involvementSource != null && involvementTarget != null) {
            EList involvementLinks = involvementSource.getInvolvedInvolvements();
            ArrayList<Involvement> equivalentInvolvements = new ArrayList<Involvement>();
            for (Involvement inv : involvementLinks) {
                if (inv instanceof FunctionalChainInvolvement || inv instanceof PhysicalPathInvolvement || !involvementTarget.equals(inv.getInvolved())) continue;
                equivalentInvolvements.add(inv);
            }
            if (equivalentInvolvements.size() > 1) {
                ctx.skipCurrentConstraintForAll(equivalentInvolvements);
                return ConstraintStatus.createStatus((IValidationContext)ctx, equivalentInvolvements, (String)"Multiple equivalent relationships of type ''{0}'' between ''{1}'' and ''{2}''", (Object[])new Object[]{involvement.eClass().getName(), involvementSource, involvementTarget});
            }
        }
        return ctx.createSuccessStatus();
    }
}

