/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.resource.strategy;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.resource.strategy.ResourceStrategy;
import org.eclipse.sirius.business.api.resource.support.LoadEMFResource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.internal.resource.ModelingProjectFileQuery;

public abstract class AbstractResourceStrategyImpl
implements ResourceStrategy {
    @Override
    public boolean canHandle(URI resourceURI, ResourceStrategy.ResourceStrategyType resourceStrategyType) {
        return false;
    }

    @Override
    public boolean canHandle(Resource resource, ResourceStrategy.ResourceStrategyType resourceStrategyType) {
        return false;
    }

    @Override
    public IStatus releaseResourceAtResourceSetDispose(Resource resource, IProgressMonitor monitor) {
        return new Status(4, "org.eclipse.sirius", 1, Messages.AbstractResourceStrategyImpl_methodReleaseNotHandleMsg, null);
    }

    @Override
    public boolean isPotentialSemanticResource(URI uri) {
        if (uri != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            return new ModelingProjectFileQuery(file).isPotentialSemanticResource();
        }
        return false;
    }

    @Override
    public boolean isLoadableModel(URI uri, Session session) {
        IFile file;
        if (uri != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))).exists()) {
            ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(session.getSessionResource().getURI());
            LoadEMFResource runnable = new LoadEMFResource(set, file);
            runnable.run();
            return runnable.getLoadedResource() != null;
        }
        return false;
    }

    protected void clearEAdapters(Resource resource) {
        if (!this.isFromPackageRegistry(resource)) {
            TreeIterator allContents = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                eObject.eAdapters().clear();
            }
        }
    }

    private boolean isFromPackageRegistry(Resource resource) {
        URI uri = resource.getURI();
        return uri != null && resource.getResourceSet().getPackageRegistry().getEPackage(uri.toString()) != null;
    }
}

