/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.rules.fa;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentExchangeRule
extends org.polarsys.capella.core.transition.system.rules.fa.ComponentExchangeRule {
    public EClass getTargetType(EObject element_p, IContext context_p) {
        return FaPackage.Literals.COMPONENT_EXCHANGE;
    }

    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        ComponentExchange sourceElement = (ComponentExchange)source_p;
        Collection transfoSources = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        if (transfoSources.contains(source_p)) {
            ContextScopeHandlerHelper.getInstance((IContext)context_p).add("SOURCE_SCOPE", (EObject)sourceElement.getSource(), context_p);
            ContextScopeHandlerHelper.getInstance((IContext)context_p).add("SOURCE_SCOPE", (EObject)sourceElement.getTarget(), context_p);
            ContextScopeHandlerHelper.getInstance((IContext)context_p).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedComponentExchangeEnds(), context_p);
        }
        result_p.add((EObject)sourceElement.getSource());
        result_p.add((EObject)sourceElement.getTarget());
        result_p.addAll((Collection<EObject>)sourceElement.getOwnedComponentExchangeEnds());
        result_p.addAll((Collection<EObject>)sourceElement.getOwnedComponentExchangeFunctionalExchangeAllocations());
        result_p.addAll((Collection<EObject>)sourceElement.getConvoyedInformations());
    }

    public IStatus transformRequired(EObject element_p, IContext context_p) {
        IStatus result = super.transformRequired(element_p, context_p);
        if (result.isOK()) {
            ComponentExchange element = (ComponentExchange)element_p;
            if (!ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", element_p, context_p)) {
                return new Status(2, Messages.Activity_Transition, "not in scope");
            }
            if (element.getSource() == null) {
                return new Status(2, Messages.Activity_Transition, "source null");
            }
            if (element.getTarget() == null) {
                return new Status(2, Messages.Activity_Transition, "target null");
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)element.getSource(), context_p).isOK()) {
                return new Status(2, Messages.Activity_Transition, "source");
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)element.getTarget(), context_p).isOK()) {
                return new Status(2, Messages.Activity_Transition, "target");
            }
            Collection transfoSources = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
            if (transfoSources.contains(element_p)) {
                return result;
            }
        }
        return result;
    }

    protected void attachExchangeRelated(EObject element_p, EObject result_p, IContext context_p) {
        InformationsExchanger inputNode;
        ComponentExchange transfoSource = (ComponentExchange)element_p;
        ComponentExchange transfoTarget = (ComponentExchange)result_p;
        boolean valid = true;
        InformationsExchanger outputNode = transfoTarget.getSource();
        if (outputNode == null && transfoSource.getSource() instanceof Entity) {
            ComponentPort outputPort = PortExt.createOutFlowPort((String)("out" + transfoSource.getName()));
            transfoTarget.setSource((InformationsExchanger)outputPort);
            Component transformedAction = (Component)TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement((EObject)transfoSource.getSource(), context_p, SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, "SC__T"));
            transformedAction.getOwnedFeatures().add((Object)outputPort);
            valid = false;
        }
        if ((inputNode = transfoTarget.getTarget()) == null && transfoSource.getTarget() instanceof Entity) {
            ComponentPort outputPort = PortExt.createInFlowPort((String)("in" + transfoSource.getName()));
            transfoTarget.setTarget((InformationsExchanger)outputPort);
            Component transformedAction = (Component)TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement((EObject)transfoSource.getTarget(), context_p, SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, "SC__T"));
            transformedAction.getOwnedFeatures().add((Object)outputPort);
            valid = false;
        }
        if (valid) {
            super.attachExchangeRelated(element_p, result_p, context_p);
        }
    }
}

