/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.Messages;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class ReferencesProperty
extends AbstractProperty
implements IEditableProperty {
    LibraryManagerModel model = null;

    public Object getValue(IPropertyContext context_p) {
        if (this.model == null) {
            this.model = (LibraryManagerModel)context_p.getSource();
        }
        return this.model;
    }

    public IStatus validate(Object newValue_p, IPropertyContext context_p) {
        if (!this.model.getUnsavedModels().isEmpty()) {
            String unsavedTxt = this.model.getUnsavedModels().stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(", "));
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)Messages.otherSessionDirtyMsg, (Object)unsavedTxt));
        }
        boolean unsavedModel = this.model.isUnsavedRootModel();
        if (unsavedModel) {
            return new Status(4, "org.polarsys.capella.core.libraries", Messages.dirtySessionMsg);
        }
        if (!this.model.getUnresolvableReferencedLibraries().isEmpty()) {
            String unresolvableLibs = this.model.getUnresolvableReferencedLibraries().stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(", "));
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)Messages.unresolvedLibrariesMsg, (Object)unresolvableLibs));
        }
        if (!this.model.getCycles().isEmpty()) {
            Collection<IModel> cycle = this.model.getCycles().iterator().next();
            String cycleLibTxt = cycle.stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(" "));
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)Messages.cyclesMsg, (Object)this.model.getCycles().size(), (Object)cycleLibTxt));
        }
        ResourceSet rSet = this.model.domain.getResourceSet();
        boolean resourceSetDirty = false;
        for (Resource res : rSet.getResources()) {
            if (!res.isModified() || !CapellaResourceHelper.isCapellaResource((Resource)res)) continue;
            resourceSetDirty = true;
            break;
        }
        if (resourceSetDirty) {
            return new Status(4, "org.polarsys.capella.core.libraries", Messages.resourceSetDirtyMsg);
        }
        ArrayList<IModel> removedLibraries = new ArrayList<IModel>(this.model.getInitialAllReferencedLibrariesByRootModel());
        removedLibraries.removeAll(this.model.getAllReferencedLibrariesByRootModel());
        if (!removedLibraries.isEmpty()) {
            return new Status(2, "org.polarsys.capella.core.libraries", Messages.warningMsg);
        }
        return Status.OK_STATUS;
    }

    public Object getType() {
        return Object.class;
    }

    public Object toType(Object value_p, IPropertyContext context_p) {
        return value_p;
    }

    public void setValue(IPropertyContext context_p) {
        IModel.Edit rootModel = this.model.getRootModel();
        Collection<IModel> newReferencedLibraries = this.model.getReferencedLibrariesByRootModel();
        Collection<IModel> initialReferencedLibraries = this.model.getInitialReferencedLibrariesByRootModel();
        for (IModel library : newReferencedLibraries) {
            if (initialReferencedLibraries.contains(library)) continue;
            rootModel.addReference(library);
        }
        for (IModel library : initialReferencedLibraries) {
            if (newReferencedLibraries.contains(library)) continue;
            rootModel.removeReference(library);
        }
    }
}

