/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.commands.preferences.ui.sirius.DoubleClickBehaviourUtil;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.OpenRelatedDiagramAction;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class OpenAction
extends OpenRepresentationsAction {
    public OpenAction() {
        super(Messages.OpenActionLabel);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (!selection.isEmpty()) {
            for (Object element : selection) {
                if (element instanceof ItemWrapper) {
                    element = ((ItemWrapper)element).getWrappedObject();
                }
                if (CapellaResourceHelper.isSemanticElement(element)) {
                    EObject elementAsEObject = (EObject)element;
                    if (!DoubleClickBehaviourUtil.INSTANCE.shouldOpenRelatedDiagramsOnDoubleClick(elementAsEObject)) {
                        CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)element);
                        continue;
                    }
                    OpenRelatedDiagramAction action = new OpenRelatedDiagramAction(elementAsEObject);
                    action.run();
                    continue;
                }
                if (!this.isRepresentationDescriptor(element)) continue;
                this.openRepresentations(Collections.singletonList((DRepresentationDescriptor)element));
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = true;
        if (!selection.isEmpty()) {
            for (Object selectedElement : selection.toList()) {
                if (CapellaResourceHelper.isSemanticElement(selectedElement) && this.isRepresentationDescriptor(selectedElement)) continue;
                return false;
            }
        }
        return result;
    }

    private boolean isRepresentationDescriptor(Object element) {
        return element instanceof DRepresentationDescriptor;
    }
}

