/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.drop;

import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class BasicDropConstraints {
    protected boolean isCopy(int operation) {
        return operation == 1;
    }

    protected boolean allowInside(int operation) {
        return true;
    }

    protected boolean allowInsideParent(int operation) {
        return true;
    }

    public boolean canDrop(List<EObject> draggedElements, EObject dropTarget, int operation) {
        boolean isCopy = this.isCopy(operation);
        boolean allowInside = this.allowInside(operation);
        boolean allowInsideParent = this.allowInsideParent(operation);
        for (EObject dragged : draggedElements) {
            if (!(dragged != dropTarget || isCopy && allowInside)) {
                return false;
            }
            if (!(dragged.eContainer() != dropTarget || isCopy && allowInsideParent)) {
                return false;
            }
            EObject container = dropTarget.eContainer();
            while (container != null) {
                if (dragged == container) {
                    return false;
                }
                container = container.eContainer();
            }
        }
        return true;
    }
}

