/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.drop;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.AbstractCapellaDropAdapterAssistant;

public class DiagramDropAdapterAssistant
extends AbstractCapellaDropAdapterAssistant {
    public static final String CAPELLA_CORE_SIRIUS = "org.polarsys.capella.core.sirius.analysis";

    @Override
    public IStatus handleDrop(Object target_p, int operation_p, DropTargetEvent dropTargetEvent_p) {
        IStatus status = null;
        if (2 == operation_p && target_p instanceof EObject) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            CompoundCommand dropCommand = new CompoundCommand();
            TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)((EObject)target_p));
            for (Object object : selection.toList()) {
                if (!(object instanceof DRepresentationDescriptor)) continue;
                DRepresentationDescriptor diagram = (DRepresentationDescriptor)object;
                dropCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)diagram, (Object)ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET, (Object)target_p));
                if (!(diagram.getRepresentation() instanceof DSemanticDecorator)) continue;
                dropCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)diagram.getRepresentation(), (Object)ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET, (Object)target_p));
            }
            editingDomain.getCommandStack().execute((Command)dropCommand);
        }
        return status;
    }

    @Override
    public IStatus validateDrop(Object target_p, int operation_p, TransferData transferType_p) {
        EObject targetElement = (EObject)target_p;
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        for (Object object : selection.toList()) {
            if (object instanceof DRepresentationDescriptor) {
                if (this.isDroppable((DRepresentationDescriptor)object, targetElement)) continue;
                return Status.CANCEL_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean isDroppable(DRepresentationDescriptor descriptor, EObject targetElement) {
        RepresentationDescription description = descriptor.getDescription();
        String diagramName = description.getName();
        boolean isValid = true;
        if (EcoreUtil.getURI((EObject)description).toString().contains(CAPELLA_CORE_SIRIUS)) {
            boolean bl = isValid = "Class Diagram Blank".equals(diagramName) || "Interfaces Diagram Blank".equals(diagramName) || "Missions Capabilities Blank".equals(diagramName) || "Missions Blank".equals(diagramName) || diagramName.contains("Data Flow Blank") || "Operational Entity Blank".equals(diagramName) || "Operational Role Blank".equals(diagramName) || "Operational Activity Interaction Blank".equals(diagramName) || "Logical Architecture Blank".equals(diagramName) || "Physical Architecture Blank".equals(diagramName) || "System Architecture Blank".equals(diagramName) || "EPBS Architecture Blank".equals(diagramName);
        }
        if (isValid && description instanceof DiagramDescription) {
            return DialectManager.INSTANCE.canCreate(targetElement, description);
        }
        return false;
    }
}

