/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate.NavigationAdvisor;

public class GotoRelatedElementsHandler
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final IContributionItem[] NO_CONTRIBUTION_ITEM = new IContributionItem[0];
    IServiceLocator locator = null;

    public void initialize(IServiceLocator serviceLocator) {
        this.locator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ISelectionService service = (ISelectionService)this.locator.getService(ISelectionService.class);
        ISelection selection = service.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            Object element = this.getModelElement(firstElement);
            if (element == null) {
                return NO_CONTRIBUTION_ITEM;
            }
            ArrayList<IContributionItem> result = new ArrayList<IContributionItem>(0);
            Object[] elements = ((IStructuredSelection)selection).toArray();
            AbstractCollection items = new HashSet();
            int i = 0;
            while (i < elements.length) {
                Collection<EObject> navigableElements = this.getRelatedElements(elements[i]);
                items.addAll(navigableElements);
                ++i;
            }
            items = new ArrayList(items);
            Collections.sort((ArrayList)items, new Comparator<EObject>(){

                @Override
                public int compare(EObject o1, EObject o2) {
                    try {
                        int value = o1.eClass().getName().compareTo(o2.eClass().getName());
                        if (value == 0) {
                            if (o1 instanceof AbstractNamedElement && o2 instanceof AbstractNamedElement) {
                                value = ((AbstractNamedElement)o1).getName().compareTo(((AbstractNamedElement)o2).getName());
                            }
                            if (value == 0) {
                                value = o1.toString().compareTo(o2.toString());
                            }
                        }
                        return value;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
            for (EObject currentModelElement : items) {
                result.add(this.createNavigationTowards(currentModelElement));
            }
            return result.toArray(new IContributionItem[result.size()]);
        }
        return NO_CONTRIBUTION_ITEM;
    }

    protected IContributionItem createNavigationTowards(EObject object) {
        IAction action = LocateInCapellaExplorerAction.createLocateTowards(object, Messages.GotoRelatedElementsHandler_name, true);
        return new ActionContributionItem(action);
    }

    protected Collection<EObject> getRelatedElements(Object element) {
        return NavigationAdvisor.getInstance().getNavigableElements(element);
    }

    protected Object getModelElement(Object uiSelectedElement) {
        return CapellaAdapterHelper.resolveSemanticObject((Object)uiSelectedElement);
    }
}

