/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.rules.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class AllocationRule
extends AbstractCapellaElementRule {
    @Override
    protected EClass getSourceType() {
        return CapellacorePackage.Literals.ALLOCATION;
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
        if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("SOURCE_SCOPE", element, context)) {
            super.retrieveContainer(element, result, context);
        }
    }

    protected void retrieveRequired(EObject element, List<EObject> result, IContext context) {
        super.retrieveRequired(element, result, context);
        result.add((EObject)((Allocation)element).getSourceElement());
        result.add((EObject)((Allocation)element).getTargetElement());
    }

    @Override
    protected void retrieveGoDeep(EObject eObject1, List<EObject> result, IContext iContext1) {
        super.retrieveGoDeep(eObject1, result, iContext1);
        Allocation element = (Allocation)eObject1;
        if (ContextScopeHandlerHelper.getInstance((IContext)iContext1).contains("SOURCE_SCOPE", (EObject)element, iContext1)) {
            EObject target;
            EObject source = this.getSource(eObject1, iContext1);
            if (source != null) {
                result.add(source);
                ContextScopeHandlerHelper.getInstance((IContext)iContext1).add("SOURCE_SCOPE", source, iContext1);
            }
            if ((target = this.getTarget(eObject1, iContext1)) != null) {
                result.add(target);
                ContextScopeHandlerHelper.getInstance((IContext)iContext1).add("SOURCE_SCOPE", target, iContext1);
            }
        }
    }

    protected EObject getSource(EObject source, IContext context) {
        Allocation element = (Allocation)source;
        return element.getSourceElement();
    }

    protected EObject getTarget(EObject source, IContext context) {
        Allocation element = (Allocation)source;
        return element.getTargetElement();
    }

    public IStatus transformRequired(EObject source, IContext context) {
        IStatus result = super.transformRequired(source, context);
        if (result.isOK()) {
            Allocation element = (Allocation)source;
            EObject sourceElement = this.getSource(source, context);
            EObject targetElement = this.getTarget(source, context);
            result = TransformationHandlerHelper.getInstance((IContext)context).checkTransformRequired((EObject)element, context, sourceElement, targetElement);
        }
        return result;
    }

    protected void premicesAllocationRelated(EObject eObject1, ArrayList<IPremise> needed) {
        Allocation element = (Allocation)eObject1;
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT));
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT));
    }

    @Override
    protected void premicesRelated(EObject element, ArrayList<IPremise> needed) {
        super.premicesRelated(element, needed);
        this.premicesAllocationRelated(element, needed);
    }

    protected void attachAllocationRelated(EObject element, EObject result, IContext context) {
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, context);
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, context);
    }

    @Override
    protected void attachRelated(EObject element, EObject result, IContext context) {
        super.attachRelated(element, result, context);
        this.attachAllocationRelated(element, result, context);
    }
}

