/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.ConstraintChangeEvent;
import org.eclipse.emf.validation.service.ConstraintChangeEventType;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintListener;

public class CapellaConstraintListener
implements IConstraintListener {
    private static CapellaConstraintListener _instance;
    private List<IConstraintDescriptor> _registeredConstraints = new ArrayList<IConstraintDescriptor>(0);
    private List<IConstraintDescriptor> _modifiedConstraints = new ArrayList<IConstraintDescriptor>(0);

    private CapellaConstraintListener() {
    }

    public static CapellaConstraintListener getInstance() {
        if (_instance == null) {
            _instance = new CapellaConstraintListener();
        }
        return _instance;
    }

    public void constraintChanged(ConstraintChangeEvent event_p) {
        IConstraintDescriptor constraint = event_p.getConstraint();
        if (ConstraintChangeEventType.REGISTERED.equals((Object)event_p.getEventType())) {
            this._registeredConstraints.add(constraint);
        } else if (ConstraintChangeEventType.UNREGISTERED.equals((Object)event_p.getEventType())) {
            this._registeredConstraints.remove(constraint);
        }
    }

    public List<IConstraintDescriptor> getEnabledByDefaultRegisteredConstraints() {
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>();
        for (IConstraintDescriptor desc : this._registeredConstraints) {
            if (EMFModelValidationPreferences.isConstraintDisabledByDefault((String)desc.getId())) continue;
            result.add(desc);
        }
        return result;
    }

    public void forceDefaultStateOnRegisteredConstraints() {
        for (IConstraintDescriptor desc : this._registeredConstraints) {
            String id = desc.getId();
            boolean defaultState = EMFModelValidationPreferences.isConstraintDisabledByDefault((String)id);
            boolean currentState = EMFModelValidationPreferences.isConstraintDisabled((String)id);
            if (currentState == defaultState) continue;
            EMFModelValidationPreferences.setConstraintDisabled((String)id, (boolean)defaultState);
            this._modifiedConstraints.add(desc);
        }
    }

    public void restoreStateOnRegisteredConstraints() {
        for (IConstraintDescriptor desc : this._modifiedConstraints) {
            String id;
            boolean currentState = EMFModelValidationPreferences.isConstraintDisabled((String)(id = desc.getId()));
            EMFModelValidationPreferences.setConstraintDisabled((String)id, (!currentState ? 1 : 0) != 0);
        }
        this._modifiedConstraints.clear();
    }
}

