/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;

public class ValidationHelper {
    public static List<IConstraintDescriptor> getAllConstraintDescriptors() {
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>();
        ValidationHelper.ensureEMFValidationActivation();
        ConstraintRegistry registry = ConstraintRegistry.getInstance();
        result.addAll(registry.getAllDescriptors());
        return result;
    }

    public static List<IConstraintDescriptor> getAllCapellaConstraintDescriptors() {
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>();
        ValidationHelper.ensureEMFValidationActivation();
        block0: for (IConstraintDescriptor icd : ValidationHelper.getAllConstraintDescriptors()) {
            Set categories = icd.getCategories();
            for (Category category : categories) {
                String categoryPath = category.getPath();
                if (!categoryPath.startsWith("capella.category")) continue;
                result.add(icd);
                continue block0;
            }
        }
        return result;
    }

    public static void ensureEMFValidationActivation() {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }
}

