/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.ui.quickfix.resolver;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.ui.quickfix.messages.InformationQuickFixMessages;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class CO1218Resolver
extends AbstractCapellaMarkerResolution {
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");

    public void run(IMarker marker) {
        List modelElements = this.getModelElements(marker);
        if (modelElements.isEmpty()) {
            return;
        }
        if (!(modelElements.get(0) instanceof Property)) {
            return;
        }
        final Property property = (Property)this.getModelElements(marker).get(0);
        if (property.getAssociation() == null) {
            DataPkg parentDataPkg;
            AbstractType abstractType;
            final String errorMessage = InformationQuickFixMessages.cO1218_exception_message;
            final EObject propertyContianer = property.eContainer();
            if ((propertyContianer instanceof Collection || propertyContianer instanceof Class) && (abstractType = property.getAbstractType()) != null && (abstractType instanceof Collection || abstractType instanceof Class) && (parentDataPkg = DataPkgExt.getParentDataPkg((CapellaElement)((Classifier)abstractType))) != null) {
                AbstractReadWriteCommand collectElementsCommand = new AbstractReadWriteCommand(){
                    Association association = null;
                    Property prop = null;

                    public void run() {
                        try {
                            this.association = InformationFactory.eINSTANCE.createAssociation();
                            parentDataPkg.getOwnedAssociations().add((Object)this.association);
                            CapellaElementExt.creationService((EObject)this.association, (String)this.association.eClass().getName());
                            this.prop = InformationFactory.eINSTANCE.createProperty();
                            this.association.getOwnedMembers().add((Object)this.prop);
                            CapellaElementExt.creationService((EObject)this.prop, (String)this.prop.eClass().getName());
                            this.prop.setAbstractType((AbstractType)((Classifier)propertyContianer));
                            this.prop.setAggregationKind(AggregationKind.ASSOCIATION);
                            this.association.getNavigableMembers().add((Object)property);
                        }
                        catch (Exception exception) {
                            this.commandRolledBack();
                            CO1218Resolver.this.logger.error((Object)new EmbeddedMessage(errorMessage, "Model Validation"));
                        }
                    }

                    public void commandRolledBack() {
                        super.commandRolledBack();
                        if (this.association != null) {
                            this.association.destroy();
                        }
                        if (this.prop != null) {
                            this.prop.destroy();
                        }
                    }
                };
                TransactionHelper.getExecutionManager((java.util.Collection)modelElements).execute((ICommand)collectElementsCommand);
            }
        }
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            List modelElements = this.getModelElements(marker);
            if (modelElements.isEmpty()) {
                return;
            }
            if (!(modelElements.get(0) instanceof Property)) {
                return;
            }
            final Property property = (Property)modelElements.get(0);
            if (property.getAssociation() == null) {
                DataPkg parentDataPkg;
                AbstractType abstractType;
                final String errorMessage = InformationQuickFixMessages.cO1218_exception_message;
                final EObject propertyContianer = property.eContainer();
                if ((propertyContianer instanceof Collection || propertyContianer instanceof Class) && (abstractType = property.getAbstractType()) != null && (abstractType instanceof Collection || abstractType instanceof Class) && (parentDataPkg = DataPkgExt.getParentDataPkg((CapellaElement)((Classifier)abstractType))) != null) {
                    AbstractReadWriteCommand collectElementsCommand = new AbstractReadWriteCommand(){
                        Association association = null;
                        Property prop = null;

                        public void run() {
                            try {
                                this.association = InformationFactory.eINSTANCE.createAssociation();
                                parentDataPkg.getOwnedAssociations().add((Object)this.association);
                                CapellaElementExt.creationService((EObject)this.association, (String)this.association.eClass().getName());
                                this.prop = InformationFactory.eINSTANCE.createProperty();
                                this.association.getOwnedMembers().add((Object)this.prop);
                                CapellaElementExt.creationService((EObject)this.prop, (String)this.prop.eClass().getName());
                                this.prop.setAbstractType((AbstractType)((Classifier)propertyContianer));
                                this.prop.setAggregationKind(AggregationKind.ASSOCIATION);
                                this.association.getNavigableMembers().add((Object)property);
                            }
                            catch (Exception exception) {
                                this.commandRolledBack();
                                CO1218Resolver.this.logger.error((Object)new EmbeddedMessage(errorMessage, "Model Validation"));
                            }
                        }

                        public void commandRolledBack() {
                            super.commandRolledBack();
                            if (this.association != null) {
                                this.association.destroy();
                            }
                            if (this.prop != null) {
                                this.prop.destroy();
                            }
                        }
                    };
                    TransactionHelper.getExecutionManager((EObject)property).execute((ICommand)collectElementsCommand);
                }
            }
            ++n2;
        }
    }
}

