/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.sirius.analysis.commands.NewScenarioRepresentationCommand;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;

public class NewScenarioRepresentationAction
extends NewRepresentationAction {
    public NewScenarioRepresentationAction(RepresentationDescription description, AbstractCapability selectedEObject, Session session) {
        this(description, selectedEObject, session, false, true);
    }

    public NewScenarioRepresentationAction(RepresentationDescription description, AbstractCapability selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation) {
        super(description, (EObject)selectedEObject, session, forceDefaultName, openRepresentation);
        this.selectedEObject = selectedEObject;
    }

    @Override
    public void run() {
        String defaultName = this.computeDefaultName(this.selectedEObject, this.description);
        if (!this.forceDefaultName) {
            String label = MessageTranslator.INSTANCE.getMessage((EObject)this.description, new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel());
            if (label == null || label.isEmpty()) {
                label = this.description.getName();
            }
            String dialogTitle = "New " + label;
            String dialogMessage = "Name:";
            Shell activeShell = Display.getDefault().getActiveShell();
            InputDialog representationNameDlg = new InputDialog(activeShell, dialogTitle, dialogMessage, defaultName, null);
            if (representationNameDlg.open() == 0) {
                defaultName = representationNameDlg.getValue();
            } else {
                return;
            }
        }
        NewScenarioRepresentationCommand command = new NewScenarioRepresentationCommand(defaultName, (AbstractCapability)this.selectedEObject, this.description, this.session);
        TransactionHelper.getExecutionManager((Session)this.session).execute((ICommand)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

