/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.copyformat.keyproviders;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.ui.copyformat.AbstractCapellaFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaTraceabilityFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.keyproviders.IKeyProvider;

public class TraceabilityKeyProvider
implements IKeyProvider {
    @Override
    public Collection<FormatDataKey> getKeys(FormatDataKey key) {
        ArrayList<FormatDataKey> keys = new ArrayList<FormatDataKey>();
        if (key instanceof AbstractCapellaFormatDataKey) {
            AbstractCapellaFormatDataKey mKey = (AbstractCapellaFormatDataKey)key;
            EObject semantic = mKey.getSemantic();
            if (semantic instanceof EClass || semantic instanceof ColorDescription) {
                keys.add(new CapellaTraceabilityFormatDataKey(mKey, semantic));
            }
            if (semantic instanceof TraceableElement) {
                TraceableElement sourceOfTrace = (TraceableElement)semantic;
                for (AbstractTrace trace : sourceOfTrace.getOutgoingTraces()) {
                    if (!this.isRealizationLink(trace)) continue;
                    keys.add(new CapellaTraceabilityFormatDataKey(mKey, (EObject)trace.getTargetElement()));
                }
            }
            if (semantic instanceof Part) {
                keys.add(new CapellaTraceabilityFormatDataKey(mKey, (EObject)((Part)semantic).getAbstractType()));
                for (AbstractTrace trace : ((TraceableElement)((Part)semantic).getAbstractType()).getOutgoingTraces()) {
                    if (!this.isRealizationLink(trace)) continue;
                    keys.add(new CapellaTraceabilityFormatDataKey(mKey, (EObject)trace.getTargetElement()));
                    for (Part part : (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)((Component)trace.getTargetElement()))) {
                        keys.add(new CapellaTraceabilityFormatDataKey(mKey, (EObject)part));
                    }
                }
            }
        }
        return keys;
    }

    private boolean isRealizationLink(AbstractTrace trace) {
        if (trace.getSourceElement() == null || trace.getTargetElement() == null) {
            return false;
        }
        if (trace instanceof ComponentFunctionalAllocation) {
            return false;
        }
        if (trace.getSourceElement() instanceof Port) {
            return trace instanceof PortRealization;
        }
        if (trace.getSourceElement() instanceof ComponentExchange) {
            return trace instanceof ComponentExchangeRealization;
        }
        if (trace.getSourceElement() instanceof FunctionalExchange) {
            return trace instanceof FunctionalExchangeRealization;
        }
        return true;
    }
}

