/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractDiagramCommandHandler;

public abstract class AbstractSelectInEditorCommandHandler
extends AbstractDiagramCommandHandler {
    List<DRepresentationElement> elementsToSelect = new ArrayList<DRepresentationElement>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection<? extends DRepresentationElement> elements = this.getElementsToSelect();
        this.selectInEditor(elements);
        return this.elementsToSelect;
    }

    private void selectInEditor(Collection<? extends DRepresentationElement> elementsToSelect) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof DialectEditor) {
            DialectUIManager.INSTANCE.selectAndReveal((DialectEditor)activeEditor, new ArrayList<DRepresentationElement>(elementsToSelect));
            this.elementsToSelect.addAll(elementsToSelect);
        }
    }

    protected Collection<? extends DRepresentationElement> getElementsToSelect() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

