/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerView;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaValidateAction;
import org.polarsys.capella.core.validation.service.EPFConstraintFilter;
import org.polarsys.capella.core.validation.service.EPFValidatorAdapter;
import org.polarsys.capella.core.validation.ui.CapellaValidationUIActivator;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public class EPFValidationAction
extends CapellaValidateAction {
    public static Map<String, Boolean> desabledConstraints = new HashMap<String, Boolean>(0);
    protected Resource currentResource;
    public static final String EPF_EXTNAME = "epf";
    public static final String EPF_EXTPATTERN = ".epf";
    public static final String KEY_PREFIX = "/instance/org.eclipse.emf.validation//con.disabled/";
    public static final String DEFAULT_VALIDATION_COMMANDNAME = "Default validation";
    public static final String DEFAULT_ROOT_VALIDATION_COMMANDNAME = "Validate Model";
    public static final List<IConstraintDescriptor> constraints = ValidationHelper.getAllCapellaConstraintDescriptors();
    private IFile epf;
    protected Properties properties;
    private boolean isParent;
    private HashMap<String, Boolean> oldPreferences;

    public EPFValidationAction(boolean isRootAction, IFile epf) {
        this.isParent = isRootAction;
        this.initilizeMarkersResources();
        this.setEpf(epf);
        if (this.getEpf() != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream fileInput = new FileInputStream(new File(this.getEpf().getLocation().toOSString()));){
                    this.properties = new Properties();
                    this.properties.load(fileInput);
                    fileInput.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void run() {
        this.oldPreferences = new HashMap();
        this.disableEPFConstraint();
        EPFConstraintFilter epfFilter = new EPFConstraintFilter(this.properties);
        HashMap oldValidatorRegistry = new HashMap();
        EPFValidatorAdapter epfValidatorAdapter = CapellaValidationUIActivator.getDefault().getEfpValidatorAdapter();
        IBatchValidator validator = epfValidatorAdapter.getValidator();
        try {
            validator.addConstraintFilter((IConstraintFilter)epfFilter);
            oldValidatorRegistry.putAll(EValidator.Registry.INSTANCE);
            epfValidatorAdapter.initializeValidatorRegistry();
            this.doExecute();
            try {
                MarkerView view = (MarkerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                view.getViewer().setInput((Object)workspace.getRoot());
                view.setAutomaticRefresh(true);
                view.getViewer().refresh();
                this.restoreOldPreference();
            }
            catch (PartInitException e) {
                CapellaValidationUIActivator.getDefault().log(4, e.getMessage(), e);
            }
        }
        finally {
            validator.removeConstraintFilter((IConstraintFilter)epfFilter);
            EValidator.Registry.INSTANCE.putAll(oldValidatorRegistry);
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
        }
        catch (PartInitException e) {
            CapellaValidationUIActivator.getDefault().log(4, e.getMessage(), e);
        }
    }

    private void disableEPFConstraint() {
        for (IConstraintDescriptor iConstraintDescriptor : constraints) {
            String value;
            String id = iConstraintDescriptor.getId();
            this.oldPreferences.put(id, new Boolean(EMFModelValidationPreferences.isConstraintDisabled((String)id)));
            boolean constraintDisabledByDefault = EMFModelValidationPreferences.isConstraintDisabledByDefault((String)id);
            EMFModelValidationPreferences.setConstraintDisabled((String)id, (boolean)constraintDisabledByDefault);
            String string = value = this.properties != null ? this.properties.getProperty(KEY_PREFIX + id) : null;
            if (value == null) continue;
            EMFModelValidationPreferences.setConstraintDisabled((String)id, (boolean)Boolean.parseBoolean(value));
        }
        EMFModelValidationPreferences.save();
    }

    private void restoreOldPreference() {
        Iterator<String> iterator = this.oldPreferences.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String key = string = iterator.next();
            EMFModelValidationPreferences.setConstraintDisabled((String)key, (boolean)this.oldPreferences.get(key));
        }
        EMFModelValidationPreferences.save();
    }

    private void doExecute() {
        ExecutionManager executionManager = TransactionHelper.getExecutionManager((Collection)this.selectedObjects);
        if (executionManager == null) {
            return;
        }
        if (this.domain == null) {
            this.domain = executionManager.getEditingDomain();
        }
        executionManager.execute((ICommand)new AbstractReadOnlyCommand(){

            public void run() {
                EPFValidationAction.this.execute();
            }
        });
    }

    public void execute() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    final Diagnostic diagnostic = EPFValidationAction.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                EPFValidationAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                EPFValidationAction.this.handleDiagnostic(diagnostic);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(false, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    public String getText() {
        if (this.getEpf() != null) {
            return this.getEpf().getName().replace(EPF_EXTPATTERN, "");
        }
        if (this.isParent) {
            return DEFAULT_ROOT_VALIDATION_COMMANDNAME;
        }
        return DEFAULT_VALIDATION_COMMANDNAME;
    }

    public void initilizeMarkersResources() {
        this.eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil(){

            protected String getMarkerID() {
                return "org.polarsys.capella.core.validation.markers";
            }

            public void createMarkers(Resource resource, Diagnostic diagnostic) {
                final String epf = EPFValidationAction.this.getEpf() == null ? "Default" : EPFValidationAction.this.getEpf().getName();
                LightMarkerRegistry.getInstance().createMarker((IResource)this.getFile(EPFValidationAction.this.currentResource), diagnostic, this.getMarkerID(), new LightMarkerRegistry.IMarkerModification(){

                    public void modify(IMarker marker) {
                        try {
                            marker.setAttribute("preferenceFile", (Object)epf);
                        }
                        catch (CoreException e) {
                            CapellaValidationUIActivator.getDefault().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), CapellaValidationUIActivator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
                        }
                    }
                });
            }

            public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
                boolean cleanup = AbstractPreferencesInitializer.getBoolean((String)"cleanPreviousValidationResults", (boolean)true);
                if (cleanup) {
                    ArrayList markers = new ArrayList(LightMarkerRegistry.getInstance().getMarkers());
                    for (IMarker marker : markers) {
                        try {
                            if (!marker.getType().equals("org.polarsys.capella.core.validation.markers")) continue;
                            marker.delete();
                        }
                        catch (CoreException e) {
                            CapellaValidationUIActivator.getDefault().log(4, e.getMessage(), e);
                        }
                    }
                }
            }
        };
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        try {
            List data = diagnostic.getData();
            if (data != null && data.size() > 0) {
                for (Object object : data) {
                    if (!(object instanceof EObject)) continue;
                    this.currentResource = ((EObject)object).eResource();
                    break;
                }
            }
            super.handleDiagnostic(diagnostic);
        }
        finally {
            this.currentResource = null;
        }
    }

    public IFile getEpf() {
        return this.epf;
    }

    public void setEpf(IFile epf) {
        this.epf = epf;
    }
}

