/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;

public class DefaultJavaIndexer {
    private static final char JAR_SEPARATOR = "|".charAt(0);

    public void generateIndexForJar(String pathToJar, String pathToIndexFile) throws IOException {
        File f = new File(pathToJar);
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(pathToJar) + " not found");
        }
        FileIndexLocation indexLocation = new FileIndexLocation(new File(pathToIndexFile));
        Index index = new Index(indexLocation, pathToJar, false);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        index.separator = JAR_SEPARATOR;
        Throwable throwable = null;
        Object var8_9 = null;
        try (ZipFile zip = new ZipFile(pathToJar);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String zipEntryName = ze.getName();
                if (!Util.isClassFileName((String)zipEntryName)) continue;
                byte[] classFileBytes = Util.getZipEntryByteContent((ZipEntry)ze, (ZipFile)zip);
                JavaSearchDocument entryDocument = new JavaSearchDocument(ze, (IPath)new Path(pathToJar), classFileBytes, participant);
                entryDocument.setIndex(index);
                new BinaryIndexer(entryDocument).indexDocument();
            }
            index.save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

