/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public abstract class AbstractDeleteCommandResolver
extends AbstractCapellaMarkerResolution {
    public abstract Object getElementToDelete(Object var1);

    public void run(IMarker marker) {
        List<EObject> modelElements = this.getModelElements(marker);
        if (modelElements.isEmpty()) {
            return;
        }
        final EObject modelElement = modelElements.get(0);
        Object elementToDelete = this.getElementToDelete(modelElement);
        final Collection[] listOfElementsToDelete = new Collection[1];
        if (elementToDelete == null) {
            return;
        }
        if (elementToDelete instanceof Collection) {
            if (((Collection)elementToDelete).isEmpty()) {
                return;
            }
            listOfElementsToDelete[0] = (Collection)elementToDelete;
        } else {
            listOfElementsToDelete[0] = Collections.singletonList(elementToDelete);
        }
        final boolean[] mustDeleteMarker = new boolean[1];
        AbstractReadWriteCommand abstrctCommand = new AbstractReadWriteCommand(){

            public void run() {
                CapellaDeleteCommand command;
                boolean confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)TransactionHelper.getExecutionManager((EObject)modelElement), (Collection)listOfElementsToDelete[0]);
                if (confirmDeletion && (command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)modelElement), listOfElementsToDelete[0], false, false, true)).canExecute()) {
                    command.execute();
                    mustDeleteMarker[0] = true;
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)modelElement).execute((ICommand)abstrctCommand);
        if (mustDeleteMarker[0]) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        final HashSet<EObject> toDelete = new HashSet<EObject>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            List<EObject> modelElements = this.getModelElements(marker);
            if (modelElements.isEmpty()) {
                return;
            }
            Object elementToDelete = this.getElementToDelete(modelElements.get(0));
            if (elementToDelete instanceof Collection) {
                toDelete.addAll((Collection)elementToDelete);
            } else if (elementToDelete != null) {
                toDelete.add((EObject)elementToDelete);
            }
            ++n2;
        }
        final AtomicReference<Boolean> mustDeleteMarker = new AtomicReference<Boolean>(Boolean.FALSE);
        if (toDelete.isEmpty()) {
            mustDeleteMarker.set(Boolean.TRUE);
        } else {
            final ExecutionManager em = TransactionHelper.getExecutionManager(toDelete);
            AbstractReadWriteCommand abstrctCommand = new AbstractReadWriteCommand(){

                public void run() {
                    CapellaDeleteCommand command;
                    boolean confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)em, (Collection)toDelete);
                    if (confirmDeletion && (command = new CapellaDeleteCommand(em, (Collection)toDelete, false, false, true)).canExecute()) {
                        command.execute();
                        mustDeleteMarker.set(Boolean.TRUE);
                    }
                }
            };
            if (em != null) {
                em.execute((ICommand)abstrctCommand);
            } else {
                mustDeleteMarker.set(Boolean.TRUE);
            }
        }
        if (mustDeleteMarker.get().booleanValue()) {
            IMarker[] iMarkerArray2 = markers;
            int n3 = markers.length;
            n = 0;
            while (n < n3) {
                IMarker marker = iMarkerArray2[n];
                if (marker.exists()) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException exception) {
                        StatusManager.getManager().handle((IStatus)new Status(4, PluginActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
                    }
                }
                ++n;
            }
        }
    }
}

