/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;

public class OpenAndShowInDiagramResolver
implements IMarkerResolution2 {
    private static final String QUICK_FIX_LABEL_PATTERN = "Open and show in \"{0}\" ({1})";
    private final Image image;
    private final String label;
    private final EObject modelElementToSelectInDiagram;
    private final Session session;
    private final DRepresentation targetingRepresentation;

    public OpenAndShowInDiagramResolver(EObject modelElementDiagramTarget, EObject modelElementToSelectInDiagram) {
        this.session = SessionManager.INSTANCE.getSession(modelElementDiagramTarget);
        DRepresentation target = null;
        if (this.session != null) {
            Collection representations = DialectManager.INSTANCE.getRepresentations(modelElementDiagramTarget, this.session);
            if (!representations.isEmpty()) {
                target = (DRepresentation)representations.iterator().next();
            }
        } else {
            target = null;
        }
        this.targetingRepresentation = target;
        String representationName = EObjectLabelProviderHelper.getText((Object)this.targetingRepresentation);
        String representationClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)this.targetingRepresentation, (boolean)false);
        this.label = MessageFormat.format(QUICK_FIX_LABEL_PATTERN, representationName, representationClassName);
        this.image = ExtendedImageRegistry.getInstance().getImage(EObjectLabelProviderHelper.getImage((EObject)this.targetingRepresentation));
        this.modelElementToSelectInDiagram = modelElementToSelectInDiagram;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (this.session == null || this.targetingRepresentation == null) {
            return;
        }
        DialectUIManager.INSTANCE.openEditor(this.session, this.targetingRepresentation, (IProgressMonitor)new NullProgressMonitor());
        if (this.modelElementToSelectInDiagram == null) {
            return;
        }
        ShowInDiagramAction showInDiagramAction = new ShowInDiagramAction();
        showInDiagramAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.modelElementToSelectInDiagram));
        showInDiagramAction.run();
    }

    public String getDescription() {
        return null;
    }
}

