/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class ReportManagerFilter
extends Filter {
    String appenderName = null;

    public ReportManagerFilter(String appenderName) {
        this.appenderName = appenderName;
    }

    public ReportManagerFilter(Appender appender) {
        this(appender.getName());
    }

    public int decide(LoggingEvent event) {
        String level = event.getLevel().toString();
        String componentName = event.getLoggerName();
        ReportManagerRegistry registry = ReportManagerRegistry.getInstance();
        ConfigurationInstance config = registry.getComponentConfiguration(componentName);
        List<OutputConfiguration> configsList = config.getOutputConfiguration();
        for (OutputConfiguration outputConfiguration : configsList) {
            if (!this.appenderName.equals(outputConfiguration.getOutputName())) continue;
            List<LogLevel> logslevels = outputConfiguration.getLogLevel();
            for (LogLevel logLevel : logslevels) {
                if (!logLevel.isValue() || !level.equals(logLevel.getName())) continue;
                return 1;
            }
        }
        return -1;
    }
}

