/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class BooleanTextRenderer
extends AbstractRenderer {
    Label dataExport;

    @Override
    public void performRender(Composite parent, IRendererContext context) {
        IProperty property = context.getProperty(this);
        this.dataExport = new Label(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            this.dataExport.setLayoutData((Object)new GridData(768));
        }
        this.dataExport.setText(property.getName());
        this.dataExport.setToolTipText(property.getDescription());
        this.dataExport.setData((Object)property);
    }

    @Override
    public void initialize(IProperty property, IRendererContext rendererContext) {
        Object value = rendererContext.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, rendererContext, value);
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext rendererContext, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        IProperty prop = rendererContext.getProperty(this);
        IPropertyContext propertyContext = rendererContext.getPropertyContext();
        if (property.equals(prop)) {
            this.dataExport.setEnabled(prop.isEnabled(propertyContext));
            IStatus diag = property.validate(property.toType(newValue, propertyContext), propertyContext);
            this.dataExport.setText(String.valueOf(prop.getName()) + " : " + rendererContext.getLabelProvider().getText((Object)diag.getMessage()));
            if (1 == diag.getSeverity()) {
                this.dataExport.setForeground(this.dataExport.getShell().getDisplay().getSystemColor(10));
            } else if (diag.getSeverity() == 0) {
                this.dataExport.setForeground(this.dataExport.getShell().getDisplay().getSystemColor(6));
            } else if (2 == diag.getSeverity()) {
                this.dataExport.setForeground(this.dataExport.getShell().getDisplay().getSystemColor(8));
            } else if (4 == diag.getSeverity()) {
                this.dataExport.setForeground(this.dataExport.getShell().getDisplay().getSystemColor(4));
            }
        }
    }

    @Override
    public void dispose(IRendererContext context) {
        this.dataExport.dispose();
    }
}

