/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.properties.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;

public class Properties
implements IProperties {
    String idProperties;
    List<IPropertyGroup> groups;
    List<IProperty> items;
    Collection<IProperties> parents;
    LinkedList<IProperty> allProperties = null;
    LinkedList<IPropertyGroup> allGroups = null;

    public Properties(String idProperties) {
        this.idProperties = idProperties;
        this.groups = new ArrayList<IPropertyGroup>();
        this.items = new ArrayList<IProperty>();
        this.parents = new ArrayList<IProperties>();
    }

    public void addParent(IProperties parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
            this.allGroups = null;
            this.allProperties = null;
        }
    }

    public void removeParent(IProperties parent) {
        this.parents.remove(parent);
        this.allGroups = null;
        this.allProperties = null;
    }

    @Override
    public Collection<IProperties> getParents() {
        return this.parents;
    }

    @Override
    public String getPropertiesId() {
        return this.idProperties;
    }

    public void addGroup(IPropertyGroup group) {
        for (IPropertyGroup iGroup : this.getGroups()) {
            if (!iGroup.getId().equals(group.getId())) continue;
            return;
        }
        this.allGroups = null;
        this.groups.add(group);
    }

    @Override
    public List<IPropertyGroup> getGroups(IPropertyGroup group) {
        ArrayList<IPropertyGroup> ite = new ArrayList<IPropertyGroup>();
        for (IPropertyGroup item : this.getAllGroups()) {
            if (item == IPropertyGroup.EMPTY) continue;
            if (group == IPropertyGroup.EMPTY) {
                if (item.getParentId() != null) continue;
                ite.add(item);
                continue;
            }
            if (item.getParentId() == null || !item.getParentId().equals(group.getId())) continue;
            ite.add(item);
        }
        return ite;
    }

    @Override
    public List<IPropertyGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Collection<IPropertyGroup> getAllGroups() {
        if (this.allGroups != null) {
            return this.allGroups;
        }
        LinkedList<IProperties> toVisit = new LinkedList<IProperties>();
        HashSet<IProperties> visited = new HashSet<IProperties>();
        LinkedList<IPropertyGroup> result = new LinkedList<IPropertyGroup>();
        toVisit.add(this);
        while (toVisit.size() > 0) {
            IProperties parent = (IProperties)toVisit.removeFirst();
            if (!visited.contains(parent)) {
                visited.add(parent);
                LinkedList<IPropertyGroup> temporary = new LinkedList<IPropertyGroup>();
                for (IPropertyGroup group : parent.getGroups()) {
                    temporary.add(group);
                }
                while (temporary.size() > 0) {
                    IPropertyGroup last = (IPropertyGroup)temporary.removeLast();
                    if (result.contains(last)) continue;
                    result.addFirst(last);
                }
            }
            toVisit.addAll(parent.getParents());
        }
        this.allGroups = result;
        return result;
    }

    @Override
    public List<IProperty> getItems(IPropertyGroup group) {
        ArrayList<IProperty> ite = new ArrayList<IProperty>();
        for (IProperty item : this.getAllItems()) {
            AbstractProperty property = (AbstractProperty)item;
            if (group == IPropertyGroup.EMPTY) {
                if (property.getGroupId() != null) continue;
                ite.add(item);
                continue;
            }
            if (property.getGroupId() == null || !property.getGroupId().equals(group.getId())) continue;
            ite.add(item);
        }
        return ite;
    }

    @Override
    public Collection<IProperty> getItems() {
        return this.items;
    }

    @Override
    public Collection<IProperty> getAllItems() {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        LinkedList<IProperties> toVisit = new LinkedList<IProperties>();
        HashSet<IProperties> visited = new HashSet<IProperties>();
        LinkedList<IProperty> result = new LinkedList<IProperty>();
        HashSet<String> addedIds = new HashSet<String>();
        toVisit.add(this);
        while (toVisit.size() > 0) {
            IProperties properties = (IProperties)toVisit.removeFirst();
            if (visited.contains(properties)) continue;
            visited.add(properties);
            LinkedList<IProperty> temporary = new LinkedList<IProperty>();
            for (IProperty property : properties.getItems()) {
                if (temporary.contains(property)) continue;
                temporary.add(property);
            }
            while (temporary.size() > 0) {
                IProperty last = (IProperty)temporary.removeLast();
                if (result.contains(last) || addedIds.contains(last.getId())) continue;
                result.addFirst(last);
                addedIds.add(last.getId());
            }
            toVisit.addAll(properties.getParents());
        }
        this.allProperties = result;
        return result;
    }

    @Override
    public IProperty getProperty(String id) {
        for (IProperty item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        for (IProperties parent : this.getParents()) {
            IProperty item = parent.getProperty(id);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public void addItem(IProperty item) {
        this.items.add(item);
        this.allProperties = null;
    }
}

