/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.interaction.services.SequenceMessageExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.Role;

public class ScenarioExt {
    public static List<ExchangeItem> getExchangeItems(AbstractEventOperation operation) {
        ArrayList<ExchangeItem> result = new ArrayList<ExchangeItem>();
        if (operation instanceof ExchangeItem) {
            result.add((ExchangeItem)operation);
        } else if (operation instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation allocation = (ExchangeItemAllocation)operation;
            if (allocation.getAllocatedItem() instanceof ExchangeItem) {
                result.add(allocation.getAllocatedItem());
            }
        } else if (operation instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)operation;
            result.addAll((Collection<ExchangeItem>)fe.getExchangedItems());
        } else if (operation instanceof ComponentExchange) {
            ComponentExchange exchange = (ComponentExchange)operation;
            for (AbstractExchangeItem item : exchange.getConvoyedInformations()) {
                if (!(item instanceof ExchangeItem)) continue;
                result.add((ExchangeItem)item);
            }
        }
        return result;
    }

    public static AbstractEventOperation getOperation(EObject element) {
        AbstractEventOperation operation = null;
        if (element instanceof SequenceMessage) {
            operation = ((SequenceMessage)element).getInvokedOperation();
        }
        if (element instanceof EventSentOperation) {
            operation = ((EventSentOperation)element).getOperation();
        }
        if (element instanceof EventReceiptOperation) {
            operation = ((EventReceiptOperation)element).getOperation();
        }
        if (element instanceof AbstractEnd) {
            return ScenarioExt.getOperation((EObject)((AbstractEnd)element).getEvent());
        }
        return operation;
    }

    public static InstanceRole getOppositeCoveredIR(AbstractEnd end) {
        MessageEnd messageEnd = null;
        if (end instanceof ExecutionEnd) {
            messageEnd = (MessageEnd)((ExecutionEnd)end).getExecution().getStart();
        } else if (end instanceof MessageEnd) {
            messageEnd = (MessageEnd)end;
        }
        if (messageEnd != null) {
            MessageEnd opposite;
            MessageEnd messageEnd2 = opposite = messageEnd.getMessage().getSendingEnd() == messageEnd ? messageEnd.getMessage().getReceivingEnd() : messageEnd.getMessage().getSendingEnd();
            if (opposite != null) {
                return opposite.getCovered();
            }
        }
        return null;
    }

    public static InstanceRole getOppositeCoveredIR(ExecutionEnd executionEnd_p) {
        MessageEnd me = (MessageEnd)executionEnd_p.getExecution().getStart();
        return ScenarioExt.getOppositeCoveredIR((AbstractEnd)me);
    }

    public static InstanceRole getOppositeCoveredIR(Execution exec) {
        return ScenarioExt.getOppositeCoveredIR((AbstractEnd)((MessageEnd)exec.getStart()));
    }

    public static List<ExchangeItem> getExchangeItems(Event e) {
        if (e instanceof EventSentOperation || e instanceof EventReceiptOperation) {
            SequenceMessage sm = ScenarioExt.getSequenceMessage(e);
            return sm.getExchangedItems();
        }
        return ScenarioExt.getExchangeItems(ScenarioExt.getOperation((EObject)e));
    }

    public static SequenceMessage getSequenceMessage(Event e) {
        HashSet msgs = new HashSet();
        for (EObject obj : EObjectExt.getReferencers((EObject)e, (EReference)InteractionPackage.Literals.ABSTRACT_END__EVENT)) {
            msgs.addAll(EObjectExt.getReferencers((EObject)obj, (EReference)InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_END));
            msgs.addAll(EObjectExt.getReferencers((EObject)obj, (EReference)InteractionPackage.Literals.SEQUENCE_MESSAGE__SENDING_END));
        }
        if (!msgs.isEmpty()) {
            return (SequenceMessage)msgs.iterator().next();
        }
        return null;
    }

    public static boolean isSource(AbstractEnd end_p) {
        ExecutionEnd eend;
        AbstractEnd end = end_p;
        if (end instanceof ExecutionEnd && (eend = (ExecutionEnd)end).getExecution() != null) {
            end = (AbstractEnd)eend.getExecution().getStart();
        }
        Event event = end.getEvent();
        boolean isSource = event instanceof EventSentOperation;
        if (end instanceof MessageEnd && ((MessageEnd)end).getMessage() != null && ((MessageEnd)end).getMessage().getKind() == MessageKind.REPLY) {
            isSource = event instanceof EventReceiptOperation;
        }
        return isSource;
    }

    public static boolean isExchangeItemInstanceRole(AbstractEnd end) {
        return end.getCoveredInstanceRoles().size() > 0 && ((InstanceRole)end.getCoveredInstanceRoles().get(0)).getRepresentedInstance() instanceof ExchangeItemInstance;
    }

    public static boolean isRoleInstanceRole(AbstractEnd end) {
        return end.getCoveredInstanceRoles().size() > 0 && ((InstanceRole)end.getCoveredInstanceRoles().get(0)).getRepresentedInstance() instanceof Role;
    }

    public static boolean isPartInstanceRole(AbstractEnd end) {
        return end.getCoveredInstanceRoles().size() > 0 && ((InstanceRole)end.getCoveredInstanceRoles().get(0)).getRepresentedInstance() instanceof Part;
    }

    public static boolean isFunctionalInstanceRole(AbstractEnd end) {
        return end.getCoveredInstanceRoles().size() > 0 && ((InstanceRole)end.getCoveredInstanceRoles().get(0)).getRepresentedInstance() instanceof AbstractFunction;
    }

    public static ExchangeItemInstance getExchangeItemInstanceRole(AbstractEnd end) {
        return (ExchangeItemInstance)((InstanceRole)end.getCoveredInstanceRoles().get(0)).getRepresentedInstance();
    }

    public static SequenceMessage getRelatedSequenceMessage(Event event_p) {
        for (EObject referencer : EObjectExt.getReferencers((EObject)event_p, (EReference)InteractionPackage.Literals.ABSTRACT_END__EVENT)) {
            if (!(referencer instanceof AbstractEnd)) continue;
            AbstractEnd end = (AbstractEnd)referencer;
            return ScenarioExt.getRelatedSequenceMessage(end);
        }
        return null;
    }

    public static SequenceMessage getRelatedSequenceMessage(AbstractEnd end_p) {
        ExecutionEnd eend;
        AbstractEnd end = end_p;
        if (end instanceof ExecutionEnd && (eend = (ExecutionEnd)end).getExecution() != null) {
            end = (AbstractEnd)eend.getExecution().getStart();
        }
        if (end instanceof MessageEnd) {
            MessageEnd mend = (MessageEnd)end;
            SequenceMessage message = mend.getMessage();
            if (message.getKind() == MessageKind.REPLY) {
                message = SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)message);
            }
            return message;
        }
        return null;
    }
}

