/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.topdown;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.scenario.ScenarioTransfo;
import org.polarsys.capella.core.projection.scenario.ScenarioTransform;
import org.polarsys.capella.core.projection.scenario.helpers.IScenarioHelper;
import org.polarsys.capella.core.projection.scenario.topdown.TopDownHelper;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;

public class TopDownTransform
extends ScenarioTransform {
    private static final String CAPELLA_SCENARIO_RULES = "org.polarsys.capella.core.projection.scenario.topdown";

    @Override
    protected String getRules() {
        return CAPELLA_SCENARIO_RULES;
    }

    @Override
    protected ScenarioTransfo createTransfo(ITransfoRuleBase ruleBase_p) throws ClassNotFoundException {
        ScenarioTransfo transfo = super.createTransfo(ruleBase_p);
        transfo.setSpecificLinkKindFromMap(InteractionPackage.Literals.ABSTRACT_CAPABILITY, InteractionPackage.Literals.ABSTRACT_CAPABILITY, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION);
        transfo.setSpecificLinkKindFromMap(FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION);
        transfo.setSpecificLinkKindFromMap(CapellacommonPackage.Literals.ABSTRACT_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION);
        transfo.setSpecificLinkKindFromMap(CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT_REALIZATION);
        transfo.setSpecificLinkKindFromMap(FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_REALIZATION);
        transfo.setSpecificLinkKindFromMap(InformationPackage.Literals.EXCHANGE_ITEM, InformationPackage.Literals.EXCHANGE_ITEM, InformationPackage.Literals.INFORMATION_REALIZATION);
        transfo.setSpecificLinkKindFromMap(FaPackage.Literals.FUNCTIONAL_CHAIN, FaPackage.Literals.FUNCTIONAL_CHAIN, FaPackage.Literals.FUNCTIONAL_CHAIN_REALIZATION);
        transfo.setSpecificLinkKindFromMap(FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE_REALIZATION);
        return transfo;
    }

    @Override
    protected IScenarioHelper createScenarioHandler(IContext context_p) {
        return new TopDownHelper();
    }

    protected boolean retainContextElement(EObject contextElement, ITransfo transfo) {
        if (contextElement instanceof Scenario) {
            BlockArchitecture targetBlock = null;
            BlockArchitecture sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement);
            for (AbstractTrace trace : sourceBlock.getIncomingTraces()) {
                TraceableElement targetElement = trace.getSourceElement();
                if (!(targetElement instanceof BlockArchitecture)) continue;
                targetBlock = (BlockArchitecture)targetElement;
            }
            if (targetBlock != null) {
                transfo.put((Object)"transfoSource", (Object)contextElement);
                transfo.put((Object)"transfoTarget", (Object)this.getTransitionedScenario((Scenario)contextElement, transfo));
                transfo.put((Object)"transfoTargetContainer", (Object)targetBlock);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidTransitionedScenario(Scenario contextElement_p, Scenario scenario_p) {
        BlockArchitecture targetBlock;
        BlockArchitecture sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement_p);
        if (!sourceBlock.equals(targetBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario_p))) {
            boolean isFSScenarioTarget;
            boolean isFSScenarioSource;
            if (scenario_p.getKind() == contextElement_p.getKind()) {
                return true;
            }
            if (sourceBlock instanceof OperationalAnalysis && (isFSScenarioSource = ScenarioExt.isFunctionalScenario((Scenario)contextElement_p)) == (isFSScenarioTarget = ScenarioExt.isFunctionalScenario((Scenario)scenario_p))) {
                return true;
            }
        }
        return false;
    }
}

