/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.DescriptionLinkParserHandler;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.InvalidNameHandler;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CapellaElementInDescriptionNameCheck
extends AbstractValidationRule {
    public IStatus validateElement(EObject element, String description, IValidationContext ctx) {
        ArrayList<IStatus> failureMessages = new ArrayList<IStatus>();
        InvalidNameHandler linkParser = new InvalidNameHandler(element, ctx);
        DescriptionLinkParserHandler descriptionParser = new DescriptionLinkParserHandler(element, ctx, linkParser);
        List<IStatus> exceptions = descriptionParser.process(description);
        List<IStatus> parserResult = linkParser.getResult();
        failureMessages.addAll(parserResult);
        failureMessages.addAll(exceptions);
        if (failureMessages.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, failureMessages);
    }

    public IStatus validate(IValidationContext ctx) {
        ArrayList<IStatus> failureMessages = new ArrayList<IStatus>();
        EObject target = ctx.getTarget();
        if (target instanceof CapellaElement) {
            CapellaElement capellaElement = (CapellaElement)target;
            IStatus currentElementStatus = this.validateElement((EObject)capellaElement, capellaElement.getDescription(), ctx);
            if (!currentElementStatus.isOK()) {
                failureMessages.add(currentElementStatus);
            }
            Session.of((EObject)target).ifPresent(session -> {
                Collection representationDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors(target, session);
                for (DRepresentationDescriptor dRepresentationDescriptor : representationDescriptors) {
                    IStatus currentRepresentationStatus = this.validateElement((EObject)dRepresentationDescriptor, dRepresentationDescriptor.getDocumentation(), ctx);
                    if (currentRepresentationStatus.isOK()) continue;
                    failureMessages.add(currentRepresentationStatus);
                }
            });
        }
        if (failureMessages.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, failureMessages);
    }
}

