/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.menu.dynamic;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.polarsys.capella.common.menu.dynamic.contributions.ActionContributionProvider;
import org.polarsys.capella.common.ui.menu.dynamic.AbstractActionProvider;
import org.polarsys.capella.core.menu.dynamic.DynamicActionContributionItem;
import org.polarsys.capella.core.menu.dynamic.DynamicCreationAction;
import org.polarsys.capella.core.menu.dynamic.Messages;

public class DynamicActionProvider
extends AbstractActionProvider {
    private static final String ADD_NEW_ELEMENT_MENU_ID = "capella.project.element.menu";
    protected DynamicCreationAction dynamicAction;

    public DynamicActionProvider() {
        ActionContributionProvider.getInstance();
    }

    protected void initActions(Shell shell, IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.dynamicAction = new DynamicCreationAction(shell, selectionProvider);
    }

    protected IContributionItem createContributionItem() {
        MenuManager subMenuManager = new MenuManager(Messages.DynamicActionProvider_AddCapellaElement_Title, ADD_NEW_ELEMENT_MENU_ID);
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IIdentifier identifier = activityManager.getIdentifier(ADD_NEW_ELEMENT_MENU_ID);
        if (identifier.isEnabled()) {
            this.fillContextMenu((IMenuManager)subMenuManager, this.dynamicAction, null);
        }
        return subMenuManager;
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.insertAfter("group.new", this.createContributionItem());
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    protected void fillContextMenu(IMenuManager menu, DynamicCreationAction action, String groupId) {
        if (action.isSelectionCompatible()) {
            for (IContributionItem item : action.getStructuralDynamicActions()) {
                this.addContributionItem(menu, groupId, item);
            }
            menu.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action.getNonStructuralDynamicActions()) {
                this.addContributionItem(menu, groupId, containedAction);
            }
            menu.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action.getPropertyValueDynamicActions()) {
                this.addContributionItem(menu, groupId, containedAction);
            }
            menu.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action.getExtensionDynamicActions()) {
                this.addContributionItem(menu, groupId, containedAction);
            }
        }
    }

    protected void addContributionItem(IMenuManager menu, String groupId, IContributionItem item) {
        if (groupId != null) {
            menu.appendToGroup(groupId, item);
        } else {
            menu.add(item);
        }
    }

    protected void addAction(IMenuManager menu, String groupId, IAction action) {
        this.addContributionItem(menu, groupId, (IContributionItem)new DynamicActionContributionItem(action));
    }
}

