/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.ClassifierExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class OperationExt {
    public static ComponentArchitecture getRootComponentArchitecture(Operation operation) {
        ComponentArchitecture arch = null;
        if (operation != null) {
            Classifier owningClass = (Classifier)operation.eContainer();
            if (owningClass instanceof Class) {
                arch = StructureExt.getRootComponentArchitecture((Structure)((DataPkg)owningClass.eContainer()));
            } else if (owningClass instanceof Interface) {
                arch = StructureExt.getRootComponentArchitecture((Structure)((InterfacePkg)owningClass.eContainer()));
            }
        }
        return arch;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        BlockArchitecture arch = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof BlockArchitecture) {
                return (BlockArchitecture)container;
            }
            if (container instanceof Component) {
                arch = ComponentExt.getRootBlockArchitecture((ModelElement)((Component)container));
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootBlockArchitecture((Structure)container);
            } else if (container instanceof Classifier) {
                arch = ClassifierExt.getRootBlockArchitecture((ModelElement)((Classifier)container));
            } else {
                EObject container2 = container.eContainer();
                if (container2 != null) {
                    arch = OperationExt.getRootBlockArchitecture((ModelElement)container2);
                }
            }
        }
        return arch;
    }

    public static Component getRootComponent(Operation operation) {
        Component comp = null;
        if (operation != null) {
            Classifier owningClass = (Classifier)operation.eContainer();
            if (owningClass instanceof Class) {
                DataPkg ownerDataPkg = ClassExt.getOwnerDataPkg((Class)owningClass);
                comp = DataPkgExt.getRootComponent(ownerDataPkg);
            } else if (owningClass instanceof Interface) {
                comp = InterfacePkgExt.getRootComponent((InterfacePkg)owningClass.eContainer());
            }
        }
        return comp;
    }

    public static List<DataPkg> getAllDataPkgs(Operation operation) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>();
        if (operation != null) {
            SystemEngineering sysEng;
            BlockArchitecture arch = null;
            Classifier owningClass = (Classifier)operation.eContainer();
            if (owningClass instanceof Class) {
                arch = StructureExt.getRootBlockArchitecture((Structure)((DataPkg)owningClass.eContainer()));
            } else if (owningClass instanceof Interface) {
                arch = StructureExt.getRootBlockArchitecture((Structure)((InterfacePkg)owningClass.eContainer()));
            }
            if (arch != null) {
                if (arch instanceof LogicalArchitecture) {
                    list.add(((LogicalArchitecture)arch).getOwnedDataPkg());
                } else if (arch instanceof PhysicalArchitecture) {
                    list.add(((PhysicalArchitecture)arch).getOwnedDataPkg());
                } else if (arch instanceof EPBSArchitecture) {
                    list.add(((EPBSArchitecture)arch).getOwnedDataPkg());
                } else if (arch instanceof SystemAnalysis) {
                    list.add(((SystemAnalysis)arch).getOwnedDataPkg());
                } else if (arch instanceof SystemEngineering) {
                    SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)arch);
                    list.add(ca.getOwnedDataPkg());
                }
            }
            if ((sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)operation)) != null) {
                for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((CapellaElement)operation)) {
                    list.add(sharedPkg.getOwnedDataPkg());
                }
            }
        }
        return list;
    }

    public static List<DataPkg> getDataPkgsFromSharedPkg(Operation operation) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)operation);
        if (sysEng != null) {
            for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((CapellaElement)operation)) {
                list.add(sharedPkg.getOwnedDataPkg());
            }
        }
        return list;
    }

    public static List<EObject> getAllInterfaces(Operation operation) {
        InterfacePkg interfacePkg;
        BlockArchitecture arch;
        Classifier owningInterface;
        List<EObject> list = new ArrayList<EObject>();
        if (operation != null && (owningInterface = (Classifier)operation.eContainer()) instanceof Interface && (arch = InterfacePkgExt.getRootBlockArchitecture((ModelElement)(interfacePkg = (InterfacePkg)owningInterface.eContainer()))) != null) {
            if (arch instanceof LogicalArchitecture) {
                list.addAll(BlockArchitectureExt.getAllInterfaces((BlockArchitecture)((LogicalArchitecture)arch)));
            } else if (arch instanceof PhysicalArchitecture) {
                list.addAll(PhysicalArchitectureExt.getAllInterfaces(arch, null, false));
            } else if (arch instanceof SystemAnalysis) {
                list.addAll(InterfacePkgExt.getAllInterfaces(((SystemAnalysis)arch).getOwnedInterfacePkg()));
            }
        }
        list = ListExt.removeDuplicates(list);
        return list;
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(Operation operation) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (operation != null) {
            Component parentComp;
            BlockArchitecture compArch = OperationExt.getRootBlockArchitecture((ModelElement)operation);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = OperationExt.getRootComponent(operation)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromParentHierarchy(Operation operation) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (operation != null) {
            Component parentComp;
            BlockArchitecture compArch = OperationExt.getRootBlockArchitecture((ModelElement)operation);
            if (compArch != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(compArch.getOwnedInterfacePkg()));
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch, true));
            }
            if ((parentComp = OperationExt.getRootComponent(operation)) != null) {
                if (parentComp instanceof LogicalComponent) {
                    list.addAll(InterfacePkgExt.getAllInterfaces(((LogicalComponent)parentComp).getOwnedInterfacePkg()));
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent(parentComp, true));
            }
        }
        return list;
    }
}

