/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;

public abstract class Graph<GS, NS, ES, N extends GraphNode<NS, E>, E extends GraphEdge<ES, N>> {
    protected GS semantic;
    protected HashMap<NS, N> nodes = new HashMap();
    protected HashMap<ES, E> edges = new HashMap();

    public Graph(GS semantic) {
        this.semantic = semantic;
    }

    public GS getSemantic() {
        return this.semantic;
    }

    public Map<ES, E> getEdges() {
        return this.edges;
    }

    public Map<NS, N> getNodes() {
        return this.nodes;
    }

    public boolean hasNode(NS semantic) {
        return this.nodes.containsKey(semantic);
    }

    public N getOrCreateNode(NS semantic) {
        return (N)this.nodes.computeIfAbsent(semantic, this::createNode);
    }

    public boolean hasEdge(ES semantic) {
        return this.edges.containsKey(semantic);
    }

    public E getOrCreateEdge(ES semantic) {
        return (E)this.edges.computeIfAbsent(semantic, this::createEdge);
    }

    public abstract N createNode(NS var1);

    public abstract E createEdge(ES var1);

    public N mergeNodes(N node, N node2, NS newSemantic) {
        N result = this.createNode(newSemantic);
        for (GraphEdge e : new ArrayList(((GraphNode)node).getIncomingEdges())) {
            e.setTarget(result);
        }
        for (GraphEdge e : new ArrayList(((GraphNode)node).getOutgoingEdges())) {
            e.setSource(result);
        }
        for (GraphEdge e : new ArrayList(((GraphNode)node2).getIncomingEdges())) {
            e.setTarget(result);
        }
        for (GraphEdge e : new ArrayList(((GraphNode)node2).getOutgoingEdges())) {
            e.setSource(result);
        }
        this.nodes.remove(((GraphNode)node).semantic);
        this.nodes.remove(((GraphNode)node2).semantic);
        this.nodes.put(newSemantic, result);
        return result;
    }

    public void removeEdge(E edge) {
        ((GraphEdge)edge).setSource(null);
        ((GraphEdge)edge).setTarget(null);
        this.edges.remove(((GraphEdge)edge).semantic, edge);
    }

    public String toString() {
        String n = this.nodes.values().stream().map(GraphNode::toString).collect(Collectors.joining("\n  "));
        String e = this.edges.values().stream().map(GraphEdge::toString).collect(Collectors.joining("\n  "));
        return "g(\n  " + n + "\n  " + e + "\n)";
    }
}

