/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class TechnicalInterfaceRepresentAllCommunicationLinks
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Interface interfaze;
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Interface && !(interfaze = (Interface)eObj).isStructural()) {
            EList userComponents = interfaze.getUserComponents();
            EList implementorComponents = interfaze.getImplementorComponents();
            if (userComponents.size() > 0 && implementorComponents.size() > 0) {
                Component userComponent = (Component)userComponents.get(0);
                Component implementorComponent = (Component)implementorComponents.get(0);
                ArrayList<ExchangeItem> errorInfos = new ArrayList<ExchangeItem>();
                errorInfos.addAll(this.check(interfaze, (EList<CommunicationLink>)userComponent.getTransmit(), (EList<CommunicationLink>)implementorComponent.getAcquire()));
                errorInfos.addAll(this.check(interfaze, (EList<CommunicationLink>)userComponent.getSend(), (EList<CommunicationLink>)implementorComponent.getReceive()));
                errorInfos.addAll(this.check(interfaze, (EList<CommunicationLink>)userComponent.getProduce(), (EList<CommunicationLink>)implementorComponent.getConsume()));
                errorInfos.addAll(this.check(interfaze, (EList<CommunicationLink>)userComponent.getCall(), (EList<CommunicationLink>)implementorComponent.getExecute()));
                errorInfos.addAll(this.check(interfaze, (EList<CommunicationLink>)userComponent.getWrite(), (EList<CommunicationLink>)implementorComponent.getAccess()));
                if (errorInfos.size() > 0) {
                    StringBuilder b = new StringBuilder();
                    int i = 0;
                    while (i < errorInfos.size()) {
                        b.append(CapellaElementExt.getCapellaExplorerLabel((EObject)((EObject)errorInfos.get(i))));
                        if (i < errorInfos.size() - 1) {
                            b.append(", ");
                        }
                        ++i;
                    }
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)interfaze), CapellaElementExt.getCapellaExplorerLabel((EObject)userComponent), CapellaElementExt.getCapellaExplorerLabel((EObject)implementorComponent), b.toString()});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private List<ExchangeItem> check(Interface interfaze, EList<CommunicationLink> linksFromLeft, EList<CommunicationLink> linksFromRight) {
        ArrayList<ExchangeItem> items = new ArrayList<ExchangeItem>();
        List<ExchangeItem> itemsFromRight = this.getExchangeItems((List<CommunicationLink>)linksFromRight);
        for (ExchangeItem it : this.getExchangeItems((List<CommunicationLink>)linksFromLeft)) {
            if (!itemsFromRight.contains(it) || interfaze.getExchangeItems().contains((Object)it)) continue;
            items.add(it);
        }
        return items;
    }

    private List<ExchangeItem> getExchangeItems(List<CommunicationLink> links) {
        ArrayList<ExchangeItem> exchangeItems = new ArrayList<ExchangeItem>();
        for (CommunicationLink communicationLink : links) {
            exchangeItems.add(communicationLink.getExchangeItem());
        }
        return exchangeItems;
    }
}

